/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRenderedImage;
import java.util.Iterator;
import java.util.Optional;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.j2d.ColorModelFactory;
import org.apache.sis.coverage.grid.j2d.ImageLayout;
import org.apache.sis.coverage.grid.j2d.ImageUtilities;
import org.apache.sis.coverage.internal.MultiSourceArgument;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.image.BandAggregateImage;
import org.apache.sis.image.BandSelectImage;
import org.apache.sis.image.Colorizer;
import org.apache.sis.util.collection.FrequencySortedSet;

final class MultiSourceLayout
extends ImageLayout {
    private final RenderedImage[] sources;
    final RenderedImage[] filteredSources;
    private final int[][] bandsPerSource;
    final int[] bandSelect;
    final BandedSampleModel sampleModel;
    final Rectangle domain;
    final int minTileX;
    final int minTileY;
    private final boolean exactTileSize;

    static MultiSourceLayout create(RenderedImage[] sources, int[][] bandsPerSource, boolean allowSharing) {
        MultiSourceArgument<RenderedImage> aggregate = new MultiSourceArgument<RenderedImage>(sources, bandsPerSource);
        aggregate.unwrap(BandAggregateImage::unwrap);
        aggregate.validate(ImageUtilities::getNumBands);
        int[] bandSelect = aggregate.mergeDuplicatedSources();
        sources = aggregate.sources();
        bandsPerSource = aggregate.bandsPerSource(true);
        Rectangle domain = null;
        int scanlineStride = 0;
        int tileWidth = 0;
        int tileHeight = 0;
        int tileAlignX = 0;
        int tileAlignY = 0;
        int commonDataType = 32;
        for (RenderedImage source : sources) {
            ComponentSampleModel csm;
            SampleModel sm = source.getSampleModel();
            if (allowSharing && (allowSharing = sm instanceof ComponentSampleModel) && (allowSharing = (csm = (ComponentSampleModel)sm).getPixelStride() == 1)) {
                allowSharing &= scanlineStride == (scanlineStride = csm.getScanlineStride());
                int n = tileWidth;
                tileWidth = source.getTileWidth();
                allowSharing &= n == tileWidth;
                int n2 = tileHeight;
                tileHeight = source.getTileHeight();
                allowSharing &= n2 == tileHeight;
                int n3 = tileAlignX;
                tileAlignX = Math.floorMod(source.getTileGridXOffset(), tileWidth);
                allowSharing &= n3 == tileAlignX;
                int n4 = tileAlignY;
                tileAlignY = Math.floorMod(source.getTileGridYOffset(), tileHeight);
                allowSharing &= n4 == tileAlignY;
                allowSharing |= domain == null;
            }
            int dataType = sm.getDataType();
            if (domain == null) {
                domain = ImageUtilities.getBounds(source);
                commonDataType = dataType;
                continue;
            }
            if (dataType != commonDataType) {
                throw new IllegalArgumentException(Resources.format((short)42));
            }
            ImageUtilities.clipBounds(source, domain);
            if (!domain.isEmpty()) continue;
            throw new DisjointExtentException(Resources.format((short)80));
        }
        if (domain == null) {
            throw new IllegalArgumentException(Resources.format((short)81));
        }
        long cy = 9223372032559808768L;
        long cx = 9223372032559808768L;
        FrequencySortedSet tileGridXOffset = new FrequencySortedSet(true);
        FrequencySortedSet tileGridYOffset = new FrequencySortedSet(true);
        for (RenderedImage source : sources) {
            cx = MultiSourceLayout.chooseTileSize(cx, source.getTileWidth(), domain.width, domain.x - source.getMinX());
            cy = MultiSourceLayout.chooseTileSize(cy, source.getTileHeight(), domain.height, domain.y - source.getMinY());
            tileGridXOffset.add((Object)source.getTileGridXOffset());
            tileGridYOffset.add((Object)source.getTileGridYOffset());
        }
        Dimension preferredTileSize = new Dimension((int)cx, (int)cy);
        boolean exactTileSize = (cx | cy) >>> 32 == 0L;
        return new MultiSourceLayout(sources, bandsPerSource, bandSelect, domain, preferredTileSize, exactTileSize, MultiSourceLayout.chooseMinTile((FrequencySortedSet<Integer>)tileGridXOffset, domain.x, preferredTileSize.width), MultiSourceLayout.chooseMinTile((FrequencySortedSet<Integer>)tileGridYOffset, domain.y, preferredTileSize.height), commonDataType, aggregate.numBands(), (allowSharing &= exactTileSize) ? scanlineStride : 0);
    }

    private MultiSourceLayout(RenderedImage[] sources, int[][] bandsPerSource, int[] bandSelect, Rectangle domain, Dimension preferredTileSize, boolean exactTileSize, int minTileX, int minTileY, int commonDataType, int numBands, int scanlineStride) {
        super(preferredTileSize, false);
        this.exactTileSize = exactTileSize;
        this.bandsPerSource = bandsPerSource;
        this.bandSelect = bandSelect;
        this.sources = sources;
        this.domain = domain;
        this.minTileX = minTileX;
        this.minTileY = minTileY;
        this.sampleModel = this.createBandedSampleModel(commonDataType, numBands, null, domain, scanlineStride);
        this.filteredSources = new RenderedImage[sources.length];
        for (int i = 0; i < this.filteredSources.length; ++i) {
            RenderedImage source = sources[i];
            int[] bands = bandsPerSource[i];
            if (bands != null) {
                source = BandSelectImage.create(source, true, bands);
            }
            this.filteredSources[i] = source;
        }
    }

    private static long chooseTileSize(long current, int tileSize, int imageSize, int offset) {
        if (imageSize % tileSize == 0) {
            long c = Math.floorMod(offset, tileSize);
            c <<= 32;
            if (Long.compareUnsigned(c |= (long)tileSize, current) < 0) {
                return c;
            }
        }
        return current;
    }

    private static int chooseMinTile(FrequencySortedSet<Integer> offsets, int min, int tileSize) {
        Iterator iterator = offsets.iterator();
        while (iterator.hasNext()) {
            int offset = (Integer)iterator.next();
            if ((offset = min - offset) % tileSize != 0) continue;
            return offset / tileSize;
        }
        return 0;
    }

    @Override
    public Point getMinTile() {
        return new Point(this.minTileX, this.minTileY);
    }

    @Override
    public Dimension suggestTileSize(int imageWidth, int imageHeight, boolean allowPartialTiles) {
        if (this.exactTileSize) {
            return this.getPreferredTileSize();
        }
        return super.suggestTileSize(imageWidth, imageHeight, allowPartialTiles);
    }

    @Override
    public Dimension suggestTileSize(RenderedImage image, Rectangle bounds, boolean allowPartialTiles) {
        if (this.exactTileSize) {
            return this.getPreferredTileSize();
        }
        return super.suggestTileSize(image, bounds, allowPartialTiles);
    }

    final boolean isWritable() {
        for (RenderedImage source : this.filteredSources) {
            if (source instanceof WritableRenderedImage) continue;
            return false;
        }
        return true;
    }

    final ColorModel createColorModel(Colorizer colorizer) {
        Optional<ColorModel> candidate;
        ColorModel colors = null;
        int visibleBand = 0;
        int base = 0;
        block0: for (int i = 0; i < this.sources.length; ++i) {
            RenderedImage source = this.sources[i];
            int[] bands = this.bandsPerSource[i];
            int vb = ImageUtilities.getVisibleBand(source);
            if (vb >= 0) {
                if (bands == null) {
                    visibleBand = base + vb;
                    colors = source.getColorModel();
                    break;
                }
                for (int j = 0; j < bands.length; ++j) {
                    if (bands[j] != vb) continue;
                    visibleBand = base + j;
                    colors = source.getColorModel();
                    break block0;
                }
            }
            base += bands != null ? bands.length : ImageUtilities.getNumBands(source);
        }
        if (colorizer != null && (candidate = colorizer.apply(new Colorizer.Target(this.sampleModel, null, visibleBand))).isPresent()) {
            return candidate.get();
        }
        if ((colors = ColorModelFactory.derive(colors, this.sampleModel.getNumBands(), visibleBand)) != null) {
            return colors;
        }
        return ColorModelFactory.createGrayScale(this.sampleModel, visibleBand, null);
    }
}

