/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid.j2d;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRenderedImage;
import java.util.Arrays;
import org.apache.sis.coverage.grid.j2d.RasterFactory;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.resources.Errors;

public class ImageLayout {
    private static final int MIN_TILE_SIZE = 180;
    public static final ImageLayout DEFAULT = new ImageLayout(null, false);
    public static final ImageLayout SIZE_ADJUST = new ImageLayout(null, true);
    protected final int preferredTileWidth;
    protected final int preferredTileHeight;
    public final boolean isBoundsAdjustmentAllowed;

    public ImageLayout(Dimension preferredTileSize, boolean isBoundsAdjustmentAllowed) {
        if (preferredTileSize != null) {
            this.preferredTileWidth = Math.max(1, preferredTileSize.width);
            this.preferredTileHeight = Math.max(1, preferredTileSize.height);
        } else {
            this.preferredTileWidth = 256;
            this.preferredTileHeight = 256;
        }
        this.isBoundsAdjustmentAllowed = isBoundsAdjustmentAllowed;
    }

    public static ImageLayout forTileSize(RenderedImage source) {
        return new FixedSize(source, source.getMinTileX(), source.getMinTileY());
    }

    public static ImageLayout forDestination(WritableRenderedImage source, int minTileX, int minTileY) {
        return new FixedDestination(source, minTileX, minTileY);
    }

    public final Dimension getPreferredTileSize() {
        return new Dimension(this.preferredTileWidth, this.preferredTileHeight);
    }

    private static int toTileSize(int imageSize, int preferredTileSize, boolean allowPartialTiles) {
        int maxTileSize = 2 * preferredTileSize;
        if (imageSize <= maxTileSize) {
            return imageSize;
        }
        int rmax = imageSize % preferredTileSize;
        if (rmax == 0) {
            return preferredTileSize;
        }
        int[] divisors = MathFunctions.divisors((int)imageSize);
        int i = Arrays.binarySearch(divisors, preferredTileSize);
        if ((i ^= 0xFFFFFFFF) < divisors.length) {
            boolean tooSmall;
            int smaller;
            if (i == 0) {
                smaller = 0;
                tooSmall = true;
            } else {
                smaller = divisors[i - 1];
                tooSmall = smaller < 180;
            }
            int larger = divisors[i];
            if (larger <= (allowPartialTiles ? maxTileSize : imageSize) && (tooSmall || larger - preferredTileSize <= preferredTileSize - smaller)) {
                return larger;
            }
            if (!tooSmall) {
                return smaller;
            }
        }
        if (!allowPartialTiles) {
            return imageSize;
        }
        int best = preferredTileSize;
        i = maxTileSize;
        while (--i >= 180) {
            int r = imageSize % i;
            if (r <= rmax && (r != rmax || Math.abs(i - preferredTileSize) >= Math.abs(best - preferredTileSize))) continue;
            rmax = r;
            best = i;
        }
        return best;
    }

    public Dimension suggestTileSize(int imageWidth, int imageHeight, boolean allowPartialTiles) {
        return new Dimension(ImageLayout.toTileSize(imageWidth, this.preferredTileWidth, allowPartialTiles), ImageLayout.toTileSize(imageHeight, this.preferredTileHeight, allowPartialTiles));
    }

    public Dimension suggestTileSize(RenderedImage image, Rectangle bounds, boolean allowPartialTiles) {
        int height;
        int width;
        boolean singleYTile;
        boolean singleXTile;
        if (bounds != null && bounds.isEmpty()) {
            throw new IllegalArgumentException(Errors.format((short)29, (Object)"bounds"));
        }
        if (allowPartialTiles && image != null && !this.isBoundsAdjustmentAllowed) {
            ColorModel cm = image.getColorModel();
            boolean bl = allowPartialTiles = cm != null;
            if (allowPartialTiles) {
                if (cm instanceof IndexColorModel) {
                    allowPartialTiles = ((IndexColorModel)cm).getTransparentPixel() == 0;
                } else {
                    boolean bl2 = allowPartialTiles = cm.getTransparency() != 1;
                }
            }
        }
        if (bounds != null) {
            singleXTile = true;
            singleYTile = true;
            width = bounds.width;
            height = bounds.height;
        } else if (image != null) {
            singleXTile = image.getNumXTiles() <= 1;
            singleYTile = image.getNumYTiles() <= 1;
            width = singleXTile ? image.getWidth() : image.getTileWidth();
            height = singleYTile ? image.getHeight() : image.getTileHeight();
        } else {
            return this.getPreferredTileSize();
        }
        Dimension tileSize = new Dimension(ImageLayout.toTileSize(width, this.preferredTileWidth, allowPartialTiles & singleXTile), ImageLayout.toTileSize(height, this.preferredTileHeight, allowPartialTiles & singleYTile));
        if (this.isBoundsAdjustmentAllowed && bounds != null && !bounds.isEmpty()) {
            int sx = ImageLayout.sizeToAdd(bounds.width, tileSize.width);
            int sy = ImageLayout.sizeToAdd(bounds.height, tileSize.height);
            if ((bounds.width += sx) < 0) {
                bounds.width -= tileSize.width;
            }
            if ((bounds.height += sy) < 0) {
                bounds.height -= tileSize.height;
            }
            bounds.translate(-sx / 2, -sy / 2);
        }
        return tileSize;
    }

    private static int sizeToAdd(int size, int tileSize) {
        if ((size %= tileSize) != 0) {
            size = tileSize - size;
        }
        return size;
    }

    public BandedSampleModel createBandedSampleModel(int dataType, int numBands, RenderedImage image, Rectangle bounds, int scanlineStride) {
        Dimension tileSize = this.suggestTileSize(image, bounds, this.isBoundsAdjustmentAllowed);
        if (scanlineStride <= 0) {
            scanlineStride = tileSize.width;
        }
        return RasterFactory.unique(new BandedSampleModel(dataType, tileSize.width, tileSize.height, scanlineStride, ArraysExt.range((int)0, (int)numBands), new int[numBands]));
    }

    public SampleModel createCompatibleSampleModel(RenderedImage image, Rectangle bounds) {
        ArgumentChecks.ensureNonNull((String)"image", (Object)image);
        Dimension tile = this.suggestTileSize(image, bounds, this.isBoundsAdjustmentAllowed);
        SampleModel sm = image.getSampleModel();
        if (sm.getWidth() != tile.width || sm.getHeight() != tile.height) {
            sm = sm.createCompatibleSampleModel(tile.width, tile.height);
            sm = RasterFactory.unique(sm);
        }
        return sm;
    }

    public Point getMinTile() {
        return null;
    }

    public WritableRenderedImage getDestination() {
        return null;
    }

    public String toString() {
        return Strings.toString(this.getClass(), (Object[])new Object[]{"preferredTileSize", new StringBuilder().append(this.preferredTileWidth).append('\u00d7').append(this.preferredTileHeight), "isBoundsAdjustmentAllowed", this.isBoundsAdjustmentAllowed});
    }

    private static class FixedSize
    extends ImageLayout {
        private final int minTileX;
        private final int minTileY;

        FixedSize(RenderedImage source, int minTileX, int minTileY) {
            super(new Dimension(source.getTileWidth(), source.getTileHeight()), false);
            this.minTileX = minTileX;
            this.minTileY = minTileY;
        }

        @Override
        public Dimension suggestTileSize(int imageWidth, int imageHeight, boolean allowPartialTiles) {
            return this.getPreferredTileSize();
        }

        @Override
        public Dimension suggestTileSize(RenderedImage image, Rectangle bounds, boolean allowPartialTiles) {
            return this.getPreferredTileSize();
        }

        @Override
        public Point getMinTile() {
            return new Point(this.minTileX, this.minTileY);
        }
    }

    private static final class FixedDestination
    extends FixedSize {
        private final WritableRenderedImage destination;

        FixedDestination(WritableRenderedImage destination, int minTileX, int minTileY) {
            super(destination, minTileX, minTileY);
            this.destination = destination;
        }

        @Override
        public WritableRenderedImage getDestination() {
            return this.destination;
        }

        @Override
        public SampleModel createCompatibleSampleModel(RenderedImage image, Rectangle bounds) {
            return this.destination.getSampleModel();
        }
    }
}

