/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.portrayal;

import java.awt.geom.AffineTransform;
import java.util.Locale;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.geometry.Envelope2D;
import org.apache.sis.portrayal.Canvas;
import org.apache.sis.portrayal.TransformChangeEvent;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.util.j2d.AffineTransform2D;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.referencing.operation.Matrix;

public abstract class PlanarCanvas
extends Canvas {
    protected static final int BIDIMENSIONAL = 2;
    protected final AffineTransform objectiveToDisplay = new AffineTransform();

    protected PlanarCanvas(Locale locale) {
        super(CommonCRS.Engineering.DISPLAY.crs(), locale);
    }

    @Override
    final int getDisplayDimensions() {
        return 2;
    }

    @Override
    final void getDisplayAxes(DimensionNameType[] axisTypes) {
        axisTypes[0] = DimensionNameType.COLUMN;
        axisTypes[1] = DimensionNameType.ROW;
    }

    @Override
    final DirectPosition allocatePosition() {
        return new DirectPosition2D(super.getObjectiveCRS());
    }

    public Envelope2D getDisplayBounds() {
        return this.displayBounds.isAllNaN() ? null : new Envelope2D((Envelope)this.displayBounds);
    }

    @Override
    final LinearTransform createObjectiveToDisplay() {
        return new AffineTransform2D(this.objectiveToDisplay);
    }

    @Override
    final void setObjectiveToDisplayImpl(LinearTransform newValue) {
        this.objectiveToDisplay.setTransform(AffineTransforms2D.castOrCopy((Matrix)newValue.getMatrix()));
        super.setObjectiveToDisplayImpl(newValue);
    }

    public void transformObjectiveCoordinates(AffineTransform before) {
        if (!before.isIdentity()) {
            LinearTransform old = this.hasPropertyChangeListener("objectiveToDisplay") ? this.getObjectiveToDisplay() : null;
            this.objectiveToDisplay.concatenate(before);
            super.setObjectiveToDisplayImpl(null);
            if (old != null) {
                this.firePropertyChange(new TransformChangeEvent(this, old, null, before, null, TransformChangeEvent.Reason.OBJECTIVE_NAVIGATION));
            }
        }
    }

    public void transformDisplayCoordinates(AffineTransform after) {
        if (!after.isIdentity()) {
            LinearTransform old = this.hasPropertyChangeListener("objectiveToDisplay") ? this.getObjectiveToDisplay() : null;
            this.objectiveToDisplay.preConcatenate(after);
            super.setObjectiveToDisplayImpl(null);
            if (old != null) {
                this.firePropertyChange(new TransformChangeEvent(this, old, null, null, after, TransformChangeEvent.Reason.DISPLAY_NAVIGATION));
            }
        }
    }
}

