/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.portrayal;

import java.util.Optional;
import java.util.OptionalDouble;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.portrayal.Canvas;
import org.apache.sis.referencing.operation.CoordinateOperationContext;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.util.Formulas;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

final class CanvasContext
extends CoordinateOperationContext {
    private static final double DISPLAY_RESOLUTION = 1.0;
    private CoordinateOperation objectiveToGeographic;
    private GeographicBoundingBox geographicArea;
    private double resolution;

    CanvasContext() {
    }

    final void setObjectiveToGeographic(CoordinateOperation op) {
        this.objectiveToGeographic = op;
        this.clear();
    }

    final void clear() {
        this.geographicArea = null;
        this.resolution = 0.0;
    }

    final void partialClear(boolean poi) {
        if (poi) {
            this.resolution = 0.0;
        } else {
            this.geographicArea = null;
        }
    }

    final Optional<GeographicBoundingBox> getGeographicArea(Canvas canvas) throws TransformException {
        if (this.geographicArea != null) {
            return Optional.of(this.geographicArea);
        }
        this.recompute(canvas);
        return Optional.ofNullable(this.geographicArea);
    }

    final OptionalDouble getSpatialResolution(Canvas canvas) throws TransformException {
        if (!(this.resolution > 0.0)) {
            this.recompute(canvas);
            if (!(this.resolution > 0.0)) {
                return OptionalDouble.empty();
            }
        }
        return OptionalDouble.of(this.resolution);
    }

    private void recompute(Canvas canvas) throws TransformException {
        double[] poi;
        if (this.objectiveToGeographic == null) {
            return;
        }
        LinearTransform objectiveToDisplay = canvas.getObjectiveToDisplay();
        MathTransform displayToGeographic = MathTransforms.concatenate((MathTransform)objectiveToDisplay.inverse(), (MathTransform)this.objectiveToGeographic.getMathTransform());
        if (this.geographicArea == null && !canvas.displayBounds.isAllNaN()) {
            GeneralEnvelope bounds = Envelopes.transform((MathTransform)displayToGeographic, (Envelope)canvas.displayBounds);
            bounds.setCoordinateReferenceSystem(this.objectiveToGeographic.getTargetCRS());
            DefaultGeographicBoundingBox bbox = new DefaultGeographicBoundingBox();
            bbox.setBounds((Envelope)bounds);
            bbox.transitionTo(ModifiableMetadata.State.FINAL);
            this.geographicArea = bbox;
        }
        if (!(this.resolution > 0.0) && (poi = canvas.getObjectivePOI()) != null) {
            objectiveToDisplay.transform(poi, 0, poi, 0, 1);
            Matrix derivative = MathTransforms.derivativeAndTransform((MathTransform)displayToGeographic, (double[])poi, (int)0, (double[])poi, (int)0);
            double[] vector = new double[derivative.getNumCol()];
            double[] combined = new double[derivative.getNumRow()];
            int j = combined.length;
            while (--j >= 0) {
                for (int i = 0; i < vector.length; ++i) {
                    vector[i] = derivative.getElement(j, i);
                }
                double m = MathFunctions.magnitude((double[])vector);
                switch (j) {
                    case 0: {
                        m *= Math.cos(combined[1]);
                    }
                    case 1: {
                        m = Math.toRadians(m);
                    }
                }
                combined[j] = m;
            }
            Ellipsoid ellipsoid = ((GeographicCRS)this.objectiveToGeographic.getTargetCRS()).getDatum().getEllipsoid();
            double radius = Formulas.radiusOfConformalSphere((Ellipsoid)ellipsoid, (double)combined[1]);
            radius = ellipsoid.getAxisUnit().getConverterTo(Units.METRE).convert(radius);
            this.resolution = MathFunctions.magnitude((double[])combined) * radius;
        }
    }

    final void refresh(Canvas canvas) throws TransformException {
        this.recompute(canvas);
        this.setAreaOfInterest(this.geographicArea);
        this.setDesiredAccuracy(this.resolution * 1.0);
    }
}

