/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.xml.stream;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Map;
import java.util.function.Consumer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.io.stream.IOUtilities;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.xml.stream.NamespaceEraser;
import org.apache.sis.storage.xml.stream.StaxDataStore;
import org.apache.sis.storage.xml.stream.StaxStreamIO;
import org.apache.sis.util.collection.BackingStoreException;

public abstract class StaxStreamWriter
extends StaxStreamIO
implements Consumer<AbstractFeature> {
    protected final XMLStreamWriter writer;
    private Marshaller marshaller;

    protected StaxStreamWriter(StaxDataStore owner, OutputStream temporary) throws DataStoreException, XMLStreamException, IOException {
        super(owner);
        this.writer = owner.createWriter(this, temporary);
    }

    public void writeStartDocument() throws Exception {
        Charset encoding = this.owner.encoding;
        if (encoding != null) {
            this.writer.writeStartDocument(encoding.name(), null);
        } else {
            this.writer.writeStartDocument();
        }
    }

    public void writeEndDocument() throws Exception {
        this.writer.writeEndDocument();
    }

    public abstract void write(AbstractFeature var1) throws Exception;

    @Override
    public void accept(AbstractFeature feature) throws BackingStoreException {
        try {
            this.write(feature);
        }
        catch (BackingStoreException e) {
            throw e;
        }
        catch (Exception e2) {
            IOException e2;
            if (e2 instanceof UncheckedIOException) {
                e2 = ((UncheckedIOException)e2).getCause();
            }
            throw new BackingStoreException(this.errors().getString((short)17, (Object)this.owner.getFormatName(), (Object)this.owner.getDisplayName()), (Throwable)e2);
        }
    }

    protected final void writeSingleValue(String localName, Object value) throws XMLStreamException {
        if (value != null) {
            this.writer.writeStartElement(localName);
            this.writer.writeCharacters(value.toString());
            this.writer.writeEndElement();
        }
    }

    protected final void writeSingle(String localName, Date value) throws XMLStreamException {
        if (value != null) {
            this.writeSingleValue(localName, value.toInstant());
        }
    }

    protected final void writeList(String localName, Iterable<?> values) throws XMLStreamException {
        if (values != null) {
            StringBuilder buffer = new StringBuilder();
            for (Object value : values) {
                if (value == null) continue;
                int length = buffer.length();
                if (length != 0 && buffer.charAt(length - 1) != ' ') {
                    buffer.append(' ');
                }
                buffer.append(value);
            }
            this.writeSingleValue(localName, buffer.toString());
        }
    }

    protected final <T> void marshal(String hideNS, String name, Class<T> type, T object) throws XMLStreamException, JAXBException {
        QName qn;
        Marshaller m = this.marshaller;
        if (m == null) {
            m = this.getMarshallerPool().acquireMarshaller();
            m.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            m.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
            Charset encoding = this.owner.encoding;
            if (encoding != null) {
                m.setProperty("jaxb.encoding", (Object)encoding.name());
            }
            for (Map.Entry entry : this.owner.configuration.entrySet()) {
                m.setProperty((String)entry.getKey(), entry.getValue());
            }
        }
        Object out = this.writer;
        if (hideNS != null) {
            out = new NamespaceEraser((XMLStreamWriter)out, hideNS);
            qn = new QName(hideNS, name);
        } else {
            qn = new QName(name);
        }
        this.marshaller = null;
        m.marshal((Object)new JAXBElement(qn, type, object), out);
        this.marshaller = m;
    }

    @Override
    public void close() throws JAXBException, XMLStreamException, IOException {
        Marshaller m = this.marshaller;
        if (m != null) {
            this.marshaller = null;
            this.getMarshallerPool().recycle(m);
        }
        this.writer.close();
        IOUtilities.truncate((AutoCloseable)this.stream);
        super.close();
    }
}

