/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.xml.stream;

import java.util.Arrays;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.sis.xml.util.StreamWriterDelegate;

final class FormattedWriter
extends StreamWriterDelegate {
    private static final char[] SPACES = new char[12];
    private final String lineSeparator;
    private final int indentation;
    private int margin;
    private boolean inline;

    FormattedWriter(XMLStreamWriter out, int indentation) throws XMLStreamException {
        super(out);
        this.indentation = indentation;
        this.lineSeparator = System.lineSeparator();
    }

    private void indent() throws XMLStreamException {
        int n;
        this.out.writeCharacters(this.lineSeparator);
        int length = SPACES.length;
        for (n = this.margin; n > length; n -= length) {
            this.out.writeCharacters(SPACES, 0, length);
        }
        this.out.writeCharacters(SPACES, 0, n);
    }

    private void emptyIndent() throws XMLStreamException {
        this.indent();
        this.inline = false;
    }

    final void startIndent() throws XMLStreamException {
        this.indent();
        this.inline = true;
        this.margin += this.indentation;
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        this.startIndent();
        this.out.writeStartElement(localName);
    }

    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.startIndent();
        this.out.writeStartElement(namespaceURI, localName);
    }

    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.startIndent();
        this.out.writeStartElement(prefix, localName, namespaceURI);
    }

    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.emptyIndent();
        this.out.writeEmptyElement(namespaceURI, localName);
    }

    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.emptyIndent();
        this.out.writeEmptyElement(prefix, localName, namespaceURI);
    }

    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.emptyIndent();
        this.out.writeEmptyElement(localName);
    }

    public void writeEndElement() throws XMLStreamException {
        this.margin -= this.indentation;
        if (!this.inline) {
            this.indent();
        }
        this.inline = false;
        this.out.writeEndElement();
    }

    public void writeEndDocument() throws XMLStreamException {
        this.out.writeCharacters(this.lineSeparator);
        this.out.writeEndDocument();
        this.out.writeCharacters(this.lineSeparator);
    }

    static {
        Arrays.fill(SPACES, ' ');
    }
}

