/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.opengis.util.GenericName;
import org.opengis.util.NameSpace;

public final class ResourceDefinition {
    private static volatile NameSpace tableNS;
    private final GenericName name;
    final String query;

    private ResourceDefinition(GenericName name, String query) {
        this.name = name;
        this.query = query;
    }

    static ResourceDefinition[] wrap(GenericName[] tableNames, Map<?, ?> queries) {
        int i;
        int tableCount = tableNames != null ? tableNames.length : 0;
        ResourceDefinition[] definitions = new ResourceDefinition[queries != null ? queries.size() + tableCount : tableCount];
        for (i = 0; i < tableCount; ++i) {
            GenericName name = tableNames[i];
            ArgumentChecks.ensureNonNullElement((String)"tables", (int)i, (Object)name);
            definitions[i] = new ResourceDefinition(name, null);
        }
        if (queries != null) {
            i = 0;
            for (Map.Entry<?, ?> entry : queries.entrySet()) {
                Object p = entry.getKey();
                ArgumentChecks.ensureNonNullElement((String)"queries[#].key", (int)i, p);
                GenericName name = p instanceof GenericName ? (GenericName)p : DefaultNameFactory.provider().createLocalName(null, (CharSequence)p.toString());
                p = entry.getValue();
                ArgumentChecks.ensureNonNullElement((String)"queries[#].value", (int)i, p);
                String sql = p.toString();
                ArgumentChecks.ensureNonEmpty((String)"sql", (CharSequence)sql);
                definitions[tableCount + i] = new ResourceDefinition(name, sql);
            }
        }
        return definitions;
    }

    public static ResourceDefinition table(String tablePattern) {
        return ResourceDefinition.table(null, null, tablePattern);
    }

    public static ResourceDefinition table(String catalog, String schemaPattern, String tablePattern) {
        int numParts;
        ArgumentChecks.ensureNonNull((String)"tablePattern", (Object)tablePattern);
        if (catalog != null) {
            numParts = 3;
            if (schemaPattern == null) {
                schemaPattern = "%";
            }
        } else {
            numParts = schemaPattern != null && !schemaPattern.equals("%") ? 2 : 1;
        }
        CharSequence[] names = new String[numParts];
        int i = 0;
        switch (numParts) {
            default: {
                throw new AssertionError(numParts);
            }
            case 3: {
                names[i++] = catalog;
            }
            case 2: {
                names[i++] = schemaPattern;
            }
            case 1: 
        }
        names[i] = tablePattern;
        DefaultNameFactory factory = DefaultNameFactory.provider();
        NameSpace ns = tableNS;
        if (ns == null) {
            Map<String, String> properties = Map.of("separator", ".", "separator.head", ":");
            tableNS = ns = factory.createNameSpace((GenericName)factory.createLocalName(null, (CharSequence)"database"), properties);
        }
        return new ResourceDefinition(factory.createGenericName(ns, names), null);
    }

    public static ResourceDefinition query(String name, String query) {
        ArgumentChecks.ensureNonEmpty((String)"name", (CharSequence)name);
        ArgumentChecks.ensureNonEmpty((String)"query", (CharSequence)query);
        DefaultNameFactory factory = DefaultNameFactory.provider();
        return new ResourceDefinition((GenericName)factory.createLocalName(null, (CharSequence)name), query);
    }

    public GenericName getName() {
        return this.name;
    }

    public Optional<String> getQuery() {
        return Optional.ofNullable(this.query);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ResourceDefinition) {
            ResourceDefinition other = (ResourceDefinition)obj;
            return this.name.equals(other.name) && Objects.equals(this.query, other.query);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() * 71 + Objects.hashCode(this.query);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("Resource[\"").append(this.name).append('\"');
        if (this.query != null) {
            b.append(" = ").append(this.query);
        }
        return b.append(']').toString();
    }
}

