/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.gazetteer;

import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.metadata.iso.citation.DefaultOrganisation;
import org.apache.sis.metadata.iso.extent.DefaultGeographicDescription;
import org.apache.sis.referencing.gazetteer.AbstractLocationType;
import org.apache.sis.referencing.gazetteer.ReferencingByIdentifiers;
import org.apache.sis.referencing.gazetteer.internal.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CorruptedObjectException;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.util.InternationalString;

public class ModifiableLocationType
extends AbstractLocationType {
    private final InternationalString name;
    private InternationalString theme;
    private final Map<String, InternationalString> identifications;
    private InternationalString definition;
    private GeographicExtent territoryOfUse;
    private AbstractParty owner;
    private final Map<String, ModifiableLocationType> parents;
    private final Map<String, ModifiableLocationType> children;

    public ModifiableLocationType(CharSequence name) {
        ArgumentChecks.ensureNonNull((String)"name", (Object)name);
        this.name = Types.toInternationalString((CharSequence)name);
        this.identifications = new LinkedHashMap<String, InternationalString>();
        this.parents = new LinkedHashMap<String, ModifiableLocationType>();
        this.children = new LinkedHashMap<String, ModifiableLocationType>();
    }

    @Override
    public InternationalString getName() {
        return this.name;
    }

    private <E> E inherit(Function<ModifiableLocationType, E> property) {
        E common = null;
        for (ModifiableLocationType parent : this.parents.values()) {
            Object value = property.apply(parent);
            if (value == null) continue;
            if (common == null) {
                common = (E)value;
                continue;
            }
            if (value.equals(common)) continue;
            return null;
        }
        return common;
    }

    @Override
    public InternationalString getTheme() {
        return this.theme != null ? this.theme : this.inherit(ModifiableLocationType::getTheme);
    }

    public void setTheme(CharSequence value) {
        this.theme = Types.toInternationalString((CharSequence)value);
    }

    public Collection<InternationalString> getIdentifications() {
        return this.identifications.isEmpty() ? this.inherit(ModifiableLocationType::getIdentifications) : Collections.unmodifiableCollection(this.identifications.values());
    }

    public void addIdentification(CharSequence value) {
        ArgumentChecks.ensureNonNull((String)"value", (Object)value);
        String key = value.toString();
        if (this.identifications.putIfAbsent(key, Types.toInternationalString((CharSequence)value)) != null) {
            throw new IllegalArgumentException(Errors.format((short)27, (Object)key));
        }
    }

    public void removeIdentification(CharSequence value) {
        ArgumentChecks.ensureNonNull((String)"value", (Object)value);
        String key = value.toString();
        if (this.identifications.remove(key) == null) {
            throw new IllegalArgumentException(Errors.format((short)28, (Object)key));
        }
    }

    @Override
    public InternationalString getDefinition() {
        return this.definition != null ? this.definition : this.inherit(ModifiableLocationType::getDefinition);
    }

    public void setDefinition(CharSequence value) {
        this.definition = Types.toInternationalString((CharSequence)value);
    }

    @Override
    public GeographicExtent getTerritoryOfUse() {
        return this.territoryOfUse != null ? this.territoryOfUse : this.inherit(ModifiableLocationType::getTerritoryOfUse);
    }

    public void setTerritoryOfUse(GeographicExtent value) {
        this.territoryOfUse = value;
    }

    public void setTerritoryOfUse(String identifier) {
        this.territoryOfUse = identifier != null ? new DefaultGeographicDescription(null, identifier) : null;
    }

    @Override
    public AbstractParty getOwner() {
        return this.owner != null ? this.owner : this.inherit(ModifiableLocationType::getOwner);
    }

    public void setOwner(AbstractParty value) {
        this.owner = value;
    }

    public void setOwner(CharSequence name) {
        this.owner = name != null ? new DefaultOrganisation(name, null, null, null) : null;
    }

    public final Collection<ModifiableLocationType> getParents() {
        return Collections.unmodifiableCollection(this.parents.values());
    }

    public final Collection<ModifiableLocationType> getChildren() {
        return Collections.unmodifiableCollection(this.children.values());
    }

    public void addParent(ModifiableLocationType parent) {
        ArgumentChecks.ensureNonNull((String)"parent", (Object)parent);
        String parentName = parent.name.toString();
        if (this.parents.putIfAbsent(parentName, parent) != null) {
            throw new IllegalStateException(Resources.format((short)9, parentName));
        }
        String childName = this.name.toString();
        if (parent.children.putIfAbsent(childName, this) != null) {
            if (this.parents.remove(parentName) != parent) {
                throw new ConcurrentModificationException();
            }
            throw new IllegalArgumentException(Resources.format((short)8, parentName));
        }
        try {
            parent.checkForCycles();
        }
        catch (IllegalArgumentException e) {
            parent.children.remove(childName);
            this.parents.remove(parentName);
            throw e;
        }
    }

    public void removeParent(ModifiableLocationType parent) {
        ArgumentChecks.ensureNonNull((String)"parent", (Object)parent);
        String key = parent.name.toString();
        ModifiableLocationType removed = this.parents.remove(key);
        if (removed == null) {
            throw new IllegalArgumentException(Resources.format((short)10, key));
        }
        if (removed.children.remove(this.name.toString()) != this || removed != parent) {
            throw new CorruptedObjectException();
        }
    }

    @Override
    public ReferencingByIdentifiers getReferenceSystem() {
        return null;
    }
}

