/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.gazetteer;

import jakarta.xml.bind.annotation.XmlTransient;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.geometry.Envelope2D;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.Shapes2D;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Longitude;
import org.apache.sis.measure.Quantities;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.crs.DefaultProjectedCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.gazetteer.AbstractLocation;
import org.apache.sis.referencing.gazetteer.GazetteerException;
import org.apache.sis.referencing.gazetteer.ModifiableLocationType;
import org.apache.sis.referencing.gazetteer.ReferenceVerifyException;
import org.apache.sis.referencing.gazetteer.ReferencingByIdentifiers;
import org.apache.sis.referencing.gazetteer.SimpleLocation;
import org.apache.sis.referencing.gazetteer.internal.Resources;
import org.apache.sis.referencing.operation.provider.PolarStereographicA;
import org.apache.sis.referencing.operation.provider.TransverseMercator;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.util.Formulas;
import org.apache.sis.referencing.util.j2d.IntervalRectangle;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

@XmlTransient
public class MilitaryGridReferenceSystem
extends ReferencingByIdentifiers {
    private static final long serialVersionUID = 8337394374656125471L;
    static final String IDENTIFIER = "MGRS";
    static final double LATITUDE_BAND_HEIGHT = 8.0;
    static final int GRID_SQUARE_SIZE = 100000;
    static final int GRID_ROW_COUNT = 20;
    static final int METRE_PRECISION_DIGITS = 5;
    private static final char EXCLUDE_I = 'I';
    private static final char EXCLUDE_O = 'O';
    private static final byte[] POLAR_COLUMNS = new byte[]{65, 66, 67, 70, 71, 72, 74, 75, 76, 80, 81, 82, 83, 84, 85, 88, 89, 90};
    private static final TransverseMercator.Zoner ZONER = TransverseMercator.Zoner.UTM;
    final CommonCRS datum;
    final boolean avoidDatumChange;
    private transient short southOffset;
    private transient short northOffset;
    private static MilitaryGridReferenceSystem INSTANCE;

    static synchronized MilitaryGridReferenceSystem getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MilitaryGridReferenceSystem();
        }
        return INSTANCE;
    }

    public MilitaryGridReferenceSystem() {
        super(MilitaryGridReferenceSystem.properties(), MilitaryGridReferenceSystem.types());
        this.datum = CommonCRS.WGS84;
        this.avoidDatumChange = false;
    }

    public MilitaryGridReferenceSystem(Map<String, ?> properties, CommonCRS datum) {
        super(properties, MilitaryGridReferenceSystem.types());
        this.datum = datum != null ? datum : CommonCRS.WGS84;
        this.avoidDatumChange = datum == null;
    }

    private static Map<String, ?> properties() {
        AbstractParty party = new AbstractParty((CharSequence)"North Atlantic Treaty Organization", null);
        return MilitaryGridReferenceSystem.properties(new NamedIdentifier(null, "NATO", (CharSequence)Resources.formatInternational((short)15), null, null), IDENTIFIER, party);
    }

    private static ModifiableLocationType[] types() {
        ModifiableLocationType gzd = new ModifiableLocationType((CharSequence)Resources.formatInternational((short)13));
        ModifiableLocationType square = new ModifiableLocationType((CharSequence)Resources.formatInternational((short)14));
        ModifiableLocationType coord = new ModifiableLocationType((CharSequence)Resources.formatInternational((short)12));
        gzd.addIdentification((CharSequence)Vocabulary.formatInternational((short)28));
        coord.addIdentification((CharSequence)Vocabulary.formatInternational((short)35));
        square.addParent(gzd);
        coord.addParent(square);
        return new ModifiableLocationType[]{gzd};
    }

    final int polarOffset(boolean south) throws TransformException {
        short origin;
        short s = origin = south ? this.southOffset : this.northOffset;
        if (origin == 0) {
            DirectPosition2D position = new DirectPosition2D(south ? -80.0 : 84.0, 0.0);
            double northing = this.datum.universal(position.x * 1.01, position.y).getConversionFromBase().getMathTransform().transform((DirectPosition)position, (DirectPosition)position).getOrdinate(1);
            if (south) {
                northing = 4000000.0 - northing;
            }
            if ((double)(origin = (short)(northing = Math.floor(northing / 100000.0))) != northing) {
                throw new GazetteerException();
            }
            if (south) {
                this.southOffset = origin;
            } else {
                this.northOffset = origin;
            }
        }
        return origin;
    }

    @Override
    public Coder createCoder() {
        return new Coder();
    }

    public class Coder
    extends ReferencingByIdentifiers.Coder {
        private byte digits;
        private String separator;
        private String trimmedSeparator;
        private boolean clipToValidArea;
        private final Map<CoordinateReferenceSystem, Encoder> encoders;
        transient DirectPosition normalized;
        transient DirectPosition geographic;
        final StringBuilder buffer = new StringBuilder(18);

        protected Coder() {
            this.digits = (byte)5;
            this.trimmedSeparator = "";
            this.separator = "";
            this.encoders = new IdentityHashMap<CoordinateReferenceSystem, Encoder>();
            this.clipToValidArea = true;
        }

        Coder(Coder other) {
            this.digits = other.digits;
            this.separator = other.separator;
            this.trimmedSeparator = other.trimmedSeparator;
            this.clipToValidArea = other.clipToValidArea;
            this.encoders = other.encoders;
        }

        @Override
        public final MilitaryGridReferenceSystem getReferenceSystem() {
            return MilitaryGridReferenceSystem.this;
        }

        public double getPrecision() {
            return MathFunctions.pow10((int)(5 - this.digits));
        }

        public void setPrecision(double precision) {
            int p;
            try {
                p = DecimalFunctions.floorLog10((double)precision);
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException(Errors.format((short)45, (Object)"precision", (Object)precision), e);
            }
            int n = Math.max(-3, Math.min(6, p));
            this.digits = (byte)(5 - n);
        }

        final int digits() {
            return this.digits;
        }

        public Quantity<Length> getPrecision(DirectPosition position) {
            return Quantities.create((double)this.getPrecision(), (Unit)Units.METRE);
        }

        @Override
        public void setPrecision(Quantity<?> precision, DirectPosition position) throws IncommensurableException {
            ArgumentChecks.ensureNonNull((String)"precision", precision);
            double p = precision.getValue().doubleValue();
            Unit unit = precision.getUnit();
            if (Units.isAngular((Unit)unit)) {
                CoordinateReferenceSystem crs;
                Ellipsoid ellipsoid = this.getEllipsoid();
                double radius = 0.0;
                if (position != null && (crs = position.getCoordinateReferenceSystem()) != null) {
                    try {
                        double \u03c6 = this.encoder(crs).getLatitude(this, position);
                        double \u03c6r = Math.toRadians(\u03c6);
                        radius = Formulas.geocentricRadius((Ellipsoid)ellipsoid, (double)\u03c6r);
                        if (\u03c6 >= -80.0 && \u03c6 < 84.0) {
                            radius *= Math.cos(\u03c6r);
                        }
                    }
                    catch (IllegalArgumentException | TransformException | FactoryException e) {
                        Coder.recoverableException(Coder.class, "setPrecision", (Exception)e);
                    }
                }
                if (!(radius > 0.0)) {
                    radius = ellipsoid.getSemiMajorAxis();
                }
                p = unit.getConverterToAny(Units.RADIAN).convert(p) * radius;
            } else {
                p = unit.getConverterToAny(Units.METRE).convert(p);
            }
            this.setPrecision(p);
        }

        final Ellipsoid getEllipsoid() {
            return MilitaryGridReferenceSystem.this.datum.geographic().getDatum().getEllipsoid();
        }

        public String getSeparator() {
            return this.separator;
        }

        public void setSeparator(String separator) {
            this.trimmedSeparator = separator.strip();
            this.separator = separator;
        }

        public boolean getClipToValidArea() {
            return this.clipToValidArea;
        }

        public void setClipToValidArea(boolean clip) {
            this.clipToValidArea = clip;
        }

        final ProjectedCRS projection(double latitude, double longitude) {
            return MilitaryGridReferenceSystem.this.datum.universal(latitude, longitude);
        }

        final Encoder encoder(CoordinateReferenceSystem crs) throws FactoryException, TransformException {
            if (crs == null) {
                throw new GazetteerException(Errors.format((short)157));
            }
            Encoder encoder = this.encoders.get(crs);
            if (encoder == null && this.encoders.put(crs, encoder = new Encoder(MilitaryGridReferenceSystem.this.avoidDatumChange ? null : MilitaryGridReferenceSystem.this.datum, crs)) != null) {
                throw new ConcurrentModificationException();
            }
            return encoder;
        }

        @Override
        public String encode(DirectPosition position) throws TransformException {
            ArgumentChecks.ensureNonNull((String)"position", (Object)position);
            try {
                return this.encoder(position.getCoordinateReferenceSystem()).encode(this, position, true, this.getSeparator(), this.digits(), 0.0);
            }
            catch (IllegalArgumentException | FactoryException e) {
                throw new GazetteerException(e.getLocalizedMessage(), e);
            }
        }

        @Override
        public String encode(DirectPosition position, Quantity<?> precision) throws IncommensurableException, TransformException {
            ArgumentChecks.ensureNonNull((String)"position", (Object)position);
            ArgumentChecks.ensureNonNull((String)"precision", precision);
            double p = precision.getValue().doubleValue();
            Unit unit = precision.getUnit();
            if (Units.isAngular((Unit)unit)) {
                p = unit.getConverterToAny(Units.RADIAN).convert(p);
            } else {
                this.setPrecision(unit.getConverterToAny(Units.METRE).convert(p));
                p = 0.0;
            }
            try {
                return this.encoder(position.getCoordinateReferenceSystem()).encode(this, position, true, this.getSeparator(), this.digits(), p);
            }
            catch (IllegalArgumentException | FactoryException e) {
                throw new GazetteerException(e.getLocalizedMessage(), e);
            }
        }

        public Iterator<String> encode(Envelope areaOfInterest) throws TransformException {
            ArgumentChecks.ensureNonNull((String)"areaOfInterest", (Object)areaOfInterest);
            try {
                return Spliterators.iterator(new IteratorAllZones(areaOfInterest).simplify());
            }
            catch (IllegalArgumentException | FactoryException e) {
                throw new GazetteerException(e);
            }
        }

        public Stream<String> encode(Envelope areaOfInterest, boolean parallel) throws TransformException {
            ArgumentChecks.ensureNonNull((String)"areaOfInterest", (Object)areaOfInterest);
            try {
                return StreamSupport.stream(new IteratorAllZones(areaOfInterest).simplify(), parallel);
            }
            catch (IllegalArgumentException | FactoryException e) {
                throw new GazetteerException(e);
            }
        }

        @Override
        public AbstractLocation decode(CharSequence reference) throws TransformException {
            ArgumentChecks.ensureNonEmpty((String)"reference", (CharSequence)reference);
            return new Decoder(this, reference);
        }

        private final class IteratorAllZones
        implements Spliterator<String> {
            private final Spliterator<String>[] iterators;
            private int index;
            private int upper;

            IteratorAllZones(Envelope areaOfInterest) throws FactoryException, TransformException {
                SingleCRS sourceCRS = CRS.getHorizontalComponent((CoordinateReferenceSystem)areaOfInterest.getCoordinateReferenceSystem());
                if (sourceCRS == null) {
                    throw new GazetteerException(Errors.format((short)201, (Object)"areaOfInterest"));
                }
                int precision = (int)Coder.this.getPrecision();
                if (precision <= 0 || precision > 100000) {
                    throw new GazetteerException(Errors.format((short)166, (Object)"precision", (Object)1, (Object)100000, (Object)precision));
                }
                IntervalRectangle aoi = new IntervalRectangle(areaOfInterest.getLowerCorner(), areaOfInterest.getUpperCorner());
                Envelope geographicArea = Envelopes.transform((Envelope)areaOfInterest, (CoordinateReferenceSystem)MilitaryGridReferenceSystem.this.datum.normalizedGeographic());
                double \u03c6min = geographicArea.getMinimum(1);
                double \u03c6max = geographicArea.getMaximum(1);
                boolean southPole = \u03c6min < -80.0;
                boolean northPole = \u03c6max > 84.0;
                boolean southUTM = false;
                boolean northUTM = false;
                int zoneStart = 0;
                int zoneEnd = 0;
                int zoneCount = ZONER.zoneCount();
                if (\u03c6max >= -80.0 && \u03c6min < 84.0) {
                    southUTM = \u03c6min < 0.0;
                    boolean bl = northUTM = \u03c6max >= 0.0;
                    if (geographicArea.getSpan(0) > 360.0 - MilitaryGridReferenceSystem.ZONER.width) {
                        zoneEnd = zoneCount;
                    } else {
                        zoneStart = ZONER.zone(0.0, geographicArea.getLowerCorner().getOrdinate(0)) - 1;
                        zoneEnd = ZONER.zone(0.0, geographicArea.getUpperCorner().getOrdinate(0));
                        if (zoneEnd < zoneStart) {
                            zoneEnd += zoneCount;
                        }
                    }
                }
                this.upper = zoneEnd - zoneStart;
                if (southUTM & northUTM) {
                    this.upper *= 2;
                }
                if (southPole) {
                    this.upper += 2;
                }
                if (northPole) {
                    this.upper += 2;
                }
                this.iterators = new Spliterator[this.upper];
                int zone = zoneStart;
                this.upper = 0;
                do {
                    double \u03c6;
                    double \u03bb = ZONER.centralMeridian(zone % zoneCount + 1);
                    if (southPole) {
                        \u03c6 = -90.0;
                        southPole = false;
                    } else if (southUTM) {
                        \u03c6 = -1.0;
                        if (++zone >= zoneEnd) {
                            zone = zoneStart;
                            southUTM = false;
                        }
                    } else if (northUTM) {
                        \u03c6 = 1.0;
                        if (++zone >= zoneEnd) {
                            northUTM = false;
                        }
                    } else if (northPole) {
                        \u03c6 = 90.0;
                        northPole = false;
                    } else {
                        throw new AssertionError();
                    }
                    ProjectedCRS targetCRS = MilitaryGridReferenceSystem.this.datum.universal(\u03c6, \u03bb);
                    Spliterator<String> iter = new IteratorOneZone(Coder.this, (Rectangle2D)aoi, geographicArea, sourceCRS, targetCRS, precision);
                    do {
                        this.iterators[this.upper++] = iter;
                    } while ((iter = iter.trySplit()) != null);
                } while (southPole | northPole | southUTM | northUTM);
            }

            private IteratorAllZones(IteratorAllZones half) {
                this.iterators = half.iterators;
                this.index = half.index;
                half.index = this.upper = (half.upper + this.index) / 2;
            }

            @Override
            public Spliterator<String> trySplit() {
                return this.upper - this.index >= 2 ? new IteratorAllZones(this).simplify() : null;
            }

            final Spliterator<String> simplify() {
                return this.upper - this.index == 1 ? this.iterators[this.index] : this;
            }

            @Override
            public long estimateSize() {
                long n = 0L;
                for (int i = this.index; i < this.upper; ++i) {
                    n += this.iterators[i].estimateSize();
                }
                return n;
            }

            @Override
            public boolean tryAdvance(Consumer<? super String> action) {
                while (this.index < this.upper) {
                    if (this.iterators[this.index].tryAdvance(action)) {
                        return true;
                    }
                    ++this.index;
                }
                return false;
            }

            @Override
            public void forEachRemaining(Consumer<? super String> action) {
                while (this.index < this.upper) {
                    this.iterators[this.index++].forEachRemaining(action);
                }
            }

            @Override
            public int characteristics() {
                return 1281;
            }
        }
    }

    static final class Decoder
    extends SimpleLocation.Projected {
        static final int NORTHING_BITS_COUNT = 4;
        static final int NORTHING_BITS_MASK = 15;
        private static final int[] ROW_RESOLVER = new int[]{16744464, 16369, 4190209, 14682097, 1047554, 16253426, 261891, 16646259, 65476, 16744452, 8176, 0x3FF000, 14682096, 1047553, 16253425, 261890, 16646258, 65475, 16760835, 0x83FFF3};
        private final ProjectedCRS crs;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        Decoder(Coder owner, CharSequence reference) throws TransformException {
            super(owner.getReferenceSystem().rootType(), reference);
            String gzd;
            double sx;
            double sy;
            double \u03bb0;
            boolean hasSquareIdentification;
            double \u03c6s;
            int zone;
            boolean isValid = true;
            int end = CharSequences.skipTrailingWhitespaces((CharSequence)reference, (int)0, (int)reference.length());
            int base = CharSequences.skipLeadingWhitespaces((CharSequence)reference, (int)0, (int)end);
            int i = Decoder.endOfDigits(reference, base, end);
            if (i == base && i < end) {
                zone = 0;
                boolean south = false;
                boolean west = false;
                int col = 0;
                int row = 0;
                block23: for (int part = 0; part <= 2; ++part) {
                    CharSequence token;
                    short key;
                    int c = Character.codePointAt(reference, i);
                    int ni = i + Character.charCount(c);
                    if (Decoder.isLetter(c) || Decoder.isLetter(c -= 32)) {
                        block1 : switch (part) {
                            case 0: {
                                switch (c) {
                                    case 65: {
                                        south = true;
                                        west = true;
                                        break;
                                    }
                                    case 66: {
                                        south = true;
                                        break;
                                    }
                                    case 89: {
                                        west = true;
                                        break;
                                    }
                                    case 90: {
                                        break;
                                    }
                                    default: {
                                        break block1;
                                    }
                                }
                                i = Decoder.nextComponent(owner, reference, base, ni, end);
                                continue block23;
                            }
                            case 1: {
                                col = Arrays.binarySearch(POLAR_COLUMNS, (byte)c);
                                if (col < 0) break;
                                if (west) {
                                    col -= POLAR_COLUMNS.length;
                                }
                                col += 20;
                                i = Decoder.nextComponent(owner, reference, base, ni, end);
                                continue block23;
                            }
                            case 2: {
                                if (c >= 79) {
                                    --c;
                                }
                                if (c >= 73) {
                                    --c;
                                }
                                row = c - 65 + owner.getReferenceSystem().polarOffset(south);
                                i = ni;
                                continue block23;
                            }
                        }
                    }
                    if (part == 0) {
                        key = 4;
                        token = reference.subSequence(i, ni);
                        throw new GazetteerException(Resources.format(key, token));
                    }
                    key = 3;
                    token = CharSequences.token((CharSequence)reference, (int)i);
                    throw new GazetteerException(Resources.format(key, token));
                }
                \u03c6s = south ? -90.0 : 90.0;
                this.crs = owner.projection(\u03c6s, 0.0);
                this.minX = col * 100000;
                this.minY = row * 100000;
                hasSquareIdentification = true;
                \u03bb0 = 0.0;
            } else {
                zone = Decoder.parseInt(reference, base, i, (short)5);
                if (zone < 1) throw new GazetteerException(Resources.format((short)5, zone));
                if (zone > 60) {
                    throw new GazetteerException(Resources.format((short)5, zone));
                }
                int latitudeBand = -1;
                int col = 1;
                int row = 0;
                hasSquareIdentification = true;
                for (int part = 0; part <= 2; ++part) {
                    if (part == 1 && i >= end) {
                        hasSquareIdentification = false;
                        break;
                    }
                    i = Decoder.nextComponent(owner, reference, base, i, end);
                    int c = Character.codePointAt(reference, i);
                    int ni = i + Character.charCount(c);
                    if (!Decoder.isLetter(c) && !Decoder.isLetter(c -= 32)) {
                        CharSequence token;
                        short key;
                        if (part == 0) {
                            key = 2;
                            token = reference.subSequence(i, ni);
                            throw new GazetteerException(Resources.format(key, token));
                        }
                        key = 3;
                        token = CharSequences.token((CharSequence)reference, (int)i);
                        throw new GazetteerException(Resources.format(key, token));
                    }
                    if (c >= 79) {
                        --c;
                    }
                    if (c >= 73) {
                        --c;
                    }
                    switch (part) {
                        case 0: {
                            latitudeBand = c - 67;
                            break;
                        }
                        case 1: {
                            switch (zone % 3) {
                                case 1: {
                                    col = c - 64;
                                    break;
                                }
                                case 2: {
                                    col = c - 72;
                                    break;
                                }
                                case 0: {
                                    col = c - 80;
                                    break;
                                }
                            }
                            break;
                        }
                        case 2: {
                            if ((zone & 1) != 0) {
                                row = c - 65;
                                break;
                            }
                            row = c - 70;
                            if (row >= 0) break;
                            row += 20;
                            break;
                        }
                    }
                    i = ni;
                }
                \u03c6s = (double)latitudeBand * 8.0 + -80.0;
                if (latitudeBand < 0) throw new GazetteerException(Resources.format((short)2, Character.valueOf(Encoder.latitudeBand(\u03c6s))));
                if (latitudeBand >= ROW_RESOLVER.length) {
                    throw new GazetteerException(Resources.format((short)2, Character.valueOf(Encoder.latitudeBand(\u03c6s))));
                }
                \u03bb0 = ZONER.centralMeridian(zone);
                this.crs = owner.projection(Math.signum(\u03c6s), \u03bb0);
                int info = ROW_RESOLVER[latitudeBand];
                if (hasSquareIdentification) {
                    int rowBit = 1 << row + 4;
                    boolean bl = isValid = (info & rowBit) != 0;
                    if (isValid) {
                        rowBit = Integer.lowestOneBit(~(info | rowBit - 1));
                    }
                    if ((info & -rowBit) != 0) {
                        row += 20;
                    }
                }
                this.minX = col * 100000;
                this.minY = (row += (info & 0xF) * 20) * 100000;
            }
            if (i < end) {
                double y;
                double x;
                int s = Decoder.endOfDigits(reference, i = Decoder.nextComponent(owner, reference, base, i, end), end);
                if (s >= end) {
                    int length = s - i;
                    if ((length & 1) != 0) {
                        throw new GazetteerException(Resources.format((short)7, reference.subSequence(i, s)));
                    }
                    int h = i + (length >>>= 1);
                    sx = sy = MathFunctions.pow10((int)(5 - length));
                    x = Decoder.parseCoordinate(reference, i, h, sx);
                    y = Decoder.parseCoordinate(reference, h, s, sy);
                } else {
                    sx = MathFunctions.pow10((int)(5 - (s - i)));
                    x = Decoder.parseCoordinate(reference, i, s, sx);
                    i = Decoder.nextComponent(owner, reference, base, s, end);
                    s = Decoder.endOfDigits(reference, i, end);
                    sy = MathFunctions.pow10((int)(5 - (s - i)));
                    y = Decoder.parseCoordinate(reference, i, s, sy);
                    if (s < end) {
                        throw new GazetteerException(Errors.format((short)135, (Object)reference.subSequence(base, s), (Object)CharSequences.trimWhitespaces((CharSequence)reference, (int)s, (int)end)));
                    }
                }
                this.minX += x;
                this.minY += y;
            } else if (hasSquareIdentification) {
                sy = 100000.0;
                sx = 100000.0;
            } else {
                sx = (MilitaryGridReferenceSystem.ZONER.easting - 100000.0) * 2.0;
                sy = MilitaryGridReferenceSystem.ZONER.northing;
            }
            this.maxX = this.minX + sx;
            this.maxY = this.minY + sy;
            if (!hasSquareIdentification) {
                if (zone != 0) {
                    if (\u03c6s < 0.0) {
                        this.southBoundLatitude = -80.0;
                        this.northBoundLatitude = 0.0;
                    } else {
                        this.southBoundLatitude = 0.0;
                        this.northBoundLatitude = 84.0;
                    }
                    this.westBoundLongitude = \u03bb0 - MilitaryGridReferenceSystem.ZONER.width / 2.0;
                    this.eastBoundLongitude = \u03bb0 + MilitaryGridReferenceSystem.ZONER.width / 2.0;
                } else {
                    if (\u03c6s < 0.0) {
                        this.southBoundLatitude = -90.0;
                        this.northBoundLatitude = -80.0;
                    } else {
                        this.southBoundLatitude = 84.0;
                        this.northBoundLatitude = 90.0;
                    }
                    this.westBoundLongitude = -180.0;
                    this.eastBoundLongitude = 180.0;
                }
            } else {
                MathTransform projection = this.crs.getConversionFromBase().getMathTransform();
                this.computeGeographicBoundingBox(projection.inverse());
                this.setTypeToChild();
                if (sx < 100000.0 || sy < 100000.0) {
                    this.setTypeToChild();
                }
                if (isValid && zone != 0) {
                    double \u03bb;
                    double \u03c6;
                    int zoneError;
                    boolean bl = isValid = this.northBoundLatitude >= \u03c6s && this.southBoundLatitude < Decoder.upperBound(\u03c6s);
                    if (isValid && (zoneError = ZONER.zone(\u03c6 = (this.southBoundLatitude + this.northBoundLatitude) / 2.0, \u03bb = (this.westBoundLongitude + this.eastBoundLongitude) / 2.0) - zone) != 0) {
                        int zc = ZONER.zoneCount();
                        if (zoneError < zc / -2) {
                            zoneError += zc;
                        }
                        if (zoneError > zc / 2) {
                            zoneError -= zc;
                        }
                        if (ZONER.isSpecialCase(zone, \u03c6)) {
                            isValid = Math.abs(zoneError) <= 2;
                        } else {
                            double r\u03bb = Math.IEEEremainder(\u03bb - MilitaryGridReferenceSystem.ZONER.origin, MilitaryGridReferenceSystem.ZONER.width);
                            double cv = (this.minX - MilitaryGridReferenceSystem.ZONER.easting) / (\u03bb - \u03bb0);
                            boolean bl2 = isValid = Math.abs(r\u03bb) * cv <= sx;
                            if (isValid) {
                                boolean bl3 = isValid = zoneError == (r\u03bb < 0.0 ? -1 : 1);
                            }
                        }
                    }
                }
                if (isValid && owner.getClipToValidArea()) {
                    boolean changed;
                    if (zone != 0) {
                        double width = MilitaryGridReferenceSystem.ZONER.width;
                        if (!ZONER.isSpecialCase(zone, \u03c6s)) {
                            width /= 2.0;
                        }
                        changed = this.clipGeographicBoundingBox(\u03bb0 - width, \u03c6s, \u03bb0 + width, Decoder.upperBound(\u03c6s));
                    } else {
                        changed = \u03c6s < 0.0 ? this.clipGeographicBoundingBox(-180.0, -90.0, 180.0, -80.0) : this.clipGeographicBoundingBox(-180.0, 84.0, 180.0, 90.0);
                    }
                    if (changed) {
                        this.clipProjectedEnvelope(projection, sx / 100.0, sy / 100.0);
                    }
                }
            }
            if (isValid) return;
            try {
                gzd = owner.encoder((CoordinateReferenceSystem)this.crs).encode(owner, this.getDirectPosition(), true, "", 0, 0.0);
            }
            catch (IllegalArgumentException | FactoryException e) {
                throw new GazetteerException(e.getLocalizedMessage(), e);
            }
            CharSequence ref = reference.subSequence(base, end);
            throw new ReferenceVerifyException(Resources.format((short)6, ref, gzd));
        }

        private static int nextComponent(Coder owner, CharSequence reference, int base, int start, int end) throws GazetteerException {
            if ((start = CharSequences.skipLeadingWhitespaces((CharSequence)reference, (int)start, (int)end)) < end) {
                if (!CharSequences.regionMatches((CharSequence)reference, (int)start, (CharSequence)owner.trimmedSeparator)) {
                    return start;
                }
                start += owner.trimmedSeparator.length();
                if ((start = CharSequences.skipLeadingWhitespaces((CharSequence)reference, (int)start, (int)end)) < end) {
                    return start;
                }
            }
            throw new GazetteerException(Errors.format((short)138, (Object)reference.subSequence(base, end)));
        }

        private static boolean isLetter(int c) {
            return c >= 65 && c <= 90 && c != 73 && c != 79;
        }

        private static int endOfDigits(CharSequence reference, int i, int end) {
            char c;
            while (i < end && (c = reference.charAt(i)) >= '0' && c <= '9') {
                ++i;
            }
            return i;
        }

        private static int parseInt(CharSequence reference, int start, int end, short errorKey) throws GazetteerException {
            CharSequence part;
            NumberFormatException cause = null;
            if (start == end) {
                part = CharSequences.token((CharSequence)reference, (int)start);
            } else {
                part = reference.subSequence(start, end);
                try {
                    return Integer.parseInt(part.toString());
                }
                catch (NumberFormatException e) {
                    cause = e;
                }
            }
            throw new GazetteerException(Resources.format(errorKey, part), cause);
        }

        private static double parseCoordinate(CharSequence reference, int start, int end, double scale) throws GazetteerException {
            return (double)Decoder.parseInt(reference, start, end, (short)1) * scale;
        }

        static double upperBound(double \u03c6) {
            return \u03c6 < 72.0 ? \u03c6 + 8.0 : 84.0;
        }

        @Override
        public CoordinateReferenceSystem getCoordinateReferenceSystem() {
            return this.crs;
        }
    }

    static final class Encoder {
        private static final int POLE = 100;
        private final CommonCRS datum;
        final int crsZone;
        private final MathTransform toNormalized;
        private final MathTransform toGeographic;
        private MathTransform toActualZone;
        private int actualZone;
        char latitudeBand;

        Encoder(CommonCRS datum, CoordinateReferenceSystem crs) throws FactoryException, TransformException {
            SingleCRS horizontal = CRS.getHorizontalComponent((CoordinateReferenceSystem)crs);
            if (horizontal == null) {
                horizontal = crs;
            }
            if (datum == null) {
                datum = CommonCRS.forDatum((CoordinateReferenceSystem)horizontal);
            }
            this.datum = datum;
            if (horizontal instanceof ProjectedCRS) {
                ProjectedCRS projCRS = (ProjectedCRS)horizontal;
                Projection projection = projCRS.getConversionFromBase();
                OperationMethod method = projection.getMethod();
                this.crsZone = IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)method, (String)"Transverse Mercator") ? ZONER.zone(projection.getParameterValues()) : (IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)method, (String)"Polar Stereographic (variant A)") ? 100 * PolarStereographicA.isUPS((ParameterValueGroup)projection.getParameterValues()) : 0);
                if (this.crsZone != 0) {
                    DefaultProjectedCRS userAxisOrder = DefaultProjectedCRS.castOrCopy((ProjectedCRS)projCRS);
                    projCRS = userAxisOrder.forConvention(AxesConvention.NORMALIZED);
                    if (crs != horizontal || projCRS != userAxisOrder) {
                        this.toNormalized = CRS.findOperation((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)projCRS, null).getMathTransform();
                        projection = projCRS.getConversionFromBase();
                        horizontal = projCRS;
                        crs = projCRS;
                    } else {
                        this.toNormalized = null;
                    }
                } else {
                    this.toNormalized = null;
                }
                if (crs == horizontal && Utilities.equalsIgnoreMetadata((Object)projCRS.getBaseCRS(), (Object)datum.geographic())) {
                    this.toGeographic = projection.getMathTransform().inverse();
                    return;
                }
            } else {
                this.crsZone = 0;
                this.toNormalized = null;
            }
            this.toGeographic = CRS.findOperation((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)datum.geographic(), null).getMathTransform();
        }

        static char latitudeBand(double \u03c6) {
            int band = 67 + (int)((\u03c6 - -80.0) / 8.0);
            if (band >= 73 && ++band >= 79 && ++band == 89) {
                band = 88;
            }
            assert (band >= 67 && band <= 88) : band;
            return (char)band;
        }

        final double getLatitude(Coder owner, DirectPosition position) throws TransformException {
            if (this.toNormalized != null) {
                owner.normalized = position = this.toNormalized.transform(position, owner.normalized);
            }
            owner.geographic = position = this.toGeographic.transform(position, owner.geographic);
            return position.getOrdinate(0);
        }

        String encode(Coder owner, DirectPosition position, boolean reproject, String separator, int digits, double precision) throws FactoryException, TransformException {
            int signedZone;
            DirectPosition geographic;
            if (this.toNormalized != null) {
                owner.normalized = position = this.toNormalized.transform(position, owner.normalized);
            }
            owner.geographic = geographic = this.toGeographic.transform(position, owner.geographic);
            double \u03bb = geographic.getOrdinate(1);
            double \u03c6 = geographic.getOrdinate(0);
            boolean isUTM = \u03c6 >= -80.0 && \u03c6 < 84.0;
            int zone = isUTM ? ZONER.zone(\u03c6, \u03bb) : 100;
            int n = signedZone = MathFunctions.isNegative((double)\u03c6) ? -zone : zone;
            if (signedZone == 0) {
                throw new GazetteerException(Errors.format((short)110, (Object)"longitude"));
            }
            if (signedZone != this.crsZone) {
                if (!reproject) {
                    return null;
                }
                if (signedZone != this.actualZone) {
                    this.actualZone = 0;
                    this.toActualZone = CRS.findOperation((CoordinateReferenceSystem)this.datum.geographic(), (CoordinateReferenceSystem)this.datum.universal(\u03c6, \u03bb), null).getMathTransform();
                    this.actualZone = signedZone;
                }
                geographic.setOrdinate(1, Longitude.normalize((double)\u03bb));
                owner.normalized = position = this.toActualZone.transform(geographic, owner.normalized);
            }
            if (precision > 0.0) {
                double \u03c6r = Math.toRadians(\u03c6);
                precision *= Formulas.geocentricRadius((Ellipsoid)owner.getEllipsoid(), (double)\u03c6r);
                if (isUTM) {
                    precision *= Math.cos(\u03c6r);
                }
                owner.setPrecision(precision);
                digits = owner.digits();
            }
            StringBuilder buffer = owner.buffer;
            buffer.setLength(0);
            if (isUTM) {
                buffer.append(zone).append(separator);
                this.latitudeBand = Encoder.latitudeBand(\u03c6);
            } else {
                this.latitudeBand = (char)(signedZone < 0 ? 65 : 89);
                if (\u03bb >= 0.0) {
                    this.latitudeBand = (char)(this.latitudeBand + '\u0001');
                }
            }
            buffer.append(this.latitudeBand);
            if (digits >= 0) {
                double x = position.getOrdinate(0);
                double y = position.getOrdinate(1);
                double cx = Math.floor(x / 100000.0);
                double cy = Math.floor(y / 100000.0);
                int col = (int)cx;
                int row = (int)cy;
                if (isUTM) {
                    if (col < 1 || col > 8) {
                        throw new GazetteerException(Errors.format((short)119));
                    }
                    switch (zone % 3) {
                        case 1: {
                            col += 64;
                            break;
                        }
                        case 2: {
                            if ((col += 73) < 79) break;
                            ++col;
                            break;
                        }
                        case 0: {
                            col += 82;
                        }
                    }
                    if ((zone & 1) == 0) {
                        row += 5;
                    }
                    row %= 20;
                } else {
                    byte[] columns = POLAR_COLUMNS;
                    col -= 20;
                    if (!(\u03bb >= 0.0)) {
                        col += columns.length;
                    }
                    if (col < 0 || col >= columns.length) {
                        throw new GazetteerException(Errors.format((short)119));
                    }
                    col = columns[col];
                    row -= owner.getReferenceSystem().polarOffset(signedZone < 0);
                }
                if ((row += 65) >= 73 && ++row >= 79) {
                    ++row;
                }
                buffer.append(separator).append(Encoder.letter(col)).append(Encoder.letter(row));
                if (digits > 0) {
                    precision = MathFunctions.pow10((int)(5 - digits));
                    Encoder.append(buffer.append(separator), (int)((x - cx * 100000.0) / precision), digits);
                    Encoder.append(buffer.append(separator), (int)((y - cy * 100000.0) / precision), digits);
                }
            }
            return buffer.toString();
        }

        private static char letter(int c) throws GazetteerException {
            if (c >= 65 && c <= 90) {
                return (char)c;
            }
            throw new GazetteerException(Errors.format((short)119));
        }

        private static void append(StringBuilder buffer, int value, int digits) throws GazetteerException {
            if (value >= 0) {
                int p = buffer.length();
                if ((digits -= buffer.append(value).length() - p) >= 0) {
                    StringBuilders.repeat((StringBuilder)buffer, (int)p, (char)'0', (int)digits);
                    return;
                }
            }
            throw new GazetteerException(Errors.format((short)119));
        }
    }

    private final class IteratorOneZone
    extends Coder
    implements Spliterator<String> {
        private final Rectangle2D areaOfInterest;
        private final MathTransform2D gridToAOI;
        private final Encoder encoder;
        private final int xCenter;
        private final int xEnd;
        private int yStart;
        private int yEnd;
        private int gridX;
        private int gridY;
        private final int step;
        private final boolean downward;
        private final boolean optimize;
        private char latitudeBand;
        private String pending;
        private final Envelope2D cell;

        IteratorOneZone(Coder coder, Rectangle2D areaOfInterest, Envelope geographicArea, SingleCRS sourceCRS, ProjectedCRS targetCRS, int step) throws FactoryException, TransformException {
            double d;
            double d2;
            double d3;
            double d4;
            double \u03bbmax;
            double \u03bbmin;
            double \u03c6max;
            double \u03c6min;
            super(coder);
            this.cell = new Envelope2D();
            this.areaOfInterest = areaOfInterest;
            this.encoder = this.encoder((CoordinateReferenceSystem)targetCRS);
            this.step = step;
            int zone = Math.abs(this.encoder.crsZone);
            if (zone == 100) {
                this.xCenter = 2000000;
                if (this.encoder.crsZone < 0) {
                    \u03c6min = -90.0;
                    \u03c6max = -80.0;
                } else {
                    \u03c6min = 84.0;
                    \u03c6max = 90.0;
                }
                \u03bbmin = -180.0;
                \u03bbmax = 180.0;
            } else {
                this.xCenter = (int)MilitaryGridReferenceSystem.ZONER.easting;
                if (this.encoder.crsZone < 0) {
                    \u03c6min = -80.0;
                    \u03c6max = 0.0;
                } else {
                    \u03c6min = 0.0;
                    \u03c6max = 84.0;
                }
                double \u03bb0 = ZONER.centralMeridian(zone);
                \u03bbmin = \u03bb0 - MilitaryGridReferenceSystem.ZONER.width / 2.0;
                \u03bbmax = \u03bb0 + MilitaryGridReferenceSystem.ZONER.width / 2.0;
            }
            boolean clip = false;
            double t = geographicArea.getMinimum(1);
            if (d4 >= \u03c6min) {
                \u03c6min = t;
            } else {
                clip = true;
            }
            t = geographicArea.getMaximum(1);
            if (d3 <= \u03c6max) {
                \u03c6max = t;
            } else {
                clip = true;
            }
            t = geographicArea.getMinimum(0);
            if (d2 >= \u03bbmin) {
                \u03bbmin = t;
            } else {
                clip = true;
            }
            t = geographicArea.getMaximum(0);
            if (d <= \u03bbmax) {
                \u03bbmax = t;
            } else {
                clip = true;
            }
            boolean isSpecialCase = ZONER.isSpecialCase(\u03c6min, \u03c6max, \u03bbmin, \u03bbmax);
            if (clip) {
                IntervalRectangle r = new IntervalRectangle(\u03bbmin, \u03c6min, \u03bbmax, \u03c6max);
                r.setRect(Shapes2D.transform((CoordinateOperation)CRS.findOperation((CoordinateReferenceSystem)geographicArea.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)sourceCRS, null), (Rectangle2D)r, (Rectangle2D)r));
                r.intersect(areaOfInterest);
                if (r.xmax < r.xmin) {
                    r.xmin = \u03bbmin;
                    r.xmax = \u03bbmax;
                }
                areaOfInterest = r;
            }
            CoordinateOperation op = CRS.findOperation((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, null);
            Rectangle2D bounds = Shapes2D.transform((CoordinateOperation)op, (Rectangle2D)areaOfInterest, null);
            this.gridX = (int)(bounds.getMinX() / (double)step) * step;
            this.gridY = (int)(bounds.getMinY() / (double)step) * step;
            this.xEnd = (int)Math.ceil(bounds.getMaxX() / (double)step) * step;
            this.yEnd = (int)Math.ceil(bounds.getMaxY() / (double)step) * step;
            if (zone != 100) {
                this.downward = this.encoder.crsZone < 0;
            } else {
                boolean bl = this.downward = this.yEnd <= 2000000;
                isSpecialCase |= \u03bbmin != -180.0 || \u03bbmax != 180.0 || (this.encoder.crsZone < 0 ? \u03c6min != -90.0 : \u03c6max != 90.0);
            }
            if (this.downward) {
                int y = this.gridY;
                this.gridY = this.yEnd - step;
                this.yEnd = y - step;
            }
            this.yStart = this.gridY;
            this.gridToAOI = MathTransforms.bidimensional((MathTransform)op.getMathTransform().inverse());
            this.optimize = !isSpecialCase && Utilities.equalsIgnoreMetadata((Object)geographicArea.getCoordinateReferenceSystem(), (Object)sourceCRS);
        }

        private IteratorOneZone(IteratorOneZone other) {
            super(other);
            this.cell = new Envelope2D();
            this.areaOfInterest = other.areaOfInterest;
            this.gridToAOI = other.gridToAOI;
            this.encoder = other.encoder;
            this.optimize = other.optimize;
            this.step = other.step;
            this.gridX = other.gridX;
            this.xCenter = other.xCenter;
            this.xEnd = other.xEnd;
            this.yEnd = other.yStart - this.step;
            this.yStart = 2000000 - this.step;
            other.gridY = other.yStart = 2000000;
            this.gridY = this.yStart;
            this.downward = true;
            assert (!other.downward);
        }

        @Override
        public Spliterator<String> trySplit() {
            if (!this.downward && Math.abs(this.encoder.crsZone) == 100 && this.gridY < 2000000) {
                return new IteratorOneZone(this);
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return ((long)this.xEnd - (long)this.gridX) * Math.abs((long)this.yEnd - (long)this.yStart) / Math.multiplyFull(this.step, this.step);
        }

        @Override
        public boolean tryAdvance(Consumer<? super String> action) {
            return this.advance(action, false);
        }

        @Override
        public void forEachRemaining(Consumer<? super String> action) {
            this.advance(action, true);
            if (this.pending != null) {
                action.accept(this.pending);
                this.pending = null;
            }
        }

        private boolean advance(Consumer<? super String> action, boolean all) {
            int digits = this.digits();
            String separator = this.getSeparator();
            if (this.normalized == null) {
                this.normalized = new DirectPosition2D();
            }
            boolean found = false;
            try {
                do {
                    boolean end;
                    if (this.pending != null) {
                        action.accept(this.pending);
                        this.pending = null;
                        found = true;
                        continue;
                    }
                    this.cell.setRect((double)this.gridX, (double)this.gridY, (double)this.step, (double)this.step);
                    this.cell.setRect(Shapes2D.transform((MathTransform2D)this.gridToAOI, (Rectangle2D)this.cell, (Rectangle2D)this.cell));
                    if (this.cell.intersects(this.areaOfInterest)) {
                        int x = this.gridX;
                        int y = this.gridY;
                        if (x < this.xCenter) {
                            x += this.step - 1;
                        }
                        if (this.downward) {
                            y += this.step - 1;
                        }
                        this.normalized.setOrdinate(0, (double)x);
                        this.normalized.setOrdinate(1, (double)y);
                        String ref = this.encoder.encode(this, this.normalized, false, separator, digits, 0.0);
                        if (ref != null) {
                            char previous = this.latitudeBand;
                            this.latitudeBand = this.encoder.latitudeBand;
                            if (this.latitudeBand != previous && previous != '\u0000') {
                                this.pending = ref;
                                this.normalized.setOrdinate(1, (double)(y + (this.downward ? 1 : -1)));
                                ref = this.encoder.encode(this, this.normalized, false, separator, digits, 0.0);
                                if (ref == null || this.encoder.latitudeBand == previous) {
                                    ref = this.pending;
                                    this.pending = null;
                                }
                            }
                            action.accept(ref);
                            found = true;
                        }
                    } else if (this.optimize) {
                        this.gridY = this.yEnd;
                    }
                    boolean bl = this.downward ? (this.gridY -= this.step) <= this.yEnd : (end = (this.gridY += this.step) >= this.yEnd);
                    if (!end) continue;
                    this.gridY = this.yStart;
                    this.latitudeBand = '\u0000';
                    if ((this.gridX += this.step) >= this.xEnd) break;
                } while (all || !found);
            }
            catch (TransformException | FactoryException e) {
                throw (ArithmeticException)new ArithmeticException(Errors.format((short)119)).initCause(e);
            }
            return found;
        }

        @Override
        public int characteristics() {
            return 1281;
        }

        public String toString() {
            return Strings.toString(this.getClass(), (Object[])new Object[]{"zone", this.encoder.crsZone, "downward", this.downward, "yStart", this.yStart, "yEnd", this.yEnd, "gridX", this.gridX, "xEnd", this.xEnd});
        }
    }
}

