/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.gazetteer;

import jakarta.xml.bind.annotation.XmlTransient;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.measure.Quantities;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.gazetteer.AbstractLocation;
import org.apache.sis.referencing.gazetteer.GazetteerException;
import org.apache.sis.referencing.gazetteer.ModifiableLocationType;
import org.apache.sis.referencing.gazetteer.ReferencingByIdentifiers;
import org.apache.sis.referencing.gazetteer.SimpleLocation;
import org.apache.sis.referencing.util.Formulas;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

@XmlTransient
public class GeohashReferenceSystem
extends ReferencingByIdentifiers {
    private static final long serialVersionUID = 9162259764027168776L;
    static final String IDENTIFIER = "Geohash";
    final Format format;
    final DefaultGeographicCRS normalizedCRS;
    final CoordinateOperation denormalize;
    private static GeohashReferenceSystem INSTANCE;

    static synchronized GeohashReferenceSystem getInstance() throws GazetteerException {
        if (INSTANCE == null) {
            INSTANCE = new GeohashReferenceSystem(Format.BASE32, CommonCRS.WGS84.geographic());
        }
        return INSTANCE;
    }

    public GeohashReferenceSystem(Format format, GeographicCRS crs) throws GazetteerException {
        super(GeohashReferenceSystem.properties(IDENTIFIER, IDENTIFIER, null), GeohashReferenceSystem.types());
        ArgumentChecks.ensureNonNull((String)"format", (Object)((Object)format));
        ArgumentChecks.ensureNonNull((String)"crs", (Object)crs);
        ArgumentChecks.ensureDimensionMatches((String)"crs", (int)2, (CoordinateReferenceSystem)crs);
        this.format = format;
        this.normalizedCRS = DefaultGeographicCRS.castOrCopy((GeographicCRS)crs).forConvention(AxesConvention.NORMALIZED);
        try {
            this.denormalize = CRS.findOperation((CoordinateReferenceSystem)this.normalizedCRS, (CoordinateReferenceSystem)crs, null);
        }
        catch (FactoryException e) {
            throw new GazetteerException(e.getLocalizedMessage(), e);
        }
    }

    private static ModifiableLocationType[] types() {
        ModifiableLocationType gzd = new ModifiableLocationType(IDENTIFIER);
        gzd.addIdentification((CharSequence)Vocabulary.formatInternational((short)28));
        return new ModifiableLocationType[]{gzd};
    }

    public Format getFormat() {
        return this.format;
    }

    @Override
    public Coder createCoder() {
        return new Coder();
    }

    public static enum Format {
        BASE32(16, new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 98, 99, 100, 101, 102, 103, 104, 106, 107, 109, 110, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122});

        final int highestOneBit;
        final byte[] encoding;
        final byte[] decodingLowerCase;
        final byte[] decodingUpperCase;

        private Format(int highestOneBit, byte[] encoding) {
            this.highestOneBit = highestOneBit;
            this.encoding = encoding;
            byte[] decoding = new byte[26];
            for (int i = 10; i < encoding.length; i = (int)((byte)(i + 1))) {
                decoding[encoding[i] - 97] = i;
            }
            this.decodingLowerCase = decoding;
            this.decodingUpperCase = decoding;
        }
    }

    public class Coder
    extends ReferencingByIdentifiers.Coder {
        private int length = 12;
        private transient char[] buffer;
        private transient CoordinateOperation lastOp;
        private final transient double[] coordinates;

        protected Coder() {
            this.coordinates = GeohashReferenceSystem.this.denormalize.getMathTransform().isIdentity() ? null : new double[8];
        }

        @Override
        public final GeohashReferenceSystem getReferenceSystem() {
            return GeohashReferenceSystem.this;
        }

        public int getHashLength() {
            return this.length;
        }

        public void setHashLength(int length) {
            ArgumentChecks.ensureBetween((String)"length", (int)1, (int)255, (int)length);
            this.length = length;
            this.buffer = null;
        }

        public Quantity<Length> getPrecision(DirectPosition position) {
            Ellipsoid ellipsoid = GeohashReferenceSystem.this.normalizedCRS.getDatum().getEllipsoid();
            Unit unit = ellipsoid.getAxisUnit();
            int latNumBits = 5 * this.length >>> 1;
            int lonNumBits = latNumBits + (this.length & 1);
            if (position != null) {
                try {
                    position = this.toGeographic(position);
                    double \u03c6 = Math.toRadians(position.getOrdinate(1));
                    double a = 1.5707963267948966 * Formulas.geocentricRadius((Ellipsoid)ellipsoid, (double)\u03c6);
                    double b = Math.cos(\u03c6) * (2.0 * a) / (double)(1 << lonNumBits);
                    return Quantities.create((double)Math.max(a /= (double)(1 << latNumBits), b), (Unit)unit);
                }
                catch (TransformException | FactoryException e) {
                    Coder.recoverableException(Coder.class, "getPrecision", (Exception)e);
                }
            }
            double a = Math.PI * ellipsoid.getSemiMajorAxis() / (double)(1 << lonNumBits);
            return Quantities.create((double)a, (Unit)unit);
        }

        @Override
        public void setPrecision(Quantity<?> precision, DirectPosition position) throws IncommensurableException {
            long b;
            ArgumentChecks.ensureNonNull((String)"precision", precision);
            double p = precision.getValue().doubleValue();
            Unit unit = precision.getUnit();
            double numLat = 0.0;
            double numLon = 0.0;
            if (Units.isAngular((Unit)unit)) {
                p = unit.getConverterToAny(Units.DEGREE).convert(p);
                numLat = 90.0 / p;
                numLon = 180.0 / p;
            } else {
                Ellipsoid ellipsoid = GeohashReferenceSystem.this.normalizedCRS.getDatum().getEllipsoid();
                p = unit.getConverterToAny(ellipsoid.getAxisUnit()).convert(p);
                if (position != null) {
                    try {
                        position = this.toGeographic(position);
                        double \u03c6 = Math.toRadians(position.getOrdinate(1));
                        numLat = 1.5707963267948966 * Formulas.geocentricRadius((Ellipsoid)ellipsoid, (double)\u03c6) / p;
                        numLon = Math.cos(\u03c6) * (2.0 * numLat);
                    }
                    catch (TransformException | FactoryException e) {
                        Coder.recoverableException(Coder.class, "setPrecision", (Exception)e);
                        position = null;
                    }
                }
                if (position == null) {
                    numLat = 1.5707963267948966 * ellipsoid.getSemiMajorAxis() / p;
                    numLon = 2.0 * numLat;
                }
            }
            int latNumBits = 0;
            if (numLat > 0.0) {
                b = Math.round(numLat);
                latNumBits = 63 - Long.numberOfLeadingZeros(b);
                if (1L << latNumBits != b) {
                    ++latNumBits;
                }
                this.length = Math.max(Numerics.ceilDiv((int)(latNumBits << 1), (int)5), 1);
            }
            if (numLon > numLat) {
                b = Math.round(numLon);
                int lonNumBits = 63 - Long.numberOfLeadingZeros(b);
                if (1L << lonNumBits != b) {
                    ++lonNumBits;
                }
                if (lonNumBits != latNumBits + 1 || (this.length & 1) == 0) {
                    this.length = Math.max(Numerics.ceilDiv((int)(lonNumBits << 1), (int)5), 1);
                }
            }
        }

        public String encode(double \u03c6, double \u03bb) throws TransformException {
            \u03c6 = Latitude.clamp((double)\u03c6);
            \u03bb = Longitude.normalize((double)\u03bb);
            byte[] encoding = GeohashReferenceSystem.this.format.encoding;
            int highestOneBit = GeohashReferenceSystem.this.format.highestOneBit;
            char[] geohash = this.buffer;
            if (geohash == null || geohash.length != this.length) {
                this.buffer = geohash = new char[this.length];
            }
            boolean isEven = true;
            double xmin = -180.0;
            double ymin = -90.0;
            double xmax = 180.0;
            double ymax = 90.0;
            int ch = 0;
            int bit = highestOneBit;
            int i = 0;
            while (i < geohash.length) {
                double mid;
                if (isEven) {
                    mid = (xmin + xmax) / 2.0;
                    if (\u03bb > mid) {
                        ch |= bit;
                        xmin = mid;
                    } else {
                        xmax = mid;
                    }
                } else {
                    mid = (ymin + ymax) / 2.0;
                    if (\u03c6 > mid) {
                        ch |= bit;
                        ymin = mid;
                    } else {
                        ymax = mid;
                    }
                }
                boolean bl = isEven = !isEven;
                if ((bit >>>= 1) != 0) continue;
                geohash[i++] = (char)encoding[ch];
                bit = highestOneBit;
                ch = 0;
            }
            return new String(geohash);
        }

        @Override
        public String encode(DirectPosition position) throws TransformException {
            ArgumentChecks.ensureNonNull((String)"position", (Object)position);
            try {
                position = this.toGeographic(position);
            }
            catch (FactoryException e) {
                throw new GazetteerException(e.getLocalizedMessage(), e);
            }
            return this.encode(position.getOrdinate(1), position.getOrdinate(0));
        }

        @Override
        public String encode(DirectPosition position, Quantity<?> precision) throws IncommensurableException, TransformException {
            ArgumentChecks.ensureNonNull((String)"position", (Object)position);
            ArgumentChecks.ensureNonNull((String)"precision", precision);
            try {
                position = this.toGeographic(position);
            }
            catch (FactoryException e) {
                throw new GazetteerException(e.getLocalizedMessage(), e);
            }
            this.setPrecision(precision, position);
            return this.encode(position.getOrdinate(1), position.getOrdinate(0));
        }

        private DirectPosition toGeographic(DirectPosition position) throws FactoryException, TransformException {
            CoordinateReferenceSystem ps = position.getCoordinateReferenceSystem();
            if (ps == null || GeohashReferenceSystem.this.normalizedCRS.equals((Object)ps, ComparisonMode.IGNORE_METADATA)) {
                return position;
            }
            if (this.lastOp == null || !Utilities.equalsIgnoreMetadata((Object)this.lastOp.getSourceCRS(), (Object)ps)) {
                this.lastOp = CRS.findOperation((CoordinateReferenceSystem)ps, (CoordinateReferenceSystem)GeohashReferenceSystem.this.normalizedCRS, null);
            }
            return this.lastOp.getMathTransform().transform(position, null);
        }

        @Override
        public AbstractLocation decode(CharSequence geohash) throws TransformException {
            ArgumentChecks.ensureNonEmpty((String)"geohash", (CharSequence)geohash);
            return new Decoder(geohash, this.coordinates);
        }
    }

    private final class Decoder
    extends SimpleLocation {
        Decoder(CharSequence geohash, double[] coordinates) throws TransformException {
            int nc;
            super(GeohashReferenceSystem.this.rootType(), geohash);
            int length = geohash.length();
            int highestOneBit = GeohashReferenceSystem.this.format.highestOneBit;
            byte[] decodingLowerCase = GeohashReferenceSystem.this.format.decodingLowerCase;
            byte[] decodingUpperCase = GeohashReferenceSystem.this.format.decodingUpperCase;
            boolean isEven = true;
            this.minX = -180.0;
            this.maxX = 180.0;
            this.minY = -90.0;
            this.maxY = 90.0;
            for (int i = 0; i < length; i += nc) {
                int c = Character.codePointAt(geohash, i);
                nc = Character.charCount(c);
                if (c >= 48 && c <= 57) {
                    c -= 48;
                } else if ((c = c >= 97 && c <= 122 ? decodingLowerCase[c - 97] : (c >= 65 && c <= 90 ? decodingUpperCase[c - 65] : 0)) == 0) {
                    throw new GazetteerException(Errors.format((short)155, (Object)"GeoHash", (Object)geohash, (Object)geohash.subSequence(i, i + nc)));
                }
                int mask = highestOneBit;
                do {
                    double mid;
                    if (isEven) {
                        mid = (this.minX + this.maxX) / 2.0;
                        if ((c & mask) != 0) {
                            this.minX = mid;
                        } else {
                            this.maxX = mid;
                        }
                    } else {
                        mid = (this.minY + this.maxY) / 2.0;
                        if ((c & mask) != 0) {
                            this.minY = mid;
                        } else {
                            this.maxY = mid;
                        }
                    }
                    boolean bl = isEven = !isEven;
                } while ((mask >>>= 1) != 0);
            }
            if (coordinates != null) {
                this.convert(GeohashReferenceSystem.this.denormalize.getMathTransform(), coordinates);
            }
        }

        @Override
        public CoordinateReferenceSystem getCoordinateReferenceSystem() {
            return GeohashReferenceSystem.this.denormalize.getTargetCRS();
        }
    }
}

