/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.base.Capability;
import org.apache.sis.storage.base.StoreMetadata;
import org.apache.sis.storage.base.URIDataStore;
import org.apache.sis.storage.geotiff.GeoTiffStore;
import org.apache.sis.util.Version;
import org.opengis.parameter.ParameterDescriptorGroup;

@StoreMetadata(formatName="GeoTIFF", fileSuffixes={"tiff", "tif"}, capabilities={Capability.READ}, resourceTypes={Aggregate.class, GridCoverageResource.class})
public class GeoTiffStoreProvider
extends DataStoreProvider {
    private static final String MIME_TYPE = "image/tiff";
    private static final Version VERSION = new Version("6.0");
    private static final Logger LOGGER = Logger.getLogger("org.apache.sis.storage.geotiff");
    private static final ParameterDescriptorGroup OPEN_DESCRIPTOR = URIDataStore.Provider.descriptor((String)"GeoTIFF");

    public String getShortName() {
        return "GeoTIFF";
    }

    public ParameterDescriptorGroup getOpenParameters() {
        return OPEN_DESCRIPTOR;
    }

    public ProbeResult probeContent(StorageConnector connector) throws DataStoreException {
        return this.probeContent(connector, ByteBuffer.class, buffer -> {
            if (buffer.remaining() < 4) {
                return ProbeResult.INSUFFICIENT_BYTES;
            }
            switch (buffer.getShort()) {
                case 18761: {
                    buffer.order(ByteOrder.LITTLE_ENDIAN);
                }
                case 19789: {
                    switch (buffer.getShort()) {
                        case 42: 
                        case 43: {
                            return new ProbeResult(true, MIME_TYPE, VERSION);
                        }
                    }
                }
            }
            return ProbeResult.UNSUPPORTED_STORAGE;
        });
    }

    public DataStore open(StorageConnector connector) throws DataStoreException {
        return new GeoTiffStore(this, connector);
    }

    public Logger getLogger() {
        return LOGGER;
    }
}

