/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.internal.io;

import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.web.WebView;
import javafx.stage.Window;
import org.apache.sis.gui.DataViewer;
import org.apache.sis.gui.internal.BackgroundThreads;
import org.apache.sis.gui.internal.ExceptionReporter;
import org.apache.sis.gui.internal.Resources;
import org.apache.sis.setup.OptionalInstallations;
import org.apache.sis.system.Fallback;
import org.opengis.util.FactoryException;

@Fallback
public final class OptionalDataDownloader
extends OptionalInstallations {
    private static volatile boolean accepted;

    public OptionalDataDownloader() {
        super("text/html");
    }

    protected boolean askUserAgreement(String authority, String license) {
        if (!Platform.isFxApplicationThread()) {
            return BackgroundThreads.runAndWaitDialog(() -> this.askUserAgreement(authority, license));
        }
        Resources resources = Resources.forLocale(this.getLocale());
        Alert dialog = new Alert(Alert.AlertType.CONFIRMATION, null, new ButtonType[]{ButtonType.NO, ButtonType.YES});
        dialog.initOwner((Window)DataViewer.getCurrentStage());
        dialog.setTitle(resources.getString((short)60, authority));
        dialog.setResizable(true);
        if (license == null) {
            dialog.getDialogPane().setPrefWidth(600.0);
            dialog.setHeaderText(resources.getString((short)58, authority));
            dialog.setContentText(resources.getString((short)59, authority, this.getSpaceRequirement(authority), this.destinationDirectory));
        } else {
            WebView content = new WebView();
            content.getEngine().loadContent(license);
            DialogPane pane = dialog.getDialogPane();
            pane.setContent((Node)content);
            pane.setPrefWidth(800.0);
            pane.setPrefHeight(600.0);
            dialog.setHeaderText(resources.getString((short)61));
        }
        accepted = dialog.showAndWait().orElse(ButtonType.NO) == ButtonType.YES;
        return accepted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportIfInstalling(FactoryException exception) {
        Class<OptionalInstallations> clazz = OptionalInstallations.class;
        synchronized (OptionalInstallations.class) {
            boolean s = accepted;
            accepted = false;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (s) {
                ExceptionReporter.show((Window)DataViewer.getCurrentStage(), null, Resources.format((short)62), (Throwable)exception);
            }
            return;
        }
    }
}

