/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.internal.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import org.apache.sis.gui.Widget;
import org.apache.sis.gui.internal.FixedHeaderColumnSize;
import org.apache.sis.gui.internal.ImmutableObjectProperty;
import org.apache.sis.gui.internal.Resources;
import org.apache.sis.gui.internal.io.FileAccessItem;
import org.apache.sis.io.stream.ChannelFactory;
import org.apache.sis.io.stream.FileCacheByteChannel;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.resources.Vocabulary;

public final class FileAccessView
extends Widget
implements UnaryOperator<ChannelFactory> {
    private final TableView<FileAccessItem> table;

    public FileAccessView(Resources resources, Vocabulary vocabulary) {
        TableColumn filenameColumn = new TableColumn(vocabulary.getString((short)82));
        TableColumn accessColumn = new TableColumn(resources.getString((short)65));
        accessColumn.setSortable(false);
        accessColumn.setMinWidth(120.0);
        filenameColumn.setMinWidth(80.0);
        filenameColumn.setPrefWidth(200.0);
        filenameColumn.setCellValueFactory(cell -> new ImmutableObjectProperty<String>(((FileAccessItem)cell.getValue()).filename));
        accessColumn.setCellValueFactory(cell -> new ImmutableObjectProperty<Pane>(((FileAccessItem)cell.getValue()).accessView));
        this.table = new TableView();
        this.table.setColumnResizePolicy(FixedHeaderColumnSize.INSTANCE);
        this.table.getColumns().setAll((Object[])new TableColumn[]{filenameColumn, accessColumn});
    }

    @Override
    public Region getView() {
        return this.table;
    }

    @Override
    public ChannelFactory apply(final ChannelFactory factory) {
        return new ChannelFactory(factory.suggestDirectBuffer){

            public boolean isCoupled() {
                return factory.isCoupled();
            }

            public boolean canReopen() {
                return factory.canReopen();
            }

            public boolean isCreateNew() {
                return factory.isCreateNew();
            }

            private FileAccessItem newItem(String filename) {
                FileAccessItem item = new FileAccessItem((List<FileAccessItem>)FileAccessView.this.table.getItems(), filename);
                Platform.runLater(() -> item.owner.add(item));
                return item;
            }

            public InputStream inputStream(String filename, StoreListeners listeners) throws DataStoreException, IOException {
                InputStream input = factory.inputStream(filename, listeners);
                FileAccessItem fileAccessItem = this.newItem(filename);
                Objects.requireNonNull(fileAccessItem);
                return fileAccessItem.new FileAccessItem.InputObserver(input);
            }

            public ReadableByteChannel readable(String filename, StoreListeners listeners) throws DataStoreException, IOException {
                ReadableByteChannel channel = factory.readable(filename, listeners);
                if (channel instanceof SeekableByteChannel) {
                    FileAccessItem item = this.newItem(filename);
                    if (channel instanceof FileCacheByteChannel) {
                        ((FileCacheByteChannel)channel).setFilter((input, start, end) -> {
                            FileAccessItem fileAccessItem = item;
                            Objects.requireNonNull(fileAccessItem);
                            return fileAccessItem.new FileAccessItem.InputObserver(input, start);
                        });
                    }
                    FileAccessItem fileAccessItem = item;
                    Objects.requireNonNull(fileAccessItem);
                    return fileAccessItem.new FileAccessItem.Observer((SeekableByteChannel)channel);
                }
                return channel;
            }

            public WritableByteChannel writable(String filename, StoreListeners listeners) throws DataStoreException, IOException {
                return factory.writable(filename, listeners);
            }
        };
    }
}

