/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.paint.Color;
import org.apache.sis.gui.internal.GUIUtilities;

public final class ColorName {
    private static final Map<Color, String> NAMES = new HashMap<Color, String>(175);

    private ColorName() {
    }

    public static String of(Color color) {
        String name = NAMES.get(color);
        if (name == null) {
            name = Integer.toHexString(GUIUtilities.toARGB(color));
        }
        return name;
    }

    public static String of(int color) {
        String name = NAMES.get(GUIUtilities.fromARGB(color));
        if (name == null) {
            name = Integer.toHexString(color);
        }
        return name;
    }

    static {
        StringBuilder buffer = new StringBuilder();
        for (Field field : Color.class.getFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Color.class.equals(field.getType())) continue;
            try {
                String name = field.getName();
                buffer.append(name.toLowerCase());
                buffer.setCharAt(0, name.charAt(0));
                NAMES.put((Color)field.get(null), buffer.toString());
                buffer.setLength(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

