/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.dataset;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.TransformationList;
import javafx.event.EventHandler;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextAlignment;
import javafx.util.Callback;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.gui.dataset.ExpandedFeature;
import org.apache.sis.gui.dataset.FeatureList;
import org.apache.sis.gui.internal.Styles;
import org.apache.sis.util.internal.UnmodifiableArrayList;

final class ExpandableList
extends TransformationList<AbstractFeature, AbstractFeature>
implements Callback<TableColumn<AbstractFeature, AbstractFeature>, TableCell<AbstractFeature, AbstractFeature>>,
EventHandler<MouseEvent> {
    private static final Background EXPANSION_HEADER = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Styles.EXPANDED_ROW, null, null)});
    private static final String EXPANDABLE = "\ud83d\uddc7";
    private static final String EXPANDED = "\ud83d\uddca";
    private final Map<String, Integer> nameToIndex = new LinkedHashMap<String, Integer>();
    private int indexOfExpanded = Integer.MAX_VALUE;
    private ExpandedFeature[] expansion;

    ExpandableList(FeatureList features) {
        super((ObservableList)features);
    }

    final void setMultivaluedColumns(List<String> columnNames) {
        assert (this.expansion == null) : this.indexOfExpanded;
        this.nameToIndex.clear();
        int size = columnNames.size();
        for (int i = 0; i < size; ++i) {
            this.nameToIndex.putIfAbsent(columnNames.get(i), i);
        }
    }

    private List<AbstractFeature> shrink() {
        UnmodifiableArrayList removed = this.expansion == null ? null : UnmodifiableArrayList.wrap((Object[])this.expansion, (int)1, (int)this.expansion.length);
        this.expansion = null;
        this.indexOfExpanded = Integer.MAX_VALUE;
        return removed;
    }

    public void clear() {
        int removeAfter = this.indexOfExpanded;
        List<AbstractFeature> removed = this.shrink();
        if (removed != null) {
            this.beginChange();
            this.nextUpdate(removeAfter);
            this.nextRemove(removeAfter + 1, removed);
            this.endChange();
        }
        this.getSource().clear();
    }

    public void handle(MouseEvent event) {
        IconCell cell = (IconCell)((Object)event.getSource());
        int index = this.getSourceIndex(cell.getIndex());
        int removeAfter = this.indexOfExpanded;
        List<AbstractFeature> removed = this.shrink();
        if (index != this.indexOfExpanded) {
            this.expansion = ExpandedFeature.create((AbstractFeature)cell.getItem(), this.nameToIndex);
            if (this.expansion != null) {
                this.indexOfExpanded = index;
                int limit = Integer.MAX_VALUE - this.getSource().size();
                if (this.expansion.length > limit) {
                    if (limit > 1) {
                        this.expansion = Arrays.copyOf(this.expansion, limit);
                    } else {
                        this.expansion = null;
                        this.indexOfExpanded = Integer.MAX_VALUE;
                    }
                }
            }
        }
        this.beginChange();
        if (removed != null) {
            this.nextUpdate(removeAfter);
            this.nextRemove(removeAfter + 1, removed);
        }
        if (this.expansion != null) {
            this.nextAdd(this.indexOfExpanded + 1, Math.addExact(this.indexOfExpanded, this.expansion.length));
        }
        this.endChange();
    }

    private boolean isExpandable(AbstractFeature feature) {
        if (feature != null) {
            for (String name : this.nameToIndex.keySet()) {
                int size;
                Object value = feature.getPropertyValue(name);
                if (!(value instanceof Collection) || (size = ((Collection)value).size()) < 2) continue;
                return true;
            }
        }
        return false;
    }

    public int size() {
        int size = this.getSource().size();
        if (size != 0 && this.expansion != null) {
            size += this.expansion.length - 1;
        }
        return size;
    }

    public AbstractFeature get(int index) {
        int i = index - this.indexOfExpanded;
        if (i >= 0) {
            int n = this.expansion.length;
            if (i < n) {
                return this.expansion[i];
            }
            index -= n;
        }
        return (AbstractFeature)this.getSource().get(index);
    }

    public int getSourceIndex(int index) {
        if (index > this.indexOfExpanded) {
            index = Math.max(this.indexOfExpanded, index - (this.expansion.length - 1));
        }
        return index;
    }

    public int getViewIndex(int index) {
        if (index > this.indexOfExpanded) {
            index += this.expansion.length - 1;
        }
        return index;
    }

    protected void sourceChanged(final ListChangeListener.Change<? extends AbstractFeature> c) {
        this.fireChange((ListChangeListener.Change)new ListChangeListener.Change<AbstractFeature>((ObservableList)this){

            public void reset() {
                c.reset();
            }

            public boolean next() {
                return c.next();
            }

            public boolean wasAdded() {
                return c.wasAdded();
            }

            public boolean wasRemoved() {
                return c.wasRemoved();
            }

            public boolean wasReplaced() {
                return c.wasReplaced();
            }

            public boolean wasUpdated() {
                return c.wasUpdated();
            }

            public boolean wasPermutated() {
                return c.wasPermutated();
            }

            protected int[] getPermutation() {
                return null;
            }

            public int getPermutation(int i) {
                return ExpandableList.this.getViewIndex(c.getPermutation(ExpandableList.this.getSourceIndex(i)));
            }

            public int getFrom() {
                return ExpandableList.this.getViewIndex(c.getFrom());
            }

            public int getTo() {
                return this.wasAdded() || !this.wasRemoved() ? ExpandableList.this.getViewIndex(c.getTo()) : this.getFrom();
            }

            public int getRemovedSize() {
                int removedSize = c.getRemovedSize();
                if (ExpandableList.this.overlapExpanded(c.getFrom(), removedSize)) {
                    removedSize += ExpandableList.this.expansion.length - 1;
                }
                return removedSize;
            }

            public List<AbstractFeature> getRemoved() {
                return ExpandableList.this.expandRemoved(c.getFrom(), c.getRemoved());
            }
        });
    }

    private boolean overlapExpanded(int sourceFrom, int removedSize) {
        return sourceFrom <= this.indexOfExpanded && sourceFrom > this.indexOfExpanded - removedSize;
    }

    private List<? extends AbstractFeature> expandRemoved(int sourceFrom, List<? extends AbstractFeature> removed) {
        if (!this.overlapExpanded(sourceFrom, removed.size())) {
            return removed;
        }
        int s = this.indexOfExpanded;
        int n = this.expansion.length;
        AbstractFeature[] features = removed.toArray(new AbstractFeature[removed.size() + (n - 1)]);
        System.arraycopy(features, s + 1, features, s + n, features.length - (s + 1));
        System.arraycopy(this.expansion, 0, features, s, n);
        return Arrays.asList(features);
    }

    public TableCell<AbstractFeature, AbstractFeature> call(TableColumn<AbstractFeature, AbstractFeature> column) {
        return new IconCell();
    }

    private final class IconCell
    extends TableCell<AbstractFeature, AbstractFeature> {
        private boolean isListening;

        IconCell() {
            this.setTextAlignment(TextAlignment.CENTER);
        }

        protected void updateItem(AbstractFeature value, boolean empty) {
            super.updateItem((Object)value, empty);
            Background b = null;
            String text = null;
            if (value instanceof ExpandedFeature) {
                if (((ExpandedFeature)value).index == 0) {
                    text = ExpandableList.EXPANDED;
                } else {
                    b = EXPANSION_HEADER;
                }
            } else if (ExpandableList.this.isExpandable(value)) {
                text = ExpandableList.EXPANDABLE;
            }
            this.setBackground(b);
            this.setText(text);
            this.isListening = text != null;
            if (this.isListening != this.isListening) {
                if (this.isListening) {
                    this.addEventFilter(MouseEvent.MOUSE_CLICKED, ExpandableList.this);
                } else {
                    this.removeEventFilter(MouseEvent.MOUSE_CLICKED, ExpandableList.this);
                }
            }
        }
    }
}

