/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.util.Locale;
import java.util.Objects;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.ChoiceBox;
import javafx.util.StringConverter;
import org.apache.sis.gui.coverage.CoverageCanvas;
import org.apache.sis.image.Interpolation;
import org.apache.sis.util.resources.Vocabulary;

final class InterpolationConverter
extends StringConverter<Interpolation> {
    private static final Interpolation[] INTERPOLATIONS = new Interpolation[]{Interpolation.NEAREST, Interpolation.BILINEAR, Interpolation.LANCZOS};
    private static final short[] VOCABULARIES = new short[]{232, 230, 0};
    private final Locale locale;

    static ChoiceBox<Interpolation> button(CoverageCanvas view) {
        ChoiceBox b = new ChoiceBox();
        b.setConverter((StringConverter)new InterpolationConverter(view.getLocale()));
        b.getItems().setAll((Object[])INTERPOLATIONS);
        b.getSelectionModel().select((Object)view.getInterpolation());
        view.interpolationProperty.bind((ObservableValue)b.getSelectionModel().selectedItemProperty());
        return b;
    }

    private InterpolationConverter(Locale locale) {
        this.locale = locale;
    }

    public String toString(Interpolation item) {
        for (int i = 0; i < INTERPOLATIONS.length; ++i) {
            if (!INTERPOLATIONS[i].equals(item)) continue;
            short key = VOCABULARIES[i];
            if (key != 0) {
                return Vocabulary.getResources((Locale)this.locale).getString(key);
            }
            if (item != Interpolation.LANCZOS) continue;
            return "Lanczos";
        }
        return Objects.toString(item);
    }

    public Interpolation fromString(String text) {
        Vocabulary vocabulary = Vocabulary.getResources((Locale)this.locale);
        for (int i = 0; i < VOCABULARIES.length; ++i) {
            short key = VOCABULARIES[i];
            Interpolation item = INTERPOLATIONS[i];
            if ((key == 0 || !vocabulary.getString(key).equalsIgnoreCase(text)) && !item.toString().equalsIgnoreCase(text)) continue;
            return item;
        }
        return null;
    }
}

