/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.util.Optional;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.gui.coverage.MultiResolutionImageLoader;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.util.ArgumentChecks;

public class ImageRequest {
    final GridCoverageResource resource;
    final GridCoverage coverage;
    private final GridGeometry domain;
    private final int[] range;
    final GridExtent slice;
    GridGeometry zoom;

    ImageRequest(GridCoverageResource source, GridCoverage data, GridExtent aoi) {
        this.resource = source;
        this.coverage = data;
        this.domain = null;
        this.range = null;
        this.slice = aoi;
    }

    public ImageRequest(GridCoverageResource source, GridGeometry domain, int ... range) {
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        this.resource = source;
        this.domain = domain;
        this.range = range != null && range.length != 0 ? range : null;
        this.coverage = null;
        this.slice = null;
    }

    public ImageRequest(GridCoverage source, GridExtent slice) {
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        this.coverage = source;
        this.slice = slice;
        this.resource = null;
        this.domain = null;
        this.range = null;
    }

    public final Optional<GridCoverageResource> getResource() {
        return Optional.ofNullable(this.resource);
    }

    public final Optional<GridCoverage> getCoverage() {
        return Optional.ofNullable(this.coverage);
    }

    public final Optional<GridGeometry> getDomain() {
        return Optional.ofNullable(this.domain);
    }

    public final Optional<int[]> getRange() {
        return Optional.ofNullable(this.range);
    }

    public final Optional<GridExtent> getSliceExtent() {
        return Optional.ofNullable(this.slice);
    }

    final GridCoverage load() throws DataStoreException {
        if (this.coverage != null) {
            return this.coverage;
        }
        return MultiResolutionImageLoader.getInstance(this.resource, null).getOrLoad(this.domain, this.range);
    }
}

