/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javafx.concurrent.Task;
import org.apache.sis.gui.coverage.GridError;
import org.apache.sis.gui.coverage.GridView;
import org.apache.sis.gui.coverage.GridViewSkin;
import org.apache.sis.gui.internal.BackgroundThreads;

final class GridTile {
    final int tileX;
    final int tileY;
    private final int hashCode;
    private Raster tile;
    private GridError error;
    private boolean loading;

    GridTile(int tileX, int tileY, int numXTiles) {
        this.tileX = tileX;
        this.tileY = tileY;
        this.hashCode = tileX + tileY * numXTiles;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (other instanceof GridTile) {
            GridTile that = (GridTile)other;
            return this.tileX == that.tileX && this.tileY == that.tileY;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getCanonicalName() + "[" + this.tileX + ", " + this.tileY + "]";
    }

    final Raster tile() {
        return this.tile;
    }

    final boolean clearTile() {
        if (this.loading) {
            return false;
        }
        this.tile = null;
        return this.error == null;
    }

    final void clear() {
        this.tile = null;
        this.error = null;
        this.loading = false;
    }

    final void load(final GridView view) {
        if (!this.loading && this.error == null) {
            this.loading = true;
            final RenderedImage image = view.getImage();
            BackgroundThreads.execute((Runnable)new Task<Raster>(){

                protected Raster call() {
                    return image.getTile(GridTile.this.tileX, GridTile.this.tileY);
                }

                protected void succeeded() {
                    GridTile.this.clear();
                    if (view.getImage() == image) {
                        GridTile.this.tile = (Raster)this.getValue();
                        view.contentChanged(false);
                    }
                }

                protected void failed() {
                    GridTile.this.clear();
                    if (view.getImage() == image) {
                        GridTile.this.error = new GridError(view, GridTile.this, this.getException());
                        ((GridViewSkin)view.getSkin()).errorOccurred(GridTile.this.error);
                    }
                }

                protected void cancelled() {
                    GridTile.this.clear();
                }
            });
        }
    }
}

