/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.util.Optional;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.util.Callback;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.gui.coverage.CellFormat;
import org.apache.sis.measure.Range;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.GenericName;

final class BandRangeTable
implements Callback<TableColumn<SampleDimension, Number>, TableCell<SampleDimension, Number>> {
    private static final String NAME = "name";
    private static final String MINIMUM = "minimum";
    private static final String MAXIMUM = "maximum";
    private static final String UNITS = "units";
    private static final int NUM_VISIBLE_ROW = 5;
    private final CellFormat cellFormat;

    BandRangeTable(CellFormat format) {
        this.cellFormat = format;
    }

    TableView<SampleDimension> create(Vocabulary vocabulary) {
        TableView table = new TableView();
        table.setPrefHeight(150.0);
        table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        table.getColumns().setAll((Object[])new TableColumn[]{BandRangeTable.createStringColumn(vocabulary, (short)139, NAME), this.createNumberColumn(vocabulary, (short)133, MINIMUM), this.createNumberColumn(vocabulary, (short)127, MAXIMUM), BandRangeTable.createStringColumn(vocabulary, (short)206, UNITS)});
        return table;
    }

    private static TableColumn<SampleDimension, String> createStringColumn(Vocabulary vocabulary, short key, String id) {
        TableColumn column = new TableColumn(vocabulary.getString(key));
        column.setCellValueFactory(BandRangeTable::getStringValue);
        column.setId(id);
        return column;
    }

    private TableColumn<SampleDimension, Number> createNumberColumn(Vocabulary vocabulary, short key, String id) {
        TableColumn column = new TableColumn(vocabulary.getString(key));
        column.setCellValueFactory(this::getNumberValue);
        column.setCellFactory((Callback)this);
        column.setId(id);
        return column;
    }

    public TableCell<SampleDimension, Number> call(TableColumn<SampleDimension, Number> column) {
        return new Numeric(this.cellFormat);
    }

    private static ObservableValue<String> getStringValue(TableColumn.CellDataFeatures<SampleDimension, String> cell) {
        SampleDimension sd = (SampleDimension)cell.getValue();
        return (switch (cell.getTableColumn().getId()) {
            case NAME -> Optional.ofNullable(sd.getName()).map(GenericName::toInternationalString);
            case UNITS -> sd.getUnits();
            default -> throw new AssertionError();
        }).map(Object::toString).map(ReadOnlyObjectWrapper::new).orElse(null);
    }

    private ObservableValue<Number> getNumberValue(TableColumn.CellDataFeatures<SampleDimension, Number> cell) {
        Optional range = ((SampleDimension)cell.getValue()).getSampleRange();
        return (switch (cell.getTableColumn().getId()) {
            case MINIMUM -> range.map(Range::getMinValue);
            case MAXIMUM -> range.map(Range::getMaxValue);
            default -> throw new AssertionError();
        }).map(ReadOnlyObjectWrapper::new).orElse(null);
    }

    private static final class Numeric
    extends TableCell<SampleDimension, Number> {
        private final CellFormat cellFormat;

        Numeric(CellFormat format) {
            this.cellFormat = format;
            this.setAlignment(Pos.CENTER_RIGHT);
        }

        public void updateItem(Number item, boolean empty) {
            this.setText(empty || item == null ? "" : this.cellFormat.format(item));
        }
    }
}

