/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.controls;

import java.math.BigDecimal;
import java.util.Locale;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import org.apache.sis.gui.controls.ColorColumnHandler;
import org.apache.sis.gui.controls.ColorRamp;
import org.apache.sis.gui.controls.FormatApplicator;
import org.apache.sis.gui.controls.FormatTableCell;
import org.apache.sis.gui.controls.TabularWidget;
import org.apache.sis.gui.internal.Resources;
import org.apache.sis.gui.internal.Styles;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.resources.Vocabulary;

public final class ValueColorMapper
extends TabularWidget {
    private final FormatApplicator<Number> textConverter;
    private final TableView<Step> table = ValueColorMapper.newTable();
    private Dialog<Range> rangeEditor;

    public ValueColorMapper(Resources resources, Vocabulary vocabulary) {
        this.textConverter = FormatApplicator.createNumberFormat();
        this.createIsolineTable(vocabulary);
        MenuItem rangeMenu = new MenuItem(resources.getString((short)56));
        MenuItem clearAll = new MenuItem(resources.getString((short)55));
        rangeMenu.setOnAction(e -> this.insertRangeOfValues());
        clearAll.setOnAction(e -> {
            ObservableList<Step> steps = this.getSteps();
            steps.remove(0, steps.size() - 1);
        });
        this.table.setContextMenu(new ContextMenu(new MenuItem[]{rangeMenu, clearAll}));
    }

    @Override
    public Region getView() {
        return this.table;
    }

    public ObservableList<Step> getSteps() {
        return this.table.getItems();
    }

    private static void commitEdit(TableColumn.CellEditEvent<Step, Number> event) {
        int row;
        Step level = (Step)event.getRowValue();
        Number obj = (Number)event.getNewValue();
        double value = obj != null ? obj.doubleValue() : Double.NaN;
        level.value.set(value);
        level.visible.set(true);
        TableView table = event.getTableView();
        ObservableList items = table.getItems();
        int dst = row = event.getTablePosition().getRow();
        while (--dst >= 0 && ((Step)items.get((int)dst)).value.get() >= value) {
        }
        int size = items.size() - 1;
        while (!(++dst >= size || dst != row && ((Step)items.get((int)dst)).value.get() > value)) {
        }
        if (dst != row) {
            if (dst >= row) {
                --dst;
            }
            items.add(dst, (Object)((Step)items.remove(row)));
            table.getSelectionModel().select(dst);
        }
        if (row >= size) {
            items.add((Object)new Step());
        }
        if (level.color.get() == null) {
            Color color = Color.BLACK;
            int last = items.size() - 2;
            if (last >= 2) {
                int ilo = dst - 1;
                int iup = dst + 1;
                if (ilo < 0) {
                    ilo = 1;
                    iup = 2;
                } else if (iup > last) {
                    iup = last - 1;
                    ilo = last - 2;
                }
                Step lo = (Step)items.get(ilo);
                Step up = (Step)items.get(iup);
                double base = lo.value.get();
                double f = (value - base) / (up.value.get() - base);
                Color clo = ((ColorRamp)lo.color.get()).color();
                Color cup = ((ColorRamp)up.color.get()).color();
                color = new Color(ValueColorMapper.interpolate(f, clo.getRed(), cup.getRed()), ValueColorMapper.interpolate(f, clo.getGreen(), cup.getGreen()), ValueColorMapper.interpolate(f, clo.getBlue(), cup.getBlue()), ValueColorMapper.interpolate(f, clo.getOpacity(), cup.getOpacity()));
            }
            level.color.set((Object)new ColorRamp(color));
        }
    }

    private static double interpolate(double f, double lo, double up) {
        return Math.max(0.0, Math.min(1.0, (up - lo) * f + lo));
    }

    private void createIsolineTable(Vocabulary vocabulary) {
        TableColumn visible = ValueColorMapper.newBooleanColumn("\ud83d\udd89", cell -> ((Step)cell.getValue()).visible);
        TableColumn level = new TableColumn(vocabulary.getString((short)114));
        FormatTableCell.Trigger<Step> trigger = new FormatTableCell.Trigger<Step>(level, this.textConverter.format);
        level.setCellFactory(column -> new FormatTableCell(this.textConverter, trigger));
        level.setCellValueFactory(cell -> ((Step)cell.getValue()).value);
        level.setOnEditCommit(ValueColorMapper::commitEdit);
        level.setSortable(false);
        level.setId("level");
        this.table.getColumns().setAll((Object[])new TableColumn[]{visible, level});
        ColumnHandler handler = new ColumnHandler();
        handler.addColumnTo(this.table, vocabulary.getString((short)251));
        this.getSteps().add((Object)new Step());
        trigger.registerTo(this.table);
        this.table.setOnKeyPressed(ValueColorMapper::deleteRow);
    }

    private static void deleteRow(KeyEvent event) {
        TableView table = (TableView)event.getSource();
        if (event.getCode() == KeyCode.DELETE) {
            int row = table.getSelectionModel().getSelectedIndex();
            ObservableList items = table.getItems();
            if (row >= 0 && row < items.size() - 1) {
                items.remove(row);
            }
        }
    }

    private void insertRangeOfValues() {
        if (this.rangeEditor == null) {
            this.rangeEditor = Range.createDialog(this.textConverter, this.table);
        }
        this.rangeEditor.showAndWait().ifPresent(r -> {
            ObservableList<Step> steps = this.getSteps();
            int position = 0;
            BigDecimal decimal = r.minimum;
            block0: while (decimal.compareTo(r.maximum) <= 0) {
                double value = decimal.doubleValue();
                decimal = decimal.add(r.interval);
                while (position < steps.size()) {
                    double existing = ((Step)steps.get((int)position)).value.get();
                    if (existing == value) continue block0;
                    if (!(existing <= value)) break;
                    ++position;
                }
                steps.add(position, (Object)new Step(value, r.color));
            }
        });
    }

    public static final class Step
    implements Comparable<Step> {
        public final DoubleProperty value = new SimpleDoubleProperty((Object)this, "value", Double.NaN);
        public final ObjectProperty<ColorRamp> color = new SimpleObjectProperty((Object)this, "color");
        public final BooleanProperty visible = new SimpleBooleanProperty((Object)this, "visible");

        Step() {
        }

        Step(double value, Color color) {
            this();
            this.value.set(value);
            this.color.set((Object)new ColorRamp(color));
            this.visible.set(true);
        }

        @Override
        public int compareTo(Step other) {
            return Double.compare(this.value.get(), other.value.get());
        }

        public boolean equals(Object other) {
            if (other instanceof Step) {
                Step that = (Step)other;
                return Numerics.equals((double)this.value.get(), (double)that.value.get()) && Objects.equals(this.color.get(), that.color.get()) && this.visible.get() == that.visible.get();
            }
            return false;
        }

        public int hashCode() {
            return Double.hashCode(this.value.get()) + Objects.hashCode(this.color.get()) + Boolean.hashCode(this.visible.get());
        }

        public String toString() {
            return Double.toString(this.value.get()) + " = " + Objects.toString(this.color.get());
        }
    }

    private static final class ColumnHandler
    extends ColorColumnHandler<Step> {
        ColumnHandler() {
        }

        @Override
        protected ObservableValue<ColorRamp> getObservableValue(Step level) {
            return level.color;
        }

        @Override
        protected ColorRamp.Type applyColors(Step level, ColorRamp colors) {
            level.color.set((Object)colors);
            return ColorRamp.Type.SOLID;
        }
    }

    private static final class Range {
        final BigDecimal minimum;
        final BigDecimal maximum;
        final BigDecimal interval;
        final Color color;

        private Range(TextField minimum, TextField maximum, TextField interval, ColorPicker color) {
            this.minimum = Range.decimal(minimum);
            this.maximum = Range.decimal(maximum);
            this.interval = Range.decimal(interval);
            this.color = (Color)color.getValue();
        }

        private static BigDecimal decimal(TextField field) {
            Object value = field.getUserData();
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            return BigDecimal.valueOf(((Number)value).doubleValue());
        }

        static Dialog<Range> createDialog(FormatApplicator<Number> textConverter, Node owner) {
            Vocabulary vocabulary = Vocabulary.getResources((Locale)null);
            TextField minimum = new TextField();
            TextField maximum = new TextField();
            TextField interval = new TextField();
            ColorPicker colorInRange = new ColorPicker(Color.BLACK);
            colorInRange.setMaxWidth(Double.MAX_VALUE);
            GridPane content = Styles.createControlGrid(0, Range.createRow((Node)minimum, vocabulary, (short)133), Range.createRow((Node)maximum, vocabulary, (short)127), Range.createRow((Node)interval, vocabulary, (short)253), Range.createRow((Node)colorInRange, vocabulary, (short)251));
            Dialog rangeEditor = new Dialog();
            rangeEditor.initOwner(owner.getScene().getWindow());
            rangeEditor.setTitle(vocabulary.getString((short)252));
            rangeEditor.setHeaderText(Resources.format((short)57));
            DialogPane pane = rangeEditor.getDialogPane();
            pane.setContent((Node)content);
            pane.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.APPLY, ButtonType.CANCEL});
            Node apply = pane.lookupButton(ButtonType.APPLY);
            apply.setDisable(true);
            minimum.requestFocus();
            textConverter.setListenersOn(minimum);
            textConverter.setListenersOn(maximum);
            textConverter.setListenersOn(interval);
            textConverter.listener = p -> {
                boolean isValid = Range.valueOf(maximum) >= Range.valueOf(minimum) && Range.valueOf(interval) > 0.0;
                apply.setDisable(!isValid);
            };
            rangeEditor.setResultConverter(button -> {
                if (button == ButtonType.APPLY) {
                    return new Range(minimum, maximum, interval, colorInRange);
                }
                return null;
            });
            return rangeEditor;
        }

        private static Label createRow(Node editor, Vocabulary vocabulary, short key) {
            Label label = new Label(vocabulary.getLabel(key));
            label.setLabelFor(editor);
            return label;
        }

        private static double valueOf(TextField editor) {
            Number value = (Number)editor.getUserData();
            return value != null ? value.doubleValue() : Double.NaN;
        }
    }
}

