/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import org.apache.sis.console.FormattedOutputCommand;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.console.Option;
import org.apache.sis.console.OutputFormat;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.io.LineAppender;
import org.apache.sis.io.TableAppender;
import org.apache.sis.io.wkt.Colors;
import org.apache.sis.io.wkt.Transliterator;
import org.apache.sis.io.wkt.WKTFormat;
import org.apache.sis.io.wkt.Warnings;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.DefaultObjectDomain;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.internal.Legacy;
import org.apache.sis.referencing.util.DirectPositionView;
import org.apache.sis.referencing.util.ReferencingUtilities;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStores;
import org.apache.sis.storage.base.CodeType;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.internal.X364;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.PassThroughOperation;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

final class TransformCommand
extends FormattedOutputCommand {
    private CoordinateOperation operation;
    private MathTransform toDomainOfValidity;
    private final Vocabulary resources;
    private TableAppender outHeader;
    private NumberFormat coordinateFormat;
    private int coordinateWidth;
    private int[] numFractionDigits;
    private double[] thresholdForScientificNotation;
    private String errorMessage;
    private NumberFormatException errorCause;

    private static EnumSet<Option> options() {
        return EnumSet.of(Option.SOURCE_CRS, new Option[]{Option.TARGET_CRS, Option.VERBOSE, Option.LOCALE, Option.TIMEZONE, Option.ENCODING, Option.COLORS, Option.HELP, Option.DEBUG});
    }

    TransformCommand(int commandIndex, String ... args) throws InvalidOptionException {
        super(commandIndex, args, TransformCommand.options(), OutputFormat.WKT, OutputFormat.TEXT);
        this.resources = Vocabulary.getResources((Locale)this.locale);
    }

    private CoordinateReferenceSystem fetchCRS(Option option) throws InvalidOptionException, FactoryException, DataStoreException {
        Metadata metadata;
        String identifier = (String)this.options.get((Object)option);
        if (identifier == null) {
            String name = option.label();
            throw new InvalidOptionException(Errors.format((short)88, (Object)name), name);
        }
        if (CodeType.guess((String)identifier).isCRS) {
            try {
                return CRS.forCode((String)identifier);
            }
            catch (NoSuchAuthorityCodeException e) {
                String name = option.label();
                throw new InvalidOptionException(Errors.format((short)56, (Object)name, (Object)identifier), e, name);
            }
        }
        try (DataStore store = DataStores.open((Object)identifier);){
            metadata = store.getMetadata();
        }
        if (metadata != null) {
            for (ReferenceSystem rs : metadata.getReferenceSystemInfo()) {
                if (!(rs instanceof CoordinateReferenceSystem)) continue;
                return (CoordinateReferenceSystem)rs;
            }
        }
        throw new InvalidOptionException(Errors.format((short)157), option.label());
    }

    @Override
    public int run() throws Exception {
        CoordinateReferenceSystem sourceCRS = this.fetchCRS(Option.SOURCE_CRS);
        CoordinateReferenceSystem targetCRS = this.fetchCRS(Option.TARGET_CRS);
        GeographicBoundingBox areaOfInterest = null;
        List<double[]> points = List.of();
        boolean useStandardInput = this.useStandardInput();
        if (useStandardInput || !this.files.isEmpty()) {
            if (useStandardInput) {
                try (LineNumberReader in = new LineNumberReader(new InputStreamReader(System.in, this.encoding));){
                    points = this.readCoordinates(in, "stdin");
                }
            } else {
                for (String file : this.files) {
                    try (LineNumberReader in = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), this.encoding));){
                        points = this.readCoordinates(in, file);
                    }
                }
            }
            try {
                GeographicCRS domainOfValidityCRS = ReferencingUtilities.toNormalizedGeographicCRS((CoordinateReferenceSystem)sourceCRS, (boolean)false, (boolean)false);
                if (domainOfValidityCRS != null) {
                    this.toDomainOfValidity = CRS.findOperation((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)domainOfValidityCRS, null).getMathTransform();
                    areaOfInterest = this.computeAreaOfInterest(points);
                }
            }
            catch (FactoryException e) {
                TransformCommand.warning((Exception)((Object)e));
            }
        }
        this.operation = CRS.findOperation((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, areaOfInterest);
        this.outHeader = new TableAppender((Appendable)new LineAppender((Appendable)this.out), " ");
        this.outHeader.setMultiLinesCells(true);
        this.printHeader((short)182);
        this.printNameAndIdentifier((IdentifiedObject)this.operation.getSourceCRS(), false);
        this.printHeader((short)61);
        this.printNameAndIdentifier((IdentifiedObject)this.operation.getTargetCRS(), false);
        this.printHeader((short)151);
        this.printOperations(this.operation, false);
        this.outHeader.nextLine();
        this.printDomainOfValidity(Legacy.getDomains((IdentifiedObject)this.operation));
        this.printAccuracy(CRS.getLinearAccuracy((CoordinateOperation)this.operation));
        if (this.options.containsKey((Object)Option.VERBOSE)) {
            this.printDetails();
        }
        this.outHeader.flush();
        this.outHeader = null;
        if (!points.isEmpty()) {
            this.coordinateWidth = 15;
            this.coordinateFormat = NumberFormat.getInstance(Locale.US);
            this.coordinateFormat.setGroupingUsed(false);
            this.computeNumFractionDigits(this.operation.getTargetCRS().getCoordinateSystem());
            this.out.println();
            this.printAxes(this.operation.getTargetCRS().getCoordinateSystem());
            this.out.println();
            this.transform(points);
            if (this.errorMessage != null) {
                this.error(this.errorMessage, this.errorCause);
            }
        }
        return 0;
    }

    private void printCommentLinePrefix() {
        if (this.colors) {
            this.outHeader.append((CharSequence)X364.FOREGROUND_GRAY.sequence());
        }
        this.outHeader.append((CharSequence)"# ");
        if (this.colors) {
            this.outHeader.append((CharSequence)X364.FOREGROUND_DEFAULT.sequence());
        }
    }

    private void printHeader(short key) throws IOException {
        this.printCommentLinePrefix();
        this.resources.appendLabel(key, (Appendable)this.outHeader);
        this.outHeader.nextColumn();
    }

    private boolean printNameAndIdentifier(IdentifiedObject object, boolean idRequired) {
        String identifier = IdentifiedObjects.toString((Identifier)IdentifiedObjects.getIdentifier((IdentifiedObject)object, null));
        if (idRequired && identifier == null) {
            return false;
        }
        this.outHeader.append((CharSequence)object.getName().getCode());
        if (identifier != null) {
            this.outHeader.append(' ');
            if (this.colors) {
                this.outHeader.append((CharSequence)X364.FOREGROUND_CYAN.sequence());
            }
            this.outHeader.append('(');
            this.outHeader.append((CharSequence)identifier);
            this.outHeader.append(')');
            if (this.colors) {
                this.outHeader.append((CharSequence)X364.FOREGROUND_DEFAULT.sequence());
            }
        }
        if (!idRequired) {
            this.outHeader.nextLine();
        }
        return true;
    }

    private void printOperations(CoordinateOperation step, boolean isNext) {
        if (isNext) {
            isNext = false;
            if (this.colors) {
                this.outHeader.append((CharSequence)X364.FOREGROUND_GREEN.sequence());
            }
            this.outHeader.append((CharSequence)" \u2192 ");
            if (this.colors) {
                this.outHeader.append((CharSequence)X364.FOREGROUND_DEFAULT.sequence());
            }
        }
        if (!this.printNameAndIdentifier((IdentifiedObject)step, true)) {
            if (step instanceof ConcatenatedOperation) {
                for (CoordinateOperation op : ((ConcatenatedOperation)step).getOperations()) {
                    this.printOperations(op, isNext);
                    isNext = true;
                }
            } else if (step instanceof PassThroughOperation) {
                this.printOperations((CoordinateOperation)((PassThroughOperation)step).getOperation(), false);
            } else if (step instanceof SingleOperation) {
                this.outHeader.append((CharSequence)((SingleOperation)step).getMethod().getName().getCode());
            }
        }
    }

    private void printAccuracy(double accuracy) throws IOException {
        if (accuracy >= 0.0) {
            if (accuracy == 0.0) {
                accuracy = 0.01;
            }
            this.printHeader((short)2);
            if (this.colors) {
                this.outHeader.append((CharSequence)X364.FOREGROUND_YELLOW.sequence());
            }
            this.outHeader.append((CharSequence)Double.toString(accuracy));
            if (this.colors) {
                this.outHeader.append((CharSequence)X364.FOREGROUND_DEFAULT.sequence());
            }
            this.outHeader.append((CharSequence)" metres");
            this.outHeader.nextLine();
        }
    }

    private void printDomainOfValidity(Collection<DefaultObjectDomain> domains) throws IOException {
        for (DefaultObjectDomain domain : domains) {
            int end;
            Extent extent = domain.getDomainOfValidity();
            InternationalString description = extent.getDescription();
            if (description == null) continue;
            String text = description.toString(this.locale);
            if (text.length() >= 80 && (end = text.indexOf(59)) >= 0) {
                int s = text.lastIndexOf(45, end);
                if (s >= 0) {
                    end = s;
                }
                text = text.substring(0, end).trim();
            }
            this.printHeader((short)69);
            this.outHeader.append((CharSequence)text);
            this.outHeader.nextLine();
            return;
        }
    }

    private void printDetails() throws IOException {
        WKTFormat f = new WKTFormat(this.locale, this.timezone);
        if (this.colors) {
            f.setColors(Colors.DEFAULT);
        }
        f.setConvention(this.convention);
        CharSequence[] lines = CharSequences.splitOnEOL((CharSequence)f.format(this.debug ? this.operation.getMathTransform() : this.operation));
        for (int i = 0; i < lines.length; ++i) {
            if (i == 0) {
                this.printHeader((short)62);
            } else {
                this.printCommentLinePrefix();
                this.outHeader.nextColumn();
            }
            this.outHeader.append(lines[i]);
            this.outHeader.nextLine();
        }
        Warnings warnings = f.getWarnings();
        if (warnings != null && (lines = CharSequences.splitOnEOL((CharSequence)warnings.toString())).length != 0) {
            this.printHeader((short)143);
            this.outHeader.append(lines[0]);
            this.outHeader.nextLine();
        }
    }

    private void printQuotedText(String text, int fieldWidth, X364 color) {
        boolean quoted;
        if (text.indexOf(34) >= 0) {
            text = text.replace("\"", "\"\"");
            quoted = true;
        } else {
            boolean bl = quoted = text.indexOf(44) >= 0;
        }
        if (quoted) {
            fieldWidth -= 2;
        }
        this.out.print(CharSequences.spaces((int)(fieldWidth - text.length())));
        if (this.colors) {
            this.out.print(color.sequence());
        }
        if (quoted) {
            this.out.print('\"');
        }
        this.out.print(text);
        if (quoted) {
            this.out.print('\"');
        }
        if (this.colors) {
            this.out.print(X364.FOREGROUND_DEFAULT.sequence());
        }
    }

    private void printAxes(CoordinateSystem cs) {
        int targetDim = cs.getDimension();
        for (int i = 0; i < targetDim; ++i) {
            if (i != 0) {
                this.out.print(',');
            }
            CoordinateSystemAxis axis = cs.getAxis(i);
            Object name = axis.getName().getCode();
            name = Transliterator.DEFAULT.toShortAxisName(cs, axis.getDirection(), (String)name);
            String unit = axis.getUnit().toString();
            if (!unit.isEmpty()) {
                name = (String)name + " (" + unit + ")";
            }
            this.printQuotedText((String)name, this.coordinateWidth, X364.FOREGROUND_CYAN);
        }
    }

    private void computeNumFractionDigits(CoordinateSystem cs) throws IncommensurableException {
        int dimension = cs.getDimension();
        this.numFractionDigits = new int[dimension];
        this.thresholdForScientificNotation = new double[dimension];
        for (int i = 0; i < dimension; ++i) {
            Unit source;
            double precision;
            Unit unit = cs.getAxis(0).getUnit();
            if (Units.isLinear((Unit)unit)) {
                precision = 0.01;
                source = Units.METRE;
            } else if (Units.isAngular((Unit)unit)) {
                precision = 8.999280057595393E-8;
                source = Units.DEGREE;
            } else {
                precision = 0.001;
                source = unit;
            }
            precision = source.getConverterToAny(unit).convert(precision);
            if (precision > 0.0) {
                this.numFractionDigits[i] = Math.max(DecimalFunctions.fractionDigitsForDelta((double)precision, (boolean)false) + 1, 0);
            }
            this.thresholdForScientificNotation[i] = MathFunctions.pow10((int)(this.coordinateWidth - 1 - this.numFractionDigits[i]));
        }
    }

    private List<double[]> readCoordinates(LineNumberReader in, String filename) throws IOException {
        ArrayList<double[]> points = new ArrayList<double[]>();
        try {
            String line;
            while ((line = in.readLine()) != null) {
                int start = CharSequences.skipLeadingWhitespaces((CharSequence)line, (int)0, (int)line.length());
                if (start >= line.length() || line.charAt(start) == '#') continue;
                points.add(CharSequences.parseDoubles((CharSequence)line, (char)','));
            }
        }
        catch (NumberFormatException e) {
            this.errorMessage = Errors.format((short)33, (Object)filename, (Object)in.getLineNumber());
            this.errorCause = e;
        }
        return points;
    }

    private GeographicBoundingBox computeAreaOfInterest(List<double[]> points) {
        int dimension = this.toDomainOfValidity.getSourceDimensions();
        double[] domainCoordinate = new double[this.toDomainOfValidity.getTargetDimensions()];
        if (domainCoordinate.length >= 2) {
            double xmin = Double.POSITIVE_INFINITY;
            double ymin = Double.POSITIVE_INFINITY;
            double xmax = Double.NEGATIVE_INFINITY;
            double ymax = Double.NEGATIVE_INFINITY;
            for (double[] coordinates : points) {
                if (coordinates.length != dimension) continue;
                try {
                    this.toDomainOfValidity.transform(coordinates, 0, domainCoordinate, 0, 1);
                }
                catch (TransformException e) {
                    TransformCommand.warning((Exception)((Object)e));
                    continue;
                }
                double x = domainCoordinate[0];
                double y = domainCoordinate[1];
                if (x < xmin) {
                    xmin = x;
                }
                if (x > xmax) {
                    xmax = x;
                }
                if (y < ymin) {
                    ymin = y;
                }
                if (!(y > ymax)) continue;
                ymax = y;
            }
            if (xmin < xmax && ymin < ymax) {
                return new DefaultGeographicBoundingBox(xmin, xmax, ymin, ymax);
            }
        }
        return null;
    }

    private void transform(List<double[]> points) throws TransformException {
        DirectPositionView.Double positionInDomain;
        double[] domainCoordinate;
        ImmutableEnvelope domainOfValidity;
        GeographicBoundingBox bbox;
        int dimension = this.operation.getSourceCRS().getCoordinateSystem().getDimension();
        MathTransform mt = this.operation.getMathTransform();
        double[] result = new double[mt.getTargetDimensions()];
        if (this.toDomainOfValidity != null && (bbox = CRS.getGeographicBoundingBox((CoordinateOperation)this.operation)) != null) {
            domainOfValidity = new ImmutableEnvelope(bbox);
            domainCoordinate = new double[this.toDomainOfValidity.getTargetDimensions()];
            positionInDomain = new DirectPositionView.Double(domainCoordinate);
        } else {
            domainOfValidity = null;
            domainCoordinate = null;
            positionInDomain = null;
        }
        for (double[] coordinates : points) {
            if (coordinates.length != dimension) {
                throw new MismatchedDimensionException(Errors.format((short)79, (Object)this.operation.getSourceCRS().getName().getCode(), (Object)dimension, (Object)coordinates.length));
            }
            mt.transform(coordinates, 0, result, 0, 1);
            for (int i = 0; i < result.length; ++i) {
                String s;
                double value;
                if (i != 0) {
                    this.out.print(',');
                }
                if (Math.abs(value = result[i]) >= this.thresholdForScientificNotation[i]) {
                    s = Double.toString(value);
                } else {
                    this.coordinateFormat.setMinimumFractionDigits(this.numFractionDigits[i]);
                    this.coordinateFormat.setMaximumFractionDigits(this.numFractionDigits[i]);
                    s = this.coordinateFormat.format(value);
                }
                this.out.print(CharSequences.spaces((int)(this.coordinateWidth - s.length())));
                this.out.print(s);
            }
            if (domainOfValidity != null) {
                boolean inside;
                try {
                    this.toDomainOfValidity.transform(coordinates, 0, domainCoordinate, 0, 1);
                    inside = domainOfValidity.contains((DirectPosition)positionInDomain);
                }
                catch (TransformException e) {
                    inside = false;
                    TransformCommand.warning((Exception)((Object)e));
                }
                if (!inside) {
                    this.out.print(",    ");
                    this.printQuotedText(Errors.getResources((Locale)this.locale).getString((short)119), 0, X364.FOREGROUND_RED);
                }
            }
            this.out.println();
        }
    }

    private static void warning(Exception e) {
        Logging.recoverableException((Logger)Logger.getLogger("org.apache.sis.console"), TransformCommand.class, (String)"run", (Throwable)e);
    }
}

