/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.EnumSet;
import org.apache.sis.console.CommandRunner;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.console.Option;
import org.apache.sis.storage.DataStores;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;

final class MimeTypeCommand
extends CommandRunner {
    MimeTypeCommand(int commandIndex, String ... arguments) throws InvalidOptionException {
        super(commandIndex, arguments, EnumSet.of(Option.ENCODING, Option.HELP, Option.DEBUG));
    }

    @Override
    public int run() throws Exception {
        if (this.hasUnexpectedFileCount(1, Integer.MAX_VALUE)) {
            return 3;
        }
        int width = 0;
        for (String file : this.files) {
            int length = file.length() + 1;
            if (length <= width) continue;
            width = length;
        }
        for (String file : this.files) {
            String type;
            URI uri;
            try {
                uri = new URI(file);
            }
            catch (URISyntaxException e) {
                this.canNotOpen(0, e);
                return 100;
            }
            if (!uri.isAbsolute()) {
                type = DataStores.probeContentType((Object)file);
            } else {
                try {
                    type = Files.probeContentType(Path.of(uri));
                }
                catch (IllegalArgumentException | FileSystemNotFoundException e) {
                    type = DataStores.probeContentType((Object)uri);
                }
                catch (NoSuchFileException e) {
                    this.error(Errors.format((short)9, (Object)uri), e);
                    return 100;
                }
            }
            if (type == null) continue;
            this.out.print(file);
            this.out.print(':');
            this.out.print(CharSequences.spaces((int)(width - file.length())));
            this.out.println(type);
            this.out.flush();
        }
        return 0;
    }
}

