/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.landsat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreClosedException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.storage.base.URIDataStore;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.WarningEvent;
import org.apache.sis.storage.folder.ConcurrentCloser;
import org.apache.sis.storage.landsat.Band;
import org.apache.sis.storage.landsat.BandGroup;
import org.apache.sis.storage.landsat.BandName;
import org.apache.sis.storage.landsat.LandsatStoreProvider;
import org.apache.sis.storage.landsat.MetadataReader;
import org.apache.sis.util.internal.UnmodifiableArrayList;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.opengis.metadata.Metadata;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.NameSpace;

public class LandsatStore
extends DataStore
implements Aggregate {
    private Reader source;
    final Path directory;
    private final URI location;
    private Metadata metadata;
    private GenericName identifier;
    private volatile BandGroup[] components;
    private static final ConcurrentCloser<Band> CLOSER = new ConcurrentCloser<Band>(){

        protected Callable<?> closer(Band r) {
            return () -> {
                r.closeDataStore();
                return null;
            };
        }
    };

    public LandsatStore(LandsatStoreProvider provider, StorageConnector connector) throws DataStoreException {
        super((DataStoreProvider)provider, connector);
        Path path = (Path)connector.getStorageAs(Path.class);
        this.location = (URI)connector.getStorageAs(URI.class);
        this.source = (Reader)connector.getStorageAs(Reader.class);
        connector.closeAllExcept((Object)this.source);
        if (path != null) {
            if (this.source != null) {
                path = path.getParent();
            } else {
                try {
                    Path file = LandsatStoreProvider.getMetadataFile(path);
                    if (file != null) {
                        Charset encoding = (Charset)connector.getOption(OptionKey.ENCODING);
                        this.source = encoding != null ? Files.newBufferedReader(file, encoding) : Files.newBufferedReader(file);
                    }
                }
                catch (IOException e) {
                    throw new DataStoreException((Throwable)e);
                }
            }
        }
        this.directory = path;
        if (this.source == null) {
            throw new UnsupportedStorageException(super.getLocale(), "Landsat", connector.getStorage(), (OpenOption[])connector.getOption(OptionKey.OPEN_OPTIONS));
        }
        if (((Object)((Object)this)).getClass() == LandsatStore.class) {
            this.listeners.useReadOnlyEvents();
        }
    }

    public final String getDisplayName() {
        return this.directory != null ? this.directory.getFileName().toString() : super.getDisplayName();
    }

    public Optional<ParameterValueGroup> getOpenParameters() {
        return Optional.ofNullable(URIDataStore.parameters((DataStoreProvider)this.provider, (URI)this.location));
    }

    public synchronized Optional<GenericName> getIdentifier() throws DataStoreException {
        if (this.identifier == null) {
            this.identifier = super.getIdentifier().orElse(null);
        }
        return Optional.ofNullable(this.identifier);
    }

    private BandGroup[] loadMetadata() throws DataStoreException {
        BandGroup[] bands;
        Band[] resources;
        if (this.source == null) {
            throw new DataStoreClosedException(this.getLocale(), "Landsat", new OpenOption[]{StandardOpenOption.READ});
        }
        String name = this.getDisplayName();
        DefaultNameFactory factory = DefaultNameFactory.provider();
        NameSpace scope = name != null ? factory.createNameSpace((GenericName)factory.createLocalName(null, (CharSequence)name), null) : null;
        int count = 0;
        try (BufferedReader reader = this.source instanceof BufferedReader ? (BufferedReader)this.source : new LineNumberReader(this.source);){
            this.source = null;
            MetadataReader parser = new MetadataReader(this, this.getDisplayName(), this.listeners);
            parser.read(reader);
            this.metadata = parser.getMetadata();
            resources = new Band[parser.bands.size()];
            for (Map.Entry<BandName, Band> entry : parser.bands.entrySet()) {
                Band component = entry.getValue();
                if (component.filename == null) continue;
                component.identifier = factory.createLocalName(scope, (CharSequence)entry.getKey().name());
                resources[count++] = component;
            }
        }
        catch (IOException e) {
            throw new DataStoreException((Throwable)e);
        }
        catch (FactoryException e) {
            throw new DataStoreReferencingException((Throwable)e);
        }
        for (BandGroup c : bands = BandGroup.group(this.listeners, resources, count)) {
            c.identifier = factory.createLocalName(scope, (CharSequence)c.group.name());
        }
        this.components = bands;
        return bands;
    }

    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            this.loadMetadata();
        }
        return this.metadata;
    }

    public synchronized List<Aggregate> components() throws DataStoreException {
        BandGroup[] bands = this.components;
        if (bands == null) {
            bands = this.loadMetadata();
        }
        return UnmodifiableArrayList.wrap((Object[])bands);
    }

    public <T extends StoreEvent> void addListener(Class<T> eventType, StoreListener<? super T> listener) {
        if (listener == null || eventType == null || eventType.isAssignableFrom(WarningEvent.class)) {
            super.addListener(eventType, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws DataStoreException {
        this.listeners.close();
        try {
            CLOSER.closeAll(BandGroup.bands(this.components));
        }
        finally {
            LandsatStore landsatStore = this;
            synchronized (landsatStore) {
                this.metadata = null;
                this.components = null;
            }
        }
    }
}

