/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.NilInternationalString;
import org.apache.sis.xml.NilObject;
import org.apache.sis.xml.NilObjectHandler;
import org.apache.sis.xml.bind.FinalClassExtensions;
import org.opengis.util.InternationalString;

public final class NilReason
implements Serializable {
    private static final long serialVersionUID = 5553785821187789895L;
    public static final NilReason INAPPLICABLE = new NilReason("inapplicable");
    public static final NilReason MISSING = new NilReason("missing");
    public static final NilReason TEMPLATE = new NilReason("template");
    public static final NilReason UNKNOWN = new NilReason("unknown");
    public static final NilReason WITHHELD = new NilReason("withheld");
    private static final String other = "other";
    public static final NilReason OTHER = new NilReason("other");
    private static final NilReason[] PREDEFINED = new NilReason[]{INAPPLICABLE, MISSING, TEMPLATE, UNKNOWN, WITHHELD, OTHER};
    private static final WeakHashSet<NilReason> POOL = new WeakHashSet(NilReason.class);
    private static int lastOrdinal;
    private transient int ordinal;
    private final Object reason;
    private transient InvocationHandler handler;
    private transient Map<Class<?>, Object> nilObjects;

    private NilReason(Object reason) {
        this.reason = reason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NilReason[] values() {
        int count;
        NilReason[] reasons;
        int predefinedCount = PREDEFINED.length;
        WeakHashSet<NilReason> weakHashSet = POOL;
        synchronized (weakHashSet) {
            reasons = (NilReason[])POOL.toArray((Object[])new NilReason[predefinedCount + POOL.size()]);
        }
        for (count = reasons.length; count != 0 && reasons[count - 1] == null; --count) {
        }
        NilReason[] source = reasons;
        if ((count += predefinedCount) != reasons.length) {
            reasons = new NilReason[count];
        }
        System.arraycopy(source, 0, reasons, predefinedCount, count - predefinedCount);
        System.arraycopy(PREDEFINED, 0, reasons, 0, predefinedCount);
        return reasons;
    }

    public static NilReason valueOf(String reason) throws URISyntaxException {
        int i = (reason = reason.strip()).indexOf(58);
        if (i < 0) {
            for (NilReason candidate : PREDEFINED) {
                if (!reason.equalsIgnoreCase((String)candidate.reason)) continue;
                return candidate;
            }
        } else {
            int upper;
            int lower = CharSequences.skipLeadingWhitespaces((CharSequence)reason, (int)0, (int)i);
            if (reason.regionMatches(true, lower, other, 0, (upper = CharSequences.skipTrailingWhitespaces((CharSequence)reason, (int)lower, (int)i)) - lower)) {
                int length = reason.length();
                StringBuilder buffer = new StringBuilder(length).append(other);
                while (i < length) {
                    int c = reason.codePointAt(i);
                    if (!Character.isSpaceChar(c) && !Character.isISOControl(c)) {
                        buffer.appendCodePoint(c);
                    }
                    i += Character.charCount(c);
                }
                if (buffer.length() < other.length() + 2) {
                    return OTHER;
                }
                String result = buffer.toString();
                if (result.equals(reason)) {
                    result = reason;
                }
                return new NilReason(result).unique();
            }
        }
        return new NilReason(new URI(reason)).unique();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NilReason unique() {
        WeakHashSet<NilReason> weakHashSet = POOL;
        synchronized (weakHashSet) {
            NilReason instance = (NilReason)POOL.unique((Object)this);
            if (instance == this) {
                instance.ordinal = ++lastOrdinal;
                if (lastOrdinal < 0) {
                    lastOrdinal = Integer.MIN_VALUE;
                    instance.ordinal = Integer.MIN_VALUE;
                }
            }
            return instance;
        }
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.reason instanceof String) {
            for (NilReason candidate : PREDEFINED) {
                if (!this.reason.equals(candidate.reason)) continue;
                return candidate;
            }
        }
        return this.unique();
    }

    final int ordinal() {
        if (this.ordinal > 0) {
            return this.ordinal;
        }
        throw new ArithmeticException(Errors.format((short)10, (Object)32));
    }

    public String getOtherExplanation() {
        if (this.reason instanceof String) {
            String text = (String)this.reason;
            int s = text.indexOf(58);
            if (s >= 0) {
                return text.substring(s + 1);
            }
            if (text.equals(other)) {
                return "";
            }
        }
        return null;
    }

    public URI getURI() {
        return this.reason instanceof URI ? (URI)this.reason : null;
    }

    public String toString() {
        return this.reason.toString();
    }

    public int hashCode() {
        return this.reason.hashCode() ^ 0x767FD447;
    }

    public boolean equals(Object other) {
        if (other instanceof NilReason) {
            return this.reason.equals(((NilReason)other).reason);
        }
        return false;
    }

    public synchronized <T> T createNilObject(Class<T> type) {
        Object object;
        ArgumentChecks.ensureNonNull((String)"type", type);
        if (this.nilObjects == null) {
            this.nilObjects = new WeakValueHashMap(Class.class);
        }
        if ((object = this.nilObjects.get(type)) == null) {
            if (type.isInterface()) {
                if (NilObjectHandler.isIgnoredInterface(type)) {
                    throw new IllegalArgumentException(Errors.format((short)45, (Object)"type", type));
                }
                if (type == InternationalString.class) {
                    object = new NilInternationalString(this);
                } else {
                    if (this.handler == null) {
                        this.handler = new NilObjectHandler(this);
                    }
                    object = Proxy.newProxyInstance(NilReason.class.getClassLoader(), new Class[]{type, NilObject.class, LenientComparable.class}, this.handler);
                }
            } else {
                object = this.createNilInstance(type);
            }
            if (this.nilObjects.put(type, object) != null) {
                throw new AssertionError(type);
            }
        }
        return type.cast(object);
    }

    private Object createNilInstance(Class<?> type) {
        if (type == Double.class) {
            return (double)MathFunctions.toNanFloat((int)this.ordinal());
        }
        if (type == Float.class) {
            return Float.valueOf(MathFunctions.toNanFloat((int)this.ordinal()));
        }
        if (type != String.class) {
            throw new IllegalArgumentException(Errors.format((short)45, (Object)"type", type));
        }
        String object = new String("");
        FinalClassExtensions.associate(object, this);
        return object;
    }

    public static NilReason forObject(Object object) {
        if (object != null) {
            if (object instanceof NilObject) {
                return ((NilObject)object).getNilReason();
            }
            if (object instanceof Double) {
                Double value = (Double)object;
                if (value.isNaN()) {
                    return NilReason.forNumber(value);
                }
            } else if (object instanceof Float) {
                Float value = (Float)object;
                if (value.isNaN()) {
                    return NilReason.forNumber(value);
                }
            } else if (object instanceof String) {
                return (NilReason)FinalClassExtensions.property(object);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NilReason forNumber(Number value) {
        block7: {
            try {
                int ordinal = MathFunctions.toNanOrdinal((float)value.floatValue());
                if (ordinal < 1) break block7;
                if (ordinal <= PREDEFINED.length) {
                    return PREDEFINED[ordinal - 1];
                }
                WeakHashSet<NilReason> weakHashSet = POOL;
                synchronized (weakHashSet) {
                    for (NilReason reason : POOL) {
                        if (reason.ordinal != ordinal) continue;
                        return reason;
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        int i = 0;
        while (i < PREDEFINED.length) {
            NilReason.PREDEFINED[i].ordinal = ++i;
        }
        lastOrdinal = i;
    }
}

