/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.resources.Errors;

final class ProbeInputStream
extends FilterInputStream {
    ProbeInputStream(StorageConnector owner, InputStream input) throws IOException, DataStoreException {
        super(input);
        if (!input.markSupported()) {
            throw new DataStoreException(Resources.format((short)62, owner.getStorageName()));
        }
        input.mark(8192);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException(Errors.format((short)162, (Object)"reset"));
    }

    @Override
    public void close() throws IOException {
        InputStream input = this.in;
        this.in = null;
        if (input != null) {
            input.reset();
        }
    }
}

