/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;
import org.apache.sis.io.stream.Markable;
import org.apache.sis.io.stream.RewindableLineReader;
import org.apache.sis.measure.Range;
import org.apache.sis.metadata.simple.SimpleFormat;
import org.apache.sis.storage.CanNotProbeException;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.ForwardOnlyStorageException;
import org.apache.sis.storage.ProbeInputStream;
import org.apache.sis.storage.ProbeReader;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.base.URIDataStore;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Version;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.distribution.Format;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;

public abstract class DataStoreProvider {
    public static final String LOCATION = "location";
    public static final String CREATE = "create";

    protected DataStoreProvider() {
    }

    public abstract String getShortName();

    public Format getFormat() {
        return new SimpleFormat(this.getShortName());
    }

    public Range<Version> getSupportedVersions() {
        return null;
    }

    public abstract ParameterDescriptorGroup getOpenParameters();

    public abstract ProbeResult probeContent(StorageConnector var1) throws DataStoreException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <S> ProbeResult probeContent(StorageConnector connector, Class<S> type, Prober<? super S> prober) throws DataStoreException {
        boolean undetermined;
        ArgumentChecks.ensureNonNull((String)"prober", prober);
        Object object = connector.storage;
        synchronized (object) {
            ProbeResult result = this.tryProber(connector, type, prober);
            boolean bl = undetermined = result == ProbeResult.UNDETERMINED;
            if (result != null && !undetermined) {
                return result;
            }
            Prober<? super S> next = prober;
            while (next instanceof ProberList) {
                ProberList list = (ProberList)next;
                result = this.tryNextProber(connector, list);
                if (result != null && result != ProbeResult.UNDETERMINED) {
                    return result;
                }
                undetermined |= result == ProbeResult.UNDETERMINED;
                next = list.next;
            }
        }
        return undetermined ? ProbeResult.UNDETERMINED : ProbeResult.UNSUPPORTED_STORAGE;
    }

    private <N> ProbeResult tryNextProber(StorageConnector connector, ProberList<?, N> list) throws DataStoreException {
        return this.tryProber(connector, list.type, list.next);
    }

    private <S> ProbeResult tryProber(StorageConnector connector, Class<S> type, Prober<? super S> prober) throws DataStoreException {
        S input = connector.getStorageAs(type);
        if (input == null) {
            if (connector.probing != null) {
                return connector.probing.probe;
            }
            return null;
        }
        if (input == connector.storage && !StorageConnector.isSupportedType(type)) {
            throw new IllegalArgumentException(Errors.format((short)163, type));
        }
        ProbeResult result = null;
        try {
            if (input instanceof ByteBuffer) {
                ByteBuffer buffer = (ByteBuffer)input;
                result = prober.test(type.cast(buffer.asReadOnlyBuffer()));
            } else if (input instanceof Markable) {
                Markable stream = (Markable)input;
                long position = stream.getStreamPosition();
                stream.mark();
                result = prober.test(input);
                stream.reset(position);
            } else if (input instanceof ImageInputStream) {
                ImageInputStream stream = (ImageInputStream)input;
                long position = stream.getStreamPosition();
                result = prober.test(input);
                stream.seek(position);
            } else if (input instanceof InputStream) {
                ProbeInputStream stream = new ProbeInputStream(connector, (InputStream)input);
                result = prober.test(type.cast(stream));
                stream.close();
            } else if (input instanceof RewindableLineReader) {
                RewindableLineReader r = (RewindableLineReader)input;
                r.protectedMark();
                result = prober.test(input);
                r.protectedReset();
            } else if (input instanceof Reader) {
                ProbeReader stream = new ProbeReader(connector, (Reader)input);
                result = prober.test(type.cast(stream));
                stream.close();
            } else {
                result = prober.test(input);
            }
        }
        catch (DataStoreException e) {
            throw e;
        }
        catch (Exception e) {
            String message = Errors.format((short)12, (Object)connector.getStorageName());
            if (result != null) {
                throw new ForwardOnlyStorageException(message, e);
            }
            throw new CanNotProbeException(this, connector, (Throwable)e);
        }
        return result;
    }

    public abstract DataStore open(StorageConnector var1) throws DataStoreException;

    public DataStore open(ParameterValueGroup parameters) throws DataStoreException {
        ArgumentChecks.ensureNonNull((String)"parameter", (Object)parameters);
        return this.open(URIDataStore.Provider.connector(this, parameters));
    }

    public Logger getLogger() {
        return Logging.getLogger(this.getClass());
    }

    @FunctionalInterface
    protected static interface Prober<S> {
        public ProbeResult test(S var1) throws Exception;

        default public <A> Prober<S> orElse(Class<A> type, Prober<? super A> alternative) {
            return new ProberList(this, type, alternative);
        }
    }

    private static final class ProberList<S, N>
    implements Prober<S> {
        private final Prober<S> first;
        Prober<? super N> next;
        final Class<N> type;

        ProberList(Prober<S> first, Class<N> type, Prober<? super N> next) {
            this.first = first;
            this.type = type;
            this.next = next;
        }

        @Override
        public ProbeResult test(S input) throws Exception {
            return this.first.test(input);
        }

        @Override
        public <A> Prober<S> orElse(Class<A> type, Prober<? super A> prober) {
            this.next = this.next.orElse(type, prober);
            return this;
        }
    }
}

