/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.IntFunction;
import org.apache.sis.internal.geotiff.Compression;
import org.apache.sis.internal.geotiff.Predictor;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.math.Vector;
import org.apache.sis.storage.geotiff.GeoKeys;
import org.apache.sis.storage.geotiff.GeoKeysLoader;
import org.apache.sis.storage.geotiff.Reader;
import org.apache.sis.storage.geotiff.Tags;
import org.apache.sis.storage.geotiff.Type;
import org.apache.sis.storage.geotiff.XMLMetadata;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Vocabulary;

final class NativeMetadata
extends GeoKeysLoader {
    private static final TableColumn<Integer> CODE = new TableColumn(Integer.class, (CharSequence)Vocabulary.formatInternational((short)28));
    static final TableColumn<CharSequence> NAME = TableColumn.NAME;
    static final TableColumn<Object> VALUE = TableColumn.VALUE;
    private ChannelDataInput input;
    private boolean isClassic;
    private TreeTable.Node geoNode;
    private final Vocabulary vocabulary;

    NativeMetadata(Locale locale) {
        this.vocabulary = Vocabulary.getResources((Locale)locale);
    }

    final DefaultTreeTable read(Reader reader) throws IOException {
        this.input = reader.input;
        this.isClassic = reader.intSizeExpansion == 0;
        int n = 4 << reader.intSizeExpansion;
        DefaultTreeTable defaultTreeTable = new DefaultTreeTable(new TableColumn[]{CODE, NAME, VALUE});
        TreeTable.Node node = defaultTreeTable.getRoot();
        node.setValue(NAME, (Object)"TIFF");
        this.input.mark();
        try {
            long l;
            this.input.seek(Math.addExact(reader.origin, this.isClassic ? 4L : 8L));
            HashSet<Long> hashSet = new HashSet<Long>();
            int n2 = 0;
            while ((l = this.readInt(false)) != 0L) {
                if (!hashSet.add(l)) {
                    break;
                }
                TreeTable.Node node2 = node.newChild();
                node2.setValue(NAME, (Object)this.vocabulary.getString((short)261, (Object)n2));
                this.input.seek(Math.addExact(reader.origin, l));
                long l2 = this.readInt(true);
                while (--l2 >= 0L) {
                    boolean bl;
                    short s = (short)this.input.readUnsignedShort();
                    Type type = Type.valueOf(this.input.readShort());
                    long l3 = this.readInt(false);
                    long l4 = type != null ? Math.multiplyExact((long)type.size, l3) : 0L;
                    long l5 = Math.addExact(this.input.getStreamPosition(), (long)n);
                    switch (s) {
                        case 273: 
                        case 279: 
                        case 324: 
                        case 325: {
                            bl = false;
                            break;
                        }
                        default: {
                            boolean bl2 = bl = l4 != 0L;
                        }
                    }
                    if (bl) {
                        Object object;
                        if (l4 > (long)n) {
                            long l6 = this.readInt(false);
                            this.input.seek(Math.addExact(reader.origin, l6));
                        }
                        Object object2 = null;
                        XMLMetadata xMLMetadata = null;
                        block5 : switch (s) {
                            case -30801: {
                                this.writeGeoKeys();
                                this.keyDirectory = type.readVector(this.input, l3);
                                object2 = "GeoTIFF";
                                break;
                            }
                            case -30800: {
                                this.numericParameters = type.readVector(this.input, l3);
                                bl = false;
                                break;
                            }
                            case -30799: {
                                this.setAsciiParameters(type.readString(this.input, l3, reader.store.encoding));
                                bl = false;
                                break;
                            }
                            case -23424: 
                            case -14627: {
                                xMLMetadata = new XMLMetadata(reader, type, l3, s);
                                if (!xMLMetadata.isEmpty()) break;
                                object2 = type.readVector(this.input, l3);
                                break;
                            }
                            default: {
                                object2 = type.readObject(this.input, l3);
                                if (object2 instanceof Vector) {
                                    object = (Vector)object2;
                                    switch (object.size()) {
                                        case 0: {
                                            object2 = null;
                                            break;
                                        }
                                        case 1: {
                                            object2 = object.get(0);
                                        }
                                    }
                                }
                                switch (s) {
                                    case 259: {
                                        object2 = NativeMetadata.toString(object2, Compression::valueOf, Compression.UNKNOWN);
                                        break block5;
                                    }
                                    case 317: {
                                        object2 = NativeMetadata.toString(object2, Predictor::valueOf, Predictor.UNKNOWN);
                                    }
                                }
                            }
                        }
                        if (bl) {
                            Object object3;
                            object = Tags.name(s);
                            if (xMLMetadata != null) {
                                object3 = new XMLMetadata.Root(xMLMetadata, (DefaultTreeTable.Node)node2, (String)object);
                            } else {
                                object3 = node2.newChild();
                                object3.setValue(NAME, object);
                                object3.setValue(VALUE, object2);
                            }
                            object3.setValue(CODE, (Object)Short.toUnsignedInt(s));
                            if (s == -30801) {
                                this.geoNode = object3;
                            }
                        }
                    }
                    this.input.seek(l5);
                }
                ++n2;
            }
        }
        catch (ArithmeticException arithmeticException) {
            throw new IOException(arithmeticException);
        }
        finally {
            this.input.reset();
        }
        this.writeGeoKeys();
        return defaultTreeTable;
    }

    private long readInt(boolean bl) throws IOException {
        if (this.isClassic) {
            return bl ? (long)this.input.readUnsignedShort() : this.input.readUnsignedInt();
        }
        long l = this.input.readLong();
        if (l < 0L) {
            throw new ArithmeticException();
        }
        return l;
    }

    private static Object toString(Object object, IntFunction<Enum<?>> intFunction, Enum<?> enum_) {
        Enum<?> enum_2;
        if (object != null && Numbers.isInteger(object.getClass()) && (enum_2 = intFunction.apply(((Number)object).intValue())) != enum_) {
            return enum_2.name();
        }
        return object;
    }

    private void writeGeoKeys() {
        if (this.geoNode != null) {
            LinkedHashMap<Short, Object> linkedHashMap = new LinkedHashMap<Short, Object>(32);
            this.load(linkedHashMap);
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                TreeTable.Node node = this.geoNode.newChild();
                short s = (Short)entry.getKey();
                node.setValue(CODE, (Object)Short.toUnsignedInt(s));
                node.setValue(NAME, (Object)GeoKeys.name(s));
                node.setValue(VALUE, entry.getValue());
            }
            this.geoNode = null;
        }
    }
}

