/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.LogRecord;
import org.apache.sis.internal.geotiff.SchemaModifier;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.StoreUtilities;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.internal.util.ListOfUnknownSize;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreClosedException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.IllegalNameException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.event.WarningEvent;
import org.apache.sis.storage.geotiff.GeoTiffStoreProvider;
import org.apache.sis.storage.geotiff.NativeMetadata;
import org.apache.sis.storage.geotiff.Reader;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.iso.DefaultNameSpace;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;

public class GeoTiffStore
extends DataStore
implements Aggregate {
    final Charset encoding;
    private Reader reader;
    private final URI location;
    final Path path;
    private NameSpace namespace;
    private boolean isNamespaceSet;
    private Metadata metadata;
    private TreeTable nativeMetadata;
    private List<GridCoverageResource> components;
    final boolean hidden;
    final SchemaModifier customizer;

    public GeoTiffStore(GeoTiffStoreProvider geoTiffStoreProvider, StorageConnector storageConnector) throws DataStoreException {
        this(null, geoTiffStoreProvider, storageConnector, false);
    }

    public GeoTiffStore(DataStore dataStore, DataStoreProvider dataStoreProvider, StorageConnector storageConnector, boolean bl) throws DataStoreException {
        super(dataStore, dataStoreProvider, storageConnector, bl);
        this.hidden = bl;
        SchemaModifier schemaModifier = storageConnector.getOption(SchemaModifier.OPTION);
        this.customizer = schemaModifier != null ? schemaModifier : SchemaModifier.DEFAULT;
        Charset charset = (Charset)storageConnector.getOption(OptionKey.ENCODING);
        this.encoding = charset != null ? charset : StandardCharsets.US_ASCII;
        this.location = storageConnector.getStorageAs(URI.class);
        this.path = storageConnector.getStorageAs(Path.class);
        ChannelDataInput channelDataInput = storageConnector.commit(ChannelDataInput.class, "GeoTIFF");
        try {
            this.reader = new Reader(this, channelDataInput);
        }
        catch (IOException iOException) {
            throw new DataStoreException(iOException);
        }
        if (this.getClass() == GeoTiffStore.class) {
            this.listeners.useReadOnlyEvents();
        }
    }

    final NameSpace namespace() {
        if (!this.isNamespaceSet && this.reader != null) {
            NameFactory nameFactory = this.reader.nameFactory;
            GenericName genericName = null;
            if (this.location != null) {
                String string = IOUtilities.filenameWithoutExtension(this.reader.input.filename);
                genericName = nameFactory.createLocalName(null, (CharSequence)string);
            }
            if ((genericName = this.customizer.customize(-1, genericName)) != null) {
                this.namespace = nameFactory.createNameSpace(genericName, null);
            }
            this.isNamespaceSet = true;
        }
        return this.namespace;
    }

    final StoreListeners listeners() {
        return this.listeners;
    }

    @Override
    public Optional<ParameterValueGroup> getOpenParameters() {
        return Optional.ofNullable(URIDataStore.parameters(this.provider, this.location));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        NameSpace nameSpace;
        GeoTiffStore geoTiffStore = this;
        synchronized (geoTiffStore) {
            nameSpace = this.namespace();
        }
        return nameSpace != null ? Optional.of(nameSpace.name()) : Optional.empty();
    }

    final void setFormatInfo(MetadataBuilder metadataBuilder) {
        try {
            metadataBuilder.setPredefinedFormat("GeoTIFF");
        }
        catch (MetadataStoreException metadataStoreException) {
            metadataBuilder.addFormatName("GeoTIFF");
            this.listeners.warning((Exception)((Object)metadataStoreException));
        }
        metadataBuilder.addEncoding(this.encoding, MetadataBuilder.Scope.METADATA);
        metadataBuilder.addResourceScope(ScopeCode.valueOf((String)"COVERAGE"), null);
    }

    @Override
    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            GridCoverageResource gridCoverageResource;
            Reader reader = this.reader();
            MetadataBuilder metadataBuilder = new MetadataBuilder();
            this.setFormatInfo(metadataBuilder);
            int n = 0;
            try {
                while ((gridCoverageResource = reader.getImage(n++)) != null) {
                    metadataBuilder.addFromComponent(gridCoverageResource.getMetadata());
                }
            }
            catch (IOException iOException) {
                throw this.errorIO(iOException);
            }
            catch (ArithmeticException arithmeticException) {
                this.listeners.warning(arithmeticException);
            }
            this.getIdentifier().ifPresent(genericName -> metadataBuilder.addTitleOrIdentifier(genericName.toString(), MetadataBuilder.Scope.ALL));
            metadataBuilder.setISOStandards(true);
            gridCoverageResource = metadataBuilder.build();
            this.metadata = this.customizer.customize(-1, (DefaultMetadata)gridCoverageResource);
            if (this.metadata == null) {
                this.metadata = gridCoverageResource;
            }
            gridCoverageResource.transitionTo(ModifiableMetadata.State.FINAL);
        }
        return this.metadata;
    }

    @Override
    public synchronized Optional<TreeTable> getNativeMetadata() throws DataStoreException {
        if (this.nativeMetadata == null) {
            try {
                this.nativeMetadata = new NativeMetadata(this.getLocale()).read(this.reader());
            }
            catch (IOException iOException) {
                throw this.errorIO(iOException);
            }
        }
        return Optional.of(this.nativeMetadata);
    }

    final DataStoreException errorIO(IOException iOException) {
        return new DataStoreException(this.errors().getString((short)12, (Object)this.reader.input.filename), iOException);
    }

    private Reader reader() throws DataStoreException {
        assert (Thread.holdsLock(this));
        Reader reader = this.reader;
        if (reader == null) {
            throw new DataStoreClosedException(this.getLocale(), "GeoTIFF", StandardOpenOption.READ);
        }
        return reader;
    }

    public synchronized List<GridCoverageResource> components() throws DataStoreException {
        if (this.components == null) {
            this.components = new Components();
        }
        return this.components;
    }

    @Override
    public synchronized GridCoverageResource findResource(String string) throws DataStoreException {
        ArgumentChecks.ensureNonNull((String)"sequence", (Object)string);
        int n = this.parseImageIndex(string);
        if (n >= 0) {
            try {
                GridCoverageResource gridCoverageResource = this.reader().getImage(n - 1);
                if (gridCoverageResource != null) {
                    return gridCoverageResource;
                }
            }
            catch (IOException iOException) {
                throw this.errorIO(iOException);
            }
        }
        throw new IllegalNameException(StoreUtilities.resourceNotFound(this, string));
    }

    private int parseImageIndex(String string) throws IllegalNameException {
        NameSpace nameSpace = this.namespace();
        String string2 = DefaultNameSpace.getSeparator((NameSpace)nameSpace, (boolean)false);
        int n = string.lastIndexOf(string2);
        if (n >= 0) {
            if (nameSpace != null) {
                String string3 = nameSpace.name().toString();
                if (!string.substring(0, n).equals(string3)) {
                    throw new IllegalNameException(this.errors().getString((short)68, (Object)string3, (Object)string));
                }
            }
            string = string.substring(n + string2.length());
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalNameException(StoreUtilities.resourceNotFound(this, string), numberFormatException);
        }
    }

    @Override
    public <T extends StoreEvent> void addListener(Class<T> clazz, StoreListener<? super T> storeListener) {
        if (storeListener == null || clazz == null || clazz.isAssignableFrom(WarningEvent.class)) {
            super.addListener(clazz, storeListener);
        }
    }

    @Override
    public synchronized void close() throws DataStoreException {
        this.listeners.close();
        Reader reader = this.reader;
        this.reader = null;
        this.components = null;
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                throw new DataStoreException(iOException);
            }
        }
    }

    final Errors errors() {
        return Errors.getResources((Locale)this.getLocale());
    }

    final void warning(LogRecord logRecord) {
        logRecord.setSourceClassName(GeoTiffStore.class.getName());
        logRecord.setSourceMethodName("getMetadata");
        this.listeners.warning(logRecord);
    }

    private final class Components
    extends ListOfUnknownSize<GridCoverageResource> {
        private int size = -1;

        private Components() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int sizeIfKnown() {
            GeoTiffStore geoTiffStore = GeoTiffStore.this;
            synchronized (geoTiffStore) {
                return this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            GeoTiffStore geoTiffStore = GeoTiffStore.this;
            synchronized (geoTiffStore) {
                if (this.size < 0) {
                    this.size = super.size();
                }
                return this.size;
            }
        }

        protected boolean exists(int n) {
            return n >= 0 && this.getImageFileDirectory(n) != null;
        }

        public GridCoverageResource get(int n) {
            GridCoverageResource gridCoverageResource;
            if (n >= 0 && (gridCoverageResource = this.getImageFileDirectory(n)) != null) {
                return gridCoverageResource;
            }
            throw new IndexOutOfBoundsException(GeoTiffStore.this.errors().getString((short)71, (Object)n));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private GridCoverageResource getImageFileDirectory(int n) {
            try {
                GeoTiffStore geoTiffStore = GeoTiffStore.this;
                synchronized (geoTiffStore) {
                    return GeoTiffStore.this.reader().getImage(n);
                }
            }
            catch (IOException iOException) {
                throw new BackingStoreException((Throwable)GeoTiffStore.this.errorIO(iOException));
            }
            catch (DataStoreException dataStoreException) {
                throw new BackingStoreException((Throwable)dataStoreException);
            }
        }
    }
}

