/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.io.Closeable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.sis.internal.geotiff.Resources;
import org.apache.sis.storage.geotiff.GeoTiffStore;
import org.apache.sis.util.resources.Errors;

abstract class GeoTIFF
implements Closeable {
    private static final TimeZone TIMEZONE = null;
    private static final Locale LOCALE = Locale.US;
    static final short BIG_ENDIAN = 19789;
    static final short LITTLE_ENDIAN = 18761;
    static final short CLASSIC = 42;
    static final short BIG_TIFF = 43;
    final GeoTiffStore store;
    private transient DateFormat dateFormat;

    GeoTIFF(GeoTiffStore geoTiffStore) {
        this.store = geoTiffStore;
    }

    final Errors errors() {
        return Errors.getResources((Locale)this.store.getLocale());
    }

    final Resources resources() {
        return Resources.forLocale(this.store.getLocale());
    }

    final DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss", LOCALE);
            if (TIMEZONE != null) {
                this.dateFormat.setTimeZone(TIMEZONE);
            }
        }
        return this.dateFormat;
    }
}

