/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.awt.image.BandedSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.geotiff.Compression;
import org.apache.sis.internal.geotiff.Predictor;
import org.apache.sis.internal.storage.ResourceOnFileSystem;
import org.apache.sis.internal.storage.StoreResource;
import org.apache.sis.internal.storage.TiledGridResource;
import org.apache.sis.math.Vector;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.geotiff.CompressedSubset;
import org.apache.sis.storage.geotiff.DataSubset;
import org.apache.sis.storage.geotiff.Reader;
import org.apache.sis.storage.geotiff.Tags;
import org.opengis.util.GenericName;

abstract class DataCube
extends TiledGridResource
implements ResourceOnFileSystem,
StoreResource {
    final Reader reader;

    DataCube(Reader reader) {
        super(reader.store.listeners());
        this.reader = reader;
    }

    @Override
    public final DataStore getOriginator() {
        return this.reader.store;
    }

    @Override
    protected final Object getSynchronizationLock() {
        return this.reader.store;
    }

    final StoreListeners listeners() {
        return this.listeners;
    }

    final String filename() {
        return this.reader.input.filename;
    }

    @Override
    public abstract Optional<GenericName> getIdentifier();

    @Override
    public final Path[] getComponentFiles() {
        Path[] pathArray;
        Path path = this.reader.store.path;
        if (path != null) {
            Path[] pathArray2 = new Path[1];
            pathArray = pathArray2;
            pathArray2[0] = path;
        } else {
            pathArray = new Path[]{};
        }
        return pathArray;
    }

    abstract int getNumBands();

    abstract long getNumTiles();

    abstract Vector[] getTileArrayInfo();

    abstract boolean isBitOrderReversed();

    abstract Compression getCompression();

    abstract Predictor getPredictor();

    private boolean canReadDirect(TiledGridResource.Subset subset) throws DataStoreException {
        SampleModel sampleModel = this.getSampleModel();
        int n = sampleModel.getNumBands();
        if (n != 1 && !(sampleModel instanceof BandedSampleModel) && !subset.isXContiguous()) {
            return false;
        }
        int n2 = DataBuffer.getDataTypeSize(sampleModel.getDataType());
        do {
            if (sampleModel.getSampleSize(--n) == n2) continue;
            return false;
        } while (n != 0);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GridCoverage read(GridGeometry gridGeometry, int ... nArray) throws DataStoreException {
        GridCoverage gridCoverage;
        long l = System.nanoTime();
        try {
            Object object = this.getSynchronizationLock();
            synchronized (object) {
                TiledGridResource.Subset subset = new TiledGridResource.Subset(this, gridGeometry, nArray);
                Compression compression = this.getCompression();
                if (compression == null) {
                    throw new DataStoreContentException(this.reader.resources().getString((short)13, Tags.name((short)259)));
                }
                gridCoverage = compression == Compression.NONE && this.getPredictor() == Predictor.NONE && this.canReadDirect(subset) ? new DataSubset(this, subset) : new CompressedSubset(this, subset);
                gridCoverage = this.preload(gridCoverage);
            }
        }
        catch (RuntimeException runtimeException) {
            throw this.canNotRead(this.reader.input.filename, gridGeometry, runtimeException);
        }
        this.logReadOperation(this.reader.store.path, gridCoverage.getGridGeometry(), l);
        return gridCoverage;
    }
}

