/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.inflater;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.sis.image.DataType;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.storage.inflater.CompressionChannel;
import org.apache.sis.internal.storage.inflater.PredictorChannel;

abstract class HorizontalPredictor
extends PredictorChannel {
    private final int sampleSizeM1;
    protected final int pixelStride;
    private final int scanlineStride;
    private int column;
    private final int truncationMask;

    HorizontalPredictor(CompressionChannel compressionChannel, int n, int n2, int n3) {
        super(compressionChannel);
        this.sampleSizeM1 = n3 - 1;
        this.truncationMask = ~this.sampleSizeM1;
        this.pixelStride = n * n3;
        this.scanlineStride = Math.multiplyExact(n2, this.pixelStride);
    }

    static HorizontalPredictor create(CompressionChannel compressionChannel, DataType dataType, int n, int n2) {
        switch (dataType) {
            case USHORT: 
            case SHORT: {
                return new Shorts(compressionChannel, n, n2);
            }
            case BYTE: {
                return new Bytes(compressionChannel, n, n2);
            }
            case INT: {
                return new Integers(compressionChannel, n, n2);
            }
            case FLOAT: {
                return new Floats(compressionChannel, n, n2);
            }
            case DOUBLE: {
                return new Doubles(compressionChannel, n, n2);
            }
        }
        return null;
    }

    @Override
    public final void setInputRegion(long l, long l2) throws IOException {
        super.setInputRegion(l, l2);
        this.column = 0;
    }

    @Override
    protected final int apply(ByteBuffer byteBuffer, int n) {
        int n2;
        int n3;
        int n4 = byteBuffer.position();
        int n5 = n4 - this.sampleSizeM1;
        int n6 = n;
        if (this.column < this.pixelStride) {
            n6 += Math.min(this.pixelStride - this.column, n4 - n6 & this.truncationMask);
        }
        if ((this.column += (n6 = this.applyOnFirst(byteBuffer, n6, n3 = Math.min(Math.min(n + this.pixelStride, this.scanlineStride), n5), n6 - n)) - n) >= this.scanlineStride) {
            this.column = 0;
        }
        while (n6 < n5) {
            assert ((this.column & ~this.truncationMask) == 0) : this.column;
            if (this.column == 0) {
                this.column = Math.min(this.pixelStride, n4 - n6 & this.truncationMask);
                n6 += this.column;
            }
            n2 = n6;
            if ((this.column += (n6 = this.applyOnRow(byteBuffer, n6, Math.min(n6 + (this.scanlineStride - this.column), n5))) - n2) < this.scanlineStride) continue;
            this.column = 0;
        }
        n2 = n6 - this.pixelStride;
        int n7 = Math.max(n - n2, 0);
        assert ((n7 & ~this.truncationMask) == 0) : n7;
        this.saveLastPixel(byteBuffer, n7, n2 + n7);
        return n6;
    }

    abstract int applyOnFirst(ByteBuffer var1, int var2, int var3, int var4);

    abstract int applyOnRow(ByteBuffer var1, int var2, int var3);

    abstract void saveLastPixel(ByteBuffer var1, int var2, int var3);

    private static final class Shorts
    extends HorizontalPredictor {
        private final short[] savedValues;

        Shorts(CompressionChannel compressionChannel, int n, int n2) {
            super(compressionChannel, n, n2, 2);
            this.savedValues = new short[n];
        }

        @Override
        void saveLastPixel(ByteBuffer byteBuffer, int n, int n2) {
            assert (n % 2 == 0) : n;
            System.arraycopy(this.savedValues, this.savedValues.length - (n /= 2), this.savedValues, 0, n);
            while (n < this.savedValues.length) {
                this.savedValues[n++] = byteBuffer.getShort(n2);
                n2 += 2;
            }
        }

        @Override
        int applyOnFirst(ByteBuffer byteBuffer, int n, int n2, int n3) {
            assert (n3 % 2 == 0) : n3;
            n3 /= 2;
            while (n < n2) {
                byteBuffer.putShort(n, (short)(byteBuffer.getShort(n) + this.savedValues[n3++]));
                n += 2;
            }
            return n;
        }

        @Override
        int applyOnRow(ByteBuffer byteBuffer, int n, int n2) {
            while (n < n2) {
                byteBuffer.putShort(n, (short)(byteBuffer.getShort(n) + byteBuffer.getShort(n - this.pixelStride)));
                n += 2;
            }
            return n;
        }
    }

    private static final class Bytes
    extends HorizontalPredictor {
        private final byte[] savedValues;

        Bytes(CompressionChannel compressionChannel, int n, int n2) {
            super(compressionChannel, n, n2, 1);
            this.savedValues = new byte[n];
        }

        @Override
        void saveLastPixel(ByteBuffer byteBuffer, int n, int n2) {
            System.arraycopy(this.savedValues, this.savedValues.length - n, this.savedValues, 0, n);
            JDK9.get((ByteBuffer)byteBuffer, (int)n2, (byte[])this.savedValues, (int)n, (int)(this.savedValues.length - n));
        }

        @Override
        int applyOnFirst(ByteBuffer byteBuffer, int n, int n2, int n3) {
            while (n < n2) {
                byteBuffer.put(n, (byte)(byteBuffer.get(n) + this.savedValues[n3++]));
                ++n;
            }
            return n;
        }

        @Override
        int applyOnRow(ByteBuffer byteBuffer, int n, int n2) {
            while (n < n2) {
                byteBuffer.put(n, (byte)(byteBuffer.get(n) + byteBuffer.get(n - this.pixelStride)));
                ++n;
            }
            return n;
        }
    }

    private static final class Integers
    extends HorizontalPredictor {
        private final int[] savedValues;

        Integers(CompressionChannel compressionChannel, int n, int n2) {
            super(compressionChannel, n, n2, 4);
            this.savedValues = new int[n];
        }

        @Override
        void saveLastPixel(ByteBuffer byteBuffer, int n, int n2) {
            assert (n % 4 == 0) : n;
            System.arraycopy(this.savedValues, this.savedValues.length - (n /= 4), this.savedValues, 0, n);
            while (n < this.savedValues.length) {
                this.savedValues[n++] = byteBuffer.getInt(n2);
                n2 += 4;
            }
        }

        @Override
        int applyOnFirst(ByteBuffer byteBuffer, int n, int n2, int n3) {
            assert (n3 % 4 == 0) : n3;
            n3 /= 4;
            while (n < n2) {
                byteBuffer.putInt(n, byteBuffer.getInt(n) + this.savedValues[n3++]);
                n += 4;
            }
            return n;
        }

        @Override
        int applyOnRow(ByteBuffer byteBuffer, int n, int n2) {
            while (n < n2) {
                byteBuffer.putInt(n, byteBuffer.getInt(n) + byteBuffer.getInt(n - this.pixelStride));
                n += 4;
            }
            return n;
        }
    }

    private static final class Floats
    extends HorizontalPredictor {
        private final float[] savedValues;

        Floats(CompressionChannel compressionChannel, int n, int n2) {
            super(compressionChannel, n, n2, 4);
            this.savedValues = new float[n];
        }

        @Override
        void saveLastPixel(ByteBuffer byteBuffer, int n, int n2) {
            assert (n % 4 == 0) : n;
            System.arraycopy(this.savedValues, this.savedValues.length - (n /= 4), this.savedValues, 0, n);
            while (n < this.savedValues.length) {
                this.savedValues[n++] = byteBuffer.getFloat(n2);
                n2 += 4;
            }
        }

        @Override
        int applyOnFirst(ByteBuffer byteBuffer, int n, int n2, int n3) {
            assert (n3 % 4 == 0) : n3;
            n3 /= 4;
            while (n < n2) {
                byteBuffer.putFloat(n, byteBuffer.getFloat(n) + this.savedValues[n3++]);
                n += 4;
            }
            return n;
        }

        @Override
        int applyOnRow(ByteBuffer byteBuffer, int n, int n2) {
            while (n < n2) {
                byteBuffer.putFloat(n, byteBuffer.getFloat(n) + byteBuffer.getFloat(n - this.pixelStride));
                n += 4;
            }
            return n;
        }
    }

    private static final class Doubles
    extends HorizontalPredictor {
        private final double[] savedValues;

        Doubles(CompressionChannel compressionChannel, int n, int n2) {
            super(compressionChannel, n, n2, 8);
            this.savedValues = new double[n];
        }

        @Override
        void saveLastPixel(ByteBuffer byteBuffer, int n, int n2) {
            assert (n % 8 == 0) : n;
            System.arraycopy(this.savedValues, this.savedValues.length - (n /= 8), this.savedValues, 0, n);
            while (n < this.savedValues.length) {
                this.savedValues[n++] = byteBuffer.getDouble(n2);
                n2 += 8;
            }
        }

        @Override
        int applyOnFirst(ByteBuffer byteBuffer, int n, int n2, int n3) {
            assert (n3 % 8 == 0) : n3;
            n3 /= 8;
            while (n < n2) {
                byteBuffer.putDouble(n, byteBuffer.getDouble(n) + this.savedValues[n3++]);
                n += 8;
            }
            return n;
        }

        @Override
        int applyOnRow(ByteBuffer byteBuffer, int n, int n2) {
            while (n < n2) {
                byteBuffer.putDouble(n, byteBuffer.getDouble(n) + byteBuffer.getDouble(n - this.pixelStride));
                n += 8;
            }
            return n;
        }
    }
}

