/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.inflater;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.sis.internal.geotiff.Resources;
import org.apache.sis.internal.storage.inflater.PixelChannel;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.storage.event.StoreListeners;

abstract class CompressionChannel
extends PixelChannel {
    private static final int BUFFER_SIZE = 4096;
    protected final ChannelDataInput input;
    private long endPosition;
    protected final StoreListeners listeners;

    protected CompressionChannel(ChannelDataInput channelDataInput, StoreListeners storeListeners) {
        this.input = channelDataInput;
        this.listeners = storeListeners;
    }

    @Override
    public void setInputRegion(long l, long l2) throws IOException {
        this.endPosition = Math.addExact(l, l2);
        this.input.seek(l);
    }

    protected final boolean finished() {
        return this.input.getStreamPosition() >= this.endPosition;
    }

    final ChannelDataInput createDataInput(PixelChannel pixelChannel, int n) throws IOException {
        int n2;
        Object object;
        if (n > 4096) {
            object = MathFunctions.divisors((int)n);
            int n3 = Arrays.binarySearch(object, 4096);
            if (n3 < 0) {
                n3 ^= 0xFFFFFFFF;
            }
            n2 = object[n3];
        } else {
            n2 = Numerics.ceilDiv((int)4096, (int)n) * n;
        }
        object = (ByteBuffer)ByteBuffer.allocate(n2).order(this.input.buffer.order()).limit(0);
        return new ChannelDataInput(this.input.filename, pixelChannel, (ByteBuffer)object, true);
    }

    static void repeat(ByteBuffer byteBuffer, byte by, int n) {
        while (--n >= 0) {
            byteBuffer.put(by);
        }
    }

    @Override
    public final boolean isOpen() {
        return this.input.channel.isOpen();
    }

    @Override
    public void close() {
    }

    final Resources resources() {
        return Resources.forLocale(this.listeners.getLocale());
    }
}

