/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.ImagingOpException;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.lang.ref.Reference;
import java.nio.DoubleBuffer;
import java.util.Objects;
import java.util.logging.Logger;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.geometry.Shapes2D;
import org.apache.sis.image.ComputedImage;
import org.apache.sis.image.Interpolation;
import org.apache.sis.image.MaskImage;
import org.apache.sis.image.PixelIterator;
import org.apache.sis.image.PlanarImage;
import org.apache.sis.image.PositionalConsistencyImage;
import org.apache.sis.image.ResamplingGrid;
import org.apache.sis.image.TransferType;
import org.apache.sis.internal.coverage.j2d.FillValues;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.measure.Quantities;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public class ResampledImage
extends ComputedImage {
    public static final String POSITIONAL_CONSISTENCY_KEY = "org.apache.sis.PositionalConsistency";
    static final int BIDIMENSIONAL = 2;
    private final int minX;
    private final int minY;
    private final int width;
    private final int height;
    private final int minTileX;
    private final int minTileY;
    protected final MathTransform toSource;
    private final MathTransform toSourceSupport;
    protected final Interpolation interpolation;
    private final Object fillValues;
    private final Quantity<Length> linearAccuracy;
    private Reference<ComputedImage> positionalConsistency;
    private Reference<ComputedImage> mask;

    protected ResampledImage(RenderedImage renderedImage, SampleModel sampleModel, Point point, Rectangle rectangle, MathTransform mathTransform, Interpolation interpolation, Number[] numberArray, Quantity<?>[] quantityArray) {
        super(sampleModel, renderedImage);
        if (renderedImage.getWidth() <= 0 || renderedImage.getHeight() <= 0) {
            throw new IllegalArgumentException(Resources.format((short)19));
        }
        ArgumentChecks.ensureNonNull("interpolation", interpolation);
        this.width = rectangle.width;
        ArgumentChecks.ensureStrictlyPositive("width", this.width);
        this.height = rectangle.height;
        ArgumentChecks.ensureStrictlyPositive("height", this.height);
        this.minX = rectangle.x;
        this.minY = rectangle.y;
        if (point != null) {
            this.minTileX = point.x;
            this.minTileY = point.y;
        } else {
            this.minTileX = 0;
            this.minTileY = 0;
        }
        this.toSource = mathTransform;
        int n = mathTransform.getSourceDimensions();
        if (n != 2 || (n = mathTransform.getTargetDimensions()) < 2) {
            throw new IllegalArgumentException(Errors.format((short)81, "toSource", 2, n));
        }
        interpolation = interpolation.toCompatible(renderedImage);
        Dimension dimension = interpolation.getSupportSize();
        if (dimension.width > renderedImage.getWidth() || dimension.height > renderedImage.getHeight()) {
            interpolation = Interpolation.NEAREST;
            dimension = interpolation.getSupportSize();
        }
        this.interpolation = interpolation;
        double[] dArray = new double[n];
        dArray[0] = ResampledImage.interpolationSupportOffset(dimension.width);
        dArray[1] = ResampledImage.interpolationSupportOffset(dimension.height);
        MathTransform mathTransform2 = MathTransforms.concatenate((MathTransform)mathTransform, (MathTransform)MathTransforms.translation((double[])dArray));
        Boolean bl = null;
        Quantity quantity = null;
        if (quantityArray != null) {
            for (Quantity<?> quantity2 : quantityArray) {
                if (quantity2 == null) continue;
                Unit unit = quantity2.getUnit();
                if (Units.PIXEL.equals((Object)unit)) {
                    boolean bl2;
                    boolean bl3 = bl2 = Math.abs(quantity2.getValue().doubleValue()) >= 0.125;
                    if (bl == null) {
                        bl = bl2;
                        continue;
                    }
                    bl = bl & bl2;
                    continue;
                }
                if (!Units.isLinear(unit)) continue;
                quantity = Quantities.max(quantity, quantity2.asType(Length.class));
            }
        }
        if (bl != null && bl.booleanValue()) {
            try {
                mathTransform2 = ResamplingGrid.getOrCreate(MathTransforms.bidimensional((MathTransform)mathTransform2), rectangle);
            }
            catch (ImagingOpException | TransformException throwable) {
                ResampledImage.recoverableException("<init>", (Exception)throwable);
            }
        }
        this.toSourceSupport = mathTransform2;
        this.linearAccuracy = quantity;
        this.fillValues = new FillValues((SampleModel)sampleModel, (Number[])numberArray, (boolean)false).asPrimitiveArray;
    }

    static double interpolationSupportOffset(int n) {
        if (n <= 1) {
            return 0.5;
        }
        return -((n - 1) / 2);
    }

    private static double interpolationLimit(double d, int n) {
        d += (double)n;
        if (n > 1) {
            d -= 0.5;
        }
        return d;
    }

    private int getPositionalAccuracyCount() {
        int n = 0;
        if (this.linearAccuracy != null) {
            ++n;
        }
        if (this.toSourceSupport instanceof ResamplingGrid) {
            ++n;
        }
        return n;
    }

    private Quantity<?>[] getPositionalAccuracy() {
        Quantity[] quantityArray = new Quantity[this.getPositionalAccuracyCount()];
        int n = 0;
        if (this.linearAccuracy != null) {
            quantityArray[n++] = this.linearAccuracy;
        }
        if (this.toSourceSupport instanceof ResamplingGrid) {
            quantityArray[n++] = Quantities.create(0.125, Units.PIXEL);
        }
        return quantityArray;
    }

    private synchronized RenderedImage getPositionalConsistency() throws TransformException {
        ComputedImage computedImage;
        ComputedImage computedImage2 = computedImage = this.positionalConsistency != null ? this.positionalConsistency.get() : null;
        if (computedImage == null) {
            this.positionalConsistency = null;
            Dimension dimension = this.interpolation.getSupportSize();
            double[] dArray = new double[this.toSourceSupport.getSourceDimensions()];
            dArray[0] = -ResampledImage.interpolationSupportOffset(dimension.width);
            dArray[1] = -ResampledImage.interpolationSupportOffset(dimension.height);
            MathTransform mathTransform = MathTransforms.concatenate((MathTransform)this.toSourceSupport, (MathTransform)MathTransforms.translation((double[])dArray));
            computedImage = new PositionalConsistencyImage(this, mathTransform);
            this.positionalConsistency = computedImage.reference();
        }
        return computedImage;
    }

    private synchronized RenderedImage getMask() {
        ComputedImage computedImage;
        ComputedImage computedImage2 = computedImage = this.mask != null ? this.mask.get() : null;
        if (computedImage == null) {
            this.mask = null;
            computedImage = new MaskImage(this);
            this.mask = computedImage.reference();
        }
        return computedImage;
    }

    boolean hasNoMask() {
        return this.fillValues instanceof int[];
    }

    @Override
    public String verify() {
        if (this.toSource instanceof MathTransform2D) {
            try {
                Rectangle rectangle = this.getBounds();
                Rectangle2D rectangle2D = Shapes2D.transform((MathTransform2D)((MathTransform2D)this.toSource), (Rectangle2D)rectangle, (Rectangle2D)rectangle);
                if (!ImageUtilities.getBounds(this.getSource()).intersects(rectangle2D)) {
                    return "toSource";
                }
            }
            catch (TransformException transformException) {
                ResampledImage.recoverableException("verify", (Exception)((Object)transformException));
                return "toSource";
            }
        }
        return super.verify();
    }

    private static void recoverableException(String string, Exception exception) {
        Logging.recoverableException(Logger.getLogger("org.apache.sis.raster"), ResampledImage.class, string, exception);
    }

    @Override
    public ColorModel getColorModel() {
        RenderedImage renderedImage = this.getDestination();
        if (renderedImage == null) {
            renderedImage = this.getSource();
        }
        return renderedImage.getColorModel();
    }

    @Override
    public Object getProperty(String string) {
        switch (string) {
            case "org.apache.sis.SampleResolution": {
                return this.getSource().getProperty(string);
            }
            case "org.apache.sis.PositionalAccuracy": {
                return this.getPositionalAccuracy();
            }
            case "org.apache.sis.PositionalConsistency": {
                try {
                    return this.getPositionalConsistency();
                }
                catch (IllegalArgumentException | TransformException throwable) {
                    throw (ImagingOpException)new ImagingOpException(throwable.getMessage()).initCause(throwable);
                }
            }
            case "org.apache.sis.Mask": {
                if (this.hasNoMask()) break;
                return this.getMask();
            }
        }
        return super.getProperty(string);
    }

    @Override
    public String[] getPropertyNames() {
        Object[] objectArray = this.getSource().getPropertyNames();
        String[] stringArray = new String[]{"org.apache.sis.SampleResolution", "org.apache.sis.PositionalAccuracy", POSITIONAL_CONSISTENCY_KEY, "org.apache.sis.Mask"};
        int n = 0;
        for (String string : stringArray) {
            if (string != POSITIONAL_CONSISTENCY_KEY && (string == "org.apache.sis.PositionalAccuracy" ? this.getPositionalAccuracyCount() == 0 : (string == "org.apache.sis.Mask" ? this.hasNoMask() : !ArraysExt.contains(objectArray, string)))) continue;
            stringArray[n++] = string;
        }
        return ArraysExt.resize(stringArray, n);
    }

    @Override
    public final int getMinTileX() {
        return this.minTileX;
    }

    @Override
    public final int getMinTileY() {
        return this.minTileY;
    }

    @Override
    public final int getMinX() {
        return this.minX;
    }

    @Override
    public final int getMinY() {
        return this.minY;
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    protected Raster computeTile(int n, int n2, WritableRaster writableRaster) throws TransformException {
        int n3;
        long[] lArray;
        long[] lArray2;
        double[] dArray;
        int[] nArray;
        boolean bl;
        int[] nArray2;
        double[] dArray2;
        boolean bl2;
        boolean bl3;
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        PixelIterator pixelIterator;
        double[] dArray3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        block30: {
            block29: {
                if (writableRaster == null) {
                    writableRaster = this.createTile(n, n2);
                }
                n10 = writableRaster.getNumBands();
                n9 = writableRaster.getWidth();
                n8 = writableRaster.getMinX();
                n7 = writableRaster.getMinY();
                n6 = Math.addExact(n8, n9);
                n5 = Math.addExact(n7, writableRaster.getHeight());
                n4 = this.toSourceSupport.getTargetDimensions();
                dArray3 = new double[n9 * Math.max(2, n4)];
                Dimension dimension = this.interpolation.getSupportSize();
                pixelIterator = new PixelIterator.Builder().setWindowSize(dimension).create(this.getSource());
                Rectangle rectangle = pixelIterator.getDomain();
                d8 = rectangle.getMinX();
                d7 = rectangle.getMinY();
                d6 = rectangle.getMaxX() - 1.0;
                d5 = rectangle.getMaxY() - 1.0;
                d4 = ResampledImage.interpolationLimit(d6, dimension.width);
                d3 = ResampledImage.interpolationLimit(d5, dimension.height);
                d2 = ResampledImage.interpolationSupportOffset(dimension.width) - 0.5;
                d = ResampledImage.interpolationSupportOffset(dimension.height) - 0.5;
                bl3 = this.getDestination() == null;
                bl2 = bl3 && Interpolation.NEAREST.equals(this.interpolation) && ImageUtilities.isLosslessConversion(this.sampleModel, writableRaster.getSampleModel());
                dArray2 = null;
                nArray2 = null;
                bl = this.fillValues instanceof int[];
                if (!bl) break block29;
                int[] nArray3 = nArray = new int[n9 * n10];
                if (bl2) {
                    dArray = null;
                    lArray2 = null;
                    lArray = null;
                    break block30;
                } else {
                    dArray = new double[n10];
                    lArray2 = new long[n10];
                    lArray = new long[n10];
                    SampleModel sampleModel = writableRaster.getSampleModel();
                    for (n3 = 0; n3 < n10; ++n3) {
                        lArray[n3] = Numerics.bitmask(sampleModel.getSampleSize(n3)) - 1L;
                    }
                    if (!ImageUtilities.isUnsignedType(sampleModel)) {
                        for (n3 = 0; n3 < n10; ++n3) {
                            int n11 = n3;
                            long l = lArray[n11] >>> 1;
                            lArray[n11] = l;
                            lArray2[n3] = l ^ 0xFFFFFFFFFFFFFFFFL;
                        }
                    }
                }
                break block30;
            }
            nArray = null;
            double[] dArray4 = dArray = new double[n9 * n10];
            lArray2 = null;
            lArray = null;
        }
        int n12 = Integer.MAX_VALUE;
        n3 = Integer.MAX_VALUE;
        PixelIterator.Window<DoubleBuffer> window = pixelIterator.createWindow(TransferType.DOUBLE);
        int n13 = n7;
        while (n13 < n5) {
            void var35_31;
            int n14;
            int n15;
            int n16;
            int n17 = 0;
            for (n16 = n8; n16 < n6; ++n16) {
                dArray3[n17++] = n16;
                dArray3[n17++] = n13;
            }
            this.toSourceSupport.transform(dArray3, 0, dArray3, 0, n9);
            n17 = n8;
            if (bl2) {
                n16 = 0;
                n15 = 0;
                for (n14 = n8; n14 < n6; ++n14, n16 += n4, n15 += n10) {
                    long l;
                    long l2 = (long)Math.floor(dArray3[n16]);
                    if (l2 >= (long)pixelIterator.lowerX && l2 < (long)pixelIterator.upperX && (l = (long)Math.floor(dArray3[n16 + 1])) >= (long)pixelIterator.lowerY && l < (long)pixelIterator.upperY) {
                        boolean bl4 = n12 != (n12 = (int)l2);
                        int n18 = n3;
                        n3 = (int)l;
                        if (bl4 | n18 != n3) {
                            pixelIterator.moveTo(n12, n3);
                        }
                        if (bl) {
                            nArray2 = pixelIterator.getPixel(nArray2);
                            System.arraycopy(nArray2, 0, nArray, n15, n10);
                            continue;
                        }
                        dArray2 = pixelIterator.getPixel(dArray2);
                        System.arraycopy(dArray2, 0, dArray, n15, n10);
                        continue;
                    }
                    System.arraycopy(this.fillValues, 0, var35_31, n15, n10);
                }
            } else {
                n16 = 0;
                n15 = 0;
                for (n14 = n8; n14 < n6; ++n14, n16 += n4) {
                    double d9 = dArray3[n16];
                    if (d9 <= d4) {
                        double d10;
                        double d11 = d9;
                        double d12 = d11 - (d9 = Math.max(d8, Math.min(d6, Math.floor(d9))));
                        if (d12 >= d2 && (d10 = dArray3[n16 + 1]) <= d3) {
                            double d13 = d10;
                            double d14 = d13 - (d10 = Math.max(d7, Math.min(d5, Math.floor(d10))));
                            if (d14 >= d) {
                                boolean bl5 = n12 != (n12 = (int)d9);
                                int n19 = n3;
                                n3 = (int)d10;
                                if (bl5 | n19 != n3) {
                                    pixelIterator.moveTo(n12, n3);
                                    window.update();
                                }
                                this.interpolation.interpolate((DoubleBuffer)window.values, n10, d12, d14, dArray, bl ? 0 : n15);
                                if (bl) {
                                    for (int i = 0; i < n10; ++i) {
                                        nArray[n15 + i] = (int)Math.max(lArray2[i], Math.min(lArray[i], Math.round(dArray[i])));
                                    }
                                }
                                n15 += n10;
                                continue;
                            }
                        }
                    }
                    if (bl3) {
                        System.arraycopy(this.fillValues, 0, var35_31, n15, n10);
                        n15 += n10;
                        continue;
                    }
                    if (n15 != 0) {
                        int n20 = n15 / n10;
                        if (bl) {
                            writableRaster.setPixels(n17, n13, n20, 1, nArray);
                        } else {
                            writableRaster.setPixels(n17, n13, n20, 1, dArray);
                        }
                        n17 += n20;
                        n15 = 0;
                    }
                    ++n17;
                }
            }
            if ((n16 = n9 - (n17 - n8)) != 0) {
                if (bl) {
                    writableRaster.setPixels(n17, n13, n16, 1, nArray);
                } else {
                    writableRaster.setPixels(n17, n13, n16, 1, dArray);
                }
            }
            ++n13;
        }
        return writableRaster;
    }

    @Override
    protected Disposable prefetch(Rectangle rectangle) {
        RenderedImage renderedImage = this.getSource();
        if (renderedImage instanceof PlanarImage) {
            try {
                Dimension dimension = this.interpolation.getSupportSize();
                Rectangle rectangle2 = ImageUtilities.tilesToPixels(this, rectangle);
                Rectangle2D.Double double_ = new Rectangle2D.Double((double)rectangle2.x - 0.5 * (double)dimension.width, (double)rectangle2.y - 0.5 * (double)dimension.height, (double)rectangle2.width + (double)dimension.width, (double)rectangle2.height + (double)dimension.height);
                rectangle2 = (Rectangle)Shapes2D.transform((MathTransform2D)MathTransforms.bidimensional((MathTransform)this.toSource), (Rectangle2D)double_, (Rectangle2D)rectangle2);
                ImageUtilities.clipBounds(renderedImage, rectangle2);
                return ((PlanarImage)renderedImage).prefetch(ImageUtilities.pixelsToTiles(renderedImage, rectangle2));
            }
            catch (TransformException transformException) {
                ResampledImage.recoverableException("prefetch", (Exception)((Object)transformException));
            }
        }
        return super.prefetch(rectangle);
    }

    public boolean equals(Object object) {
        if (this.equalsBase(object)) {
            ResampledImage resampledImage = (ResampledImage)object;
            return this.minX == resampledImage.minX && this.minY == resampledImage.minY && this.width == resampledImage.width && this.height == resampledImage.height && this.minTileX == resampledImage.minTileX && this.minTileY == resampledImage.minTileY && this.interpolation.equals(resampledImage.interpolation) && Objects.deepEquals(this.fillValues, resampledImage.fillValues) && this.toSource.equals((Object)resampledImage.toSource);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCodeBase() + this.minX + 31 * (this.minY + 31 * (this.width + 31 * this.height)) + this.interpolation.hashCode() + this.toSource.hashCode();
    }
}

