/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Locale;
import org.apache.sis.coverage.grid.CoordinateOperationFinder;
import org.apache.sis.coverage.grid.DimensionReducer;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.GridClippingMode;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.coverage.grid.IllegalGridGeometryException;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.WraparoundAdjustment;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class GridDerivation {
    protected final GridGeometry base;
    private GridRoundingMode rounding;
    private GridClippingMode clipping;
    private int[] margin;
    private int[] chunkSize;
    private int[] maximumSubsampling;
    private boolean isBaseExtentExpanded;
    private GridExtent baseExtent;
    private GridExtent scaledExtent;
    private LinearTransform toBase;
    private int[] modifiedDimensions;
    private String subGridSetter;
    private GeneralEnvelope intersection;

    protected GridDerivation(GridGeometry gridGeometry) {
        ArgumentChecks.ensureNonNull("base", gridGeometry);
        this.base = gridGeometry;
        this.baseExtent = gridGeometry.extent;
        this.rounding = GridRoundingMode.NEAREST;
        this.clipping = GridClippingMode.STRICT;
    }

    private void ensureSubgridNotSet() {
        if (this.subGridSetter != null) {
            throw new IllegalStateException(Resources.format((short)11, this.subGridSetter));
        }
    }

    public GridDerivation rounding(GridRoundingMode gridRoundingMode) {
        ArgumentChecks.ensureNonNull("mode", (Object)gridRoundingMode);
        this.ensureSubgridNotSet();
        this.rounding = gridRoundingMode;
        return this;
    }

    public GridDerivation clipping(GridClippingMode gridClippingMode) {
        ArgumentChecks.ensureNonNull("mode", (Object)gridClippingMode);
        this.ensureSubgridNotSet();
        this.clipping = gridClippingMode;
        return this;
    }

    public GridDerivation margin(int ... nArray) {
        this.ensureSubgridNotSet();
        this.margin = GridDerivation.validateCellCounts("cellCounts", nArray, 0);
        return this;
    }

    public GridDerivation chunkSize(int ... nArray) {
        this.ensureSubgridNotSet();
        this.chunkSize = GridDerivation.validateCellCounts("cellCounts", nArray, 1);
        return this;
    }

    public GridDerivation maximumSubsampling(int ... nArray) {
        this.ensureSubgridNotSet();
        this.maximumSubsampling = GridDerivation.validateCellCounts("subsampling", nArray, Integer.MAX_VALUE);
        return this;
    }

    private static int[] validateCellCounts(String string, int[] nArray, int n) {
        ArgumentChecks.ensureNonNull(string, nArray);
        int[] nArray2 = null;
        int n2 = nArray.length;
        while (--n2 >= 0) {
            int n3 = nArray[n2];
            if (n3 == n) continue;
            if (n == 0) {
                ArgumentChecks.ensurePositive(string, n3);
            } else {
                ArgumentChecks.ensureStrictlyPositive(string, n3);
            }
            if (nArray2 == null) {
                nArray2 = new int[n2 + 1];
                Arrays.fill(nArray2, n);
            }
            nArray2[n2] = n3;
        }
        return nArray2;
    }

    public GridDerivation subgrid(GridGeometry gridGeometry) {
        Object object;
        double[] dArray;
        this.ensureSubgridNotSet();
        ArgumentChecks.ensureNonNull("areaOfInterest", gridGeometry);
        if (gridGeometry.isEnvelopeOnly()) {
            return this.subgrid((Envelope)gridGeometry.envelope, (double[])null);
        }
        if (gridGeometry.isExtentOnly()) {
            if (this.baseExtent != null) {
                this.baseExtent = this.baseExtent.intersect(gridGeometry.extent);
                this.subGridSetter = "subgrid";
            }
            dArray = gridGeometry.resolution;
        } else {
            if (this.base.equals(gridGeometry)) {
                return this;
            }
            GridExtent gridExtent = gridGeometry.extent;
            CoordinateOperationFinder coordinateOperationFinder = new CoordinateOperationFinder(gridGeometry, this.base);
            coordinateOperationFinder.verifyPresenceOfCRS(false);
            try {
                MathTransform mathTransform = gridExtent != null ? coordinateOperationFinder.gridToGrid() : null;
                coordinateOperationFinder.setAnchor(PixelInCell.CELL_CENTER);
                coordinateOperationFinder.nowraparound();
                object = coordinateOperationFinder.gridToGrid();
                if (gridExtent != null) {
                    GeneralEnvelope[] generalEnvelopeArray = mathTransform != null ? gridExtent.toEnvelopes(mathTransform, (MathTransform)object, null) : new GeneralEnvelope[]{gridExtent.toEnvelope()};
                    this.setBaseExtentClipped(generalEnvelopeArray);
                    if (this.baseExtent != this.base.extent && this.baseExtent.equals(gridExtent)) {
                        this.baseExtent = gridExtent;
                    }
                }
                this.subGridSetter = "subgrid";
            }
            catch (TransformException | FactoryException throwable) {
                throw new IllegalGridGeometryException(throwable, "areaOfInterest");
            }
            dArray = GridGeometry.resolution((MathTransform)object, gridExtent, PixelInCell.CELL_CENTER);
        }
        if (dArray == null) {
            return this;
        }
        object = new int[dArray.length];
        for (int i = 0; i < ((int[])object).length; ++i) {
            object[i] = this.roundSubsampling(dArray[i], i);
        }
        return this.subsample((int)object);
    }

    public GridDerivation subgrid(Envelope envelope, double ... dArray) {
        this.ensureSubgridNotSet();
        boolean bl = this.base.isEnvelopeOnly() && (dArray == null || dArray.length == 0);
        MathTransform mathTransform = bl ? MathTransforms.identity((int)this.base.envelope.getDimension()) : this.base.requireGridToCRS(false);
        this.subGridSetter = "subgrid";
        try {
            CoordinateReferenceSystem coordinateReferenceSystem;
            MathTransform mathTransform2 = null;
            if (envelope != null && (coordinateReferenceSystem = envelope.getCoordinateReferenceSystem()) != null) {
                envelope = new DimensionReducer(this.base, coordinateReferenceSystem).apply(envelope);
                mathTransform2 = this.findBaseToAOI(envelope.getCoordinateReferenceSystem());
                mathTransform = MathTransforms.concatenate((MathTransform)mathTransform, (MathTransform)mathTransform2);
            }
            if (bl) {
                if (envelope != null) {
                    this.intersection = new GeneralEnvelope((Envelope)this.base.envelope);
                    if (mathTransform2 != null && !mathTransform2.isIdentity()) {
                        envelope = Envelopes.transform((MathTransform)mathTransform2.inverse(), (Envelope)envelope);
                    }
                    this.intersection.intersect(envelope);
                }
                return this;
            }
            int n = mathTransform.getTargetDimensions();
            ArgumentChecks.ensureDimensionMatches("areaOfInterest", n, envelope);
            mathTransform = this.dropUnusedDimensions(mathTransform, n);
            n = this.baseExtent.getDimension();
            GeneralEnvelope generalEnvelope = null;
            if (envelope != null) {
                generalEnvelope = this.wraparound(mathTransform2, mathTransform).shift(envelope);
                this.setBaseExtentClipped(generalEnvelope);
            }
            if (generalEnvelope == null || generalEnvelope.getDimension() != n) {
                generalEnvelope = new GeneralEnvelope(n);
            }
            GridExtent gridExtent = this.getBaseExtentExpanded(true);
            for (int i = 0; i < n; ++i) {
                long l = gridExtent.getHigh(i);
                if (l != Long.MAX_VALUE) {
                    ++l;
                }
                generalEnvelope.setRange(i, (double)gridExtent.getLow(i), (double)l);
            }
            if (dArray != null && dArray.length != 0) {
                int n2;
                double d;
                int n3;
                dArray = ArraysExt.resize(dArray, mathTransform.getTargetDimensions());
                Matrix matrix = mathTransform.derivative((DirectPosition)new DirectPositionView.Double(this.getPointOfInterest()));
                double[] dArray2 = Matrices.inverse((Matrix)matrix).multiply(dArray);
                int[] nArray = this.modifiedDimensions;
                boolean bl2 = false;
                for (n3 = 0; n3 < dArray2.length; ++n3) {
                    d = Math.abs(dArray2[n3]);
                    if (d > 1.0) {
                        bl2 = true;
                        int n4 = n2 = nArray != null ? nArray[n3] : n3;
                        if (this.chunkSize != null && n2 < this.chunkSize.length && this.chunkSize[n2] != 1) {
                            d = this.roundSubsampling(d, n2);
                        } else {
                            double d2;
                            int n5 = Math.max(0, Math.getExponent(generalEnvelope.getSpan(n2))) + 1;
                            d = Math.scalb(Math.rint(Math.scalb(d, n5)), -n5);
                            if (this.maximumSubsampling != null && n2 < this.maximumSubsampling.length && d > (d2 = (double)this.maximumSubsampling[n2])) {
                                d = d2;
                            }
                        }
                        generalEnvelope.setRange(n2, generalEnvelope.getLower(n2) / d, generalEnvelope.getUpper(n2) / d);
                    }
                    dArray2[n3] = d;
                }
                if (bl2) {
                    this.scaledExtent = new GridExtent((AbstractEnvelope)generalEnvelope, this.rounding, this.clipping, null, null, null, nArray);
                    if (gridExtent.equals(this.scaledExtent)) {
                        this.scaledExtent = gridExtent;
                    }
                    matrix = Matrices.createIdentity((int)(n + 1));
                    for (n3 = 0; n3 < dArray2.length; ++n3) {
                        d = dArray2[n3];
                        if (!(d > 1.0)) continue;
                        n2 = nArray != null ? nArray[n3] : n3;
                        matrix.setElement(n2, n2, d);
                        matrix.setElement(n2, n, (double)gridExtent.getLow(n2) - (double)this.scaledExtent.getLow(n2) * d);
                    }
                    this.toBase = MathTransforms.linear((Matrix)matrix);
                }
            }
        }
        catch (TransformException | FactoryException throwable) {
            throw new IllegalGridGeometryException(throwable, "areaOfInterest");
        }
        this.modifiedDimensions = null;
        return this;
    }

    private MathTransform findBaseToAOI(CoordinateReferenceSystem coordinateReferenceSystem) throws FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem2 = this.base.getCoordinateReferenceSystem();
        return CRS.findOperation((CoordinateReferenceSystem)coordinateReferenceSystem2, (CoordinateReferenceSystem)coordinateReferenceSystem, (GeographicBoundingBox)this.base.getGeographicExtent().orElse(null)).getMathTransform();
    }

    private WraparoundAdjustment wraparound(MathTransform mathTransform, MathTransform mathTransform2) throws TransformException {
        return new WraparoundAdjustment((Envelope)this.base.envelope, mathTransform, mathTransform2.inverse());
    }

    private MathTransform dropUnusedDimensions(MathTransform mathTransform, int n) throws FactoryException, TransformException {
        if (n < mathTransform.getSourceDimensions()) {
            TransformSeparator transformSeparator = new TransformSeparator(mathTransform);
            mathTransform = transformSeparator.separate();
            this.modifiedDimensions = transformSeparator.getSourceDimensions();
            if (this.modifiedDimensions.length != n) {
                throw new TransformException(Resources.format((short)8));
            }
        }
        return mathTransform;
    }

    private double[] getPointOfInterest() {
        double[] dArray = this.baseExtent.getPointOfInterest(PixelInCell.CELL_CORNER);
        if (this.modifiedDimensions == null) {
            return dArray;
        }
        double[] dArray2 = new double[this.modifiedDimensions.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[this.modifiedDimensions[i]];
        }
        return dArray2;
    }

    private void setBaseExtentClipped(GeneralEnvelope ... generalEnvelopeArray) {
        GridExtent gridExtent = null;
        DisjointExtentException disjointExtentException = null;
        int n = 0;
        do {
            try {
                GridExtent gridExtent2 = new GridExtent((AbstractEnvelope)generalEnvelopeArray[n], this.rounding, this.clipping, this.margin, this.chunkSize, this.baseExtent, this.modifiedDimensions);
                gridExtent = gridExtent == null ? gridExtent2 : gridExtent.union(gridExtent2);
            }
            catch (DisjointExtentException disjointExtentException2) {
                if (disjointExtentException == null) {
                    disjointExtentException = disjointExtentException2;
                    continue;
                }
                disjointExtentException.addSuppressed(disjointExtentException2);
            }
        } while (++n < generalEnvelopeArray.length);
        if (gridExtent == null) {
            throw disjointExtentException;
        }
        if (!gridExtent.equals(this.baseExtent)) {
            this.baseExtent = gridExtent;
        }
        this.isBaseExtentExpanded = true;
    }

    public GridDerivation subgrid(GridExtent gridExtent, int ... nArray) {
        int n;
        this.ensureSubgridNotSet();
        int n2 = this.base.getDimension();
        if (gridExtent != null && (n = gridExtent.getDimension()) != n2) {
            throw new IllegalArgumentException(Errors.format((short)81, "extent", n2, n));
        }
        if (gridExtent != null && this.baseExtent != null) {
            this.baseExtent = this.baseExtent.intersect(gridExtent);
            this.subGridSetter = "subgrid";
        }
        if (nArray == null) {
            return this;
        }
        if (this.chunkSize != null || this.maximumSubsampling != null) {
            nArray = (int[])nArray.clone();
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = this.roundSubsampling(nArray[n], n);
            }
        }
        return this.subsample(nArray);
    }

    private GridDerivation subsample(int ... nArray) {
        if (this.toBase != null) {
            throw new IllegalStateException(Errors.format((short)164, "subsampling"));
        }
        if (this.subGridSetter == null) {
            this.subGridSetter = "subsample";
        }
        GridExtent gridExtent = this.getBaseExtentExpanded(true);
        MatrixSIS matrixSIS = null;
        int n = gridExtent.getDimension();
        int n2 = Math.min(n, nArray.length);
        while (--n2 >= 0) {
            int n3 = nArray[n2];
            if (n3 == 1) continue;
            if (matrixSIS == null) {
                matrixSIS = Matrices.createIdentity((int)(n + 1));
                this.scaledExtent = gridExtent.subsample(nArray);
            }
            long l = Math.subtractExact(gridExtent.getLow(n2), Math.multiplyExact(this.scaledExtent.getLow(n2), (long)n3));
            matrixSIS.setElement(n2, n2, (double)n3);
            matrixSIS.setElement(n2, n, (double)l);
        }
        if (matrixSIS != null) {
            this.toBase = MathTransforms.linear(matrixSIS);
        }
        return this;
    }

    public GridDerivation slice(DirectPosition directPosition) {
        ArgumentChecks.ensureNonNull("slicePoint", directPosition);
        MathTransform mathTransform = this.base.requireGridToCRS(true);
        this.subGridSetter = "slice";
        try {
            MathTransform mathTransform2;
            CoordinateReferenceSystem coordinateReferenceSystem;
            if (this.toBase != null) {
                mathTransform = MathTransforms.concatenate((MathTransform)this.toBase, (MathTransform)mathTransform);
            }
            if ((coordinateReferenceSystem = directPosition.getCoordinateReferenceSystem()) == null) {
                mathTransform2 = null;
            } else {
                directPosition = new DimensionReducer(this.base, coordinateReferenceSystem).apply(directPosition);
                mathTransform2 = this.findBaseToAOI(coordinateReferenceSystem);
                mathTransform = MathTransforms.concatenate((MathTransform)mathTransform, (MathTransform)mathTransform2);
            }
            int n = mathTransform.getTargetDimensions();
            ArgumentChecks.ensureDimensionMatches("slicePoint", n, directPosition);
            mathTransform = this.dropUnusedDimensions(mathTransform, n);
            DirectPosition directPosition2 = this.wraparound(mathTransform2, mathTransform).shift(directPosition);
            if (this.scaledExtent != null) {
                this.scaledExtent = this.scaledExtent.slice(directPosition2, this.modifiedDimensions);
            }
            if (this.toBase != null) {
                directPosition2 = this.toBase.transform(directPosition2, directPosition2);
            }
            this.baseExtent = this.getBaseExtentExpanded(true).slice(directPosition2, this.modifiedDimensions);
        }
        catch (FactoryException factoryException) {
            throw new IllegalGridGeometryException(Resources.format((short)8), factoryException);
        }
        catch (TransformException transformException) {
            throw new IllegalGridGeometryException(transformException, "slicePoint");
        }
        this.modifiedDimensions = null;
        return this;
    }

    public GridDerivation sliceByRatio(double d, int ... nArray) {
        ArgumentChecks.ensureBetween("sliceRatio", 0.0, 1.0, d);
        ArgumentChecks.ensureNonNull("dimensionsToKeep", nArray);
        this.subGridSetter = "sliceByRatio";
        GridExtent gridExtent = this.getBaseExtentExpanded(true);
        GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition(gridExtent.getDimension());
        this.baseExtent = gridExtent.sliceByRatio((DirectPosition)generalDirectPosition, d, nArray);
        if (this.scaledExtent != null) {
            this.scaledExtent = this.scaledExtent.sliceByRatio((DirectPosition)generalDirectPosition, d, nArray);
        }
        return this;
    }

    public GridGeometry build() {
        GridExtent gridExtent = this.scaledExtent != null ? this.scaledExtent : this.getBaseExtentExpanded(false);
        try {
            if (this.toBase != null || gridExtent != this.base.extent) {
                return new GridGeometry(this.base, gridExtent, (MathTransform)this.toBase);
            }
            if (this.intersection != null) {
                return new GridGeometry(PixelInCell.CELL_CENTER, this.base.gridToCRS, (Envelope)this.intersection, this.rounding);
            }
            GridExtent gridExtent2 = this.getBaseExtentExpanded(false);
            if (gridExtent2 != this.baseExtent) {
                return new GridGeometry(this.base, gridExtent2, null);
            }
        }
        catch (TransformException transformException) {
            throw new IllegalGridGeometryException(transformException, "envelope");
        }
        return this.base;
    }

    private GridExtent getBaseExtentExpanded(boolean bl) {
        if (bl && this.baseExtent == null) {
            this.baseExtent = this.base.getExtent();
        }
        if (!this.isBaseExtentExpanded) {
            if (this.baseExtent != null && (this.margin != null || this.chunkSize != null)) {
                GridExtent gridExtent = this.baseExtent;
                if (this.margin != null) {
                    gridExtent = gridExtent.expand(ArraysExt.copyAsLongs(this.margin));
                }
                if (this.chunkSize != null) {
                    gridExtent = gridExtent.forChunkSize(this.chunkSize);
                }
                if (this.clipping == GridClippingMode.STRICT) {
                    gridExtent = gridExtent.intersect(this.base.extent);
                }
                if (!gridExtent.equals(this.baseExtent)) {
                    this.baseExtent = gridExtent;
                }
            }
            this.isBaseExtentExpanded = true;
        }
        return this.baseExtent;
    }

    public GridExtent getIntersection() {
        return this.getBaseExtentExpanded(true);
    }

    public int[] getSubsampling() {
        int[] nArray;
        if (this.toBase == null) {
            nArray = new int[this.base.getDimension()];
            Arrays.fill(nArray, 1);
        } else {
            nArray = new int[this.toBase.getTargetDimensions()];
            Matrix matrix = this.toBase.getMatrix();
            for (int i = 0; i < nArray.length; ++i) {
                double d = matrix.getElement(i, i);
                nArray[i] = (int)d;
                if ((double)nArray[i] == d) continue;
                throw new IllegalStateException(Errors.format((short)171, d));
            }
        }
        return nArray;
    }

    private int roundSubsampling(double d, int n) {
        int n2;
        int n3;
        int n4;
        switch (this.rounding) {
            default: {
                throw new AssertionError((Object)this.rounding);
            }
            case NEAREST: {
                n4 = (int)Math.min(Math.round(d), Integer.MAX_VALUE);
                break;
            }
            case CONTAINED: {
                n4 = (int)Math.ceil(d - this.tolerance(n));
                break;
            }
            case ENCLOSING: {
                n4 = (int)(d + this.tolerance(n));
            }
        }
        int n5 = Integer.MAX_VALUE;
        if (this.maximumSubsampling != null && n < this.maximumSubsampling.length && n4 > (n5 = this.maximumSubsampling[n])) {
            n4 = n5;
        }
        if (n4 <= 1) {
            return 1;
        }
        if (this.chunkSize != null && n < this.chunkSize.length && (n3 = n4 % (n2 = this.chunkSize[n])) > 1 && n2 % n3 != 0) {
            int[] nArray = MathFunctions.divisors(n2);
            int n6 = ~Arrays.binarySearch(nArray, n3);
            int n7 = nArray[n6 - 1];
            int n8 = n4 - n3;
            if (this.rounding != GridRoundingMode.ENCLOSING && n6 < nArray.length) {
                int n9 = nArray[n6];
                if (!(n5 != Integer.MAX_VALUE && n9 > n5 - n8 || this.rounding != GridRoundingMode.CONTAINED && n9 - n3 >= n3 - n7)) {
                    n7 = n9;
                }
            }
            return n7 + n8;
        }
        return n4;
    }

    private double tolerance(int n) {
        return this.base.extent != null ? 0.5 / this.base.extent.getSize(n, false) : 0.0;
    }

    public int[] getSubsamplingOffsets() {
        int[] nArray;
        if (this.toBase == null) {
            nArray = new int[this.base.getDimension()];
        } else {
            int n = this.toBase.getSourceDimensions();
            nArray = new int[this.toBase.getTargetDimensions()];
            Matrix matrix = this.toBase.getMatrix();
            for (int i = 0; i < nArray.length; ++i) {
                double d = matrix.getElement(i, n);
                nArray[i] = (int)d;
                if ((double)nArray[i] == d) continue;
                throw new IllegalStateException(Errors.format((short)171, d));
            }
        }
        return nArray;
    }

    private TreeTable toTree(Locale locale) {
        TreeTable.Node node;
        TableColumn<CharSequence> tableColumn = TableColumn.VALUE_AS_TEXT;
        DefaultTreeTable defaultTreeTable = new DefaultTreeTable(tableColumn);
        TreeTable.Node node2 = defaultTreeTable.getRoot();
        node2.setValue(tableColumn, Classes.getShortClassName(this));
        StringBuilder stringBuilder = new StringBuilder(256);
        if (this.baseExtent != null) {
            node = node2.newChild();
            node.setValue(tableColumn, "Intersection");
            try {
                this.baseExtent.appendTo(stringBuilder, Vocabulary.getResources(locale));
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
            for (CharSequence charSequence : CharSequences.splitOnEOL(stringBuilder)) {
                String string = charSequence.toString().trim();
                if (string.isEmpty()) continue;
                node.newChild().setValue(tableColumn, string);
            }
        }
        if (this.toBase != null) {
            node = node2.newChild();
            node.setValue(tableColumn, "Subsampling");
            boolean bl = false;
            do {
                CharSequence charSequence;
                stringBuilder.setLength(0);
                stringBuilder.append(bl ? (char)'+' : '\u00d7').append(" {");
                int n = this.toBase.getSourceDimensions();
                int n2 = this.toBase.getTargetDimensions();
                charSequence = this.toBase.getMatrix();
                for (int i = 0; i < n2; ++i) {
                    if (i != 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(charSequence.getElement(i, bl ? n : i));
                    StringBuilders.trimFractionalPart(stringBuilder);
                }
                node.newChild().setValue(tableColumn, stringBuilder.append('}').toString());
            } while (bl = !bl);
        }
        return defaultTreeTable;
    }

    public String toString() {
        return this.toTree(null).toString();
    }
}

