/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.util.Arrays;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.referencing.CRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.util.FactoryException;

final class DimensionReducer {
    private int[] dimensions;
    private CoordinateReferenceSystem reducedCRS;

    DimensionReducer(GridGeometry gridGeometry, CoordinateReferenceSystem coordinateReferenceSystem) throws FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem2;
        if (gridGeometry != null && gridGeometry.envelope != null && (coordinateReferenceSystem2 = gridGeometry.envelope.getCoordinateReferenceSystem()) != null) {
            CoordinateSystem coordinateSystem = coordinateReferenceSystem2.getCoordinateSystem();
            CoordinateSystem coordinateSystem2 = coordinateReferenceSystem.getCoordinateSystem();
            if (coordinateSystem.getDimension() < coordinateSystem2.getDimension()) {
                this.dimensions = AxisDirections.indicesOfLenientMapping((CoordinateSystem)coordinateSystem2, (CoordinateSystem)coordinateSystem);
                if (this.dimensions != null) {
                    Arrays.sort(this.dimensions);
                    this.reducedCRS = CRS.selectDimensions((CoordinateReferenceSystem)coordinateReferenceSystem, (int[])this.dimensions);
                }
            }
        }
    }

    final DirectPosition apply(DirectPosition directPosition) {
        if (this.dimensions == null) {
            return directPosition;
        }
        GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition(this.reducedCRS);
        for (int i = 0; i < this.dimensions.length; ++i) {
            generalDirectPosition.coordinates[i] = directPosition.getOrdinate(this.dimensions[i]);
        }
        return generalDirectPosition;
    }

    final Envelope apply(Envelope envelope) {
        if (this.dimensions == null) {
            return envelope;
        }
        DirectPosition directPosition = envelope.getLowerCorner();
        DirectPosition directPosition2 = envelope.getUpperCorner();
        GeneralEnvelope generalEnvelope = new GeneralEnvelope(this.reducedCRS);
        for (int i = 0; i < this.dimensions.length; ++i) {
            int n = this.dimensions[i];
            generalEnvelope.setRange(i, directPosition.getOrdinate(n), directPosition2.getOrdinate(n));
        }
        return generalEnvelope;
    }
}

