/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.portrayal;

import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.sis.portrayal.Canvas;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.logging.Logging;
import org.opengis.referencing.operation.NoninvertibleTransformException;

public class TransformChangeEvent
extends PropertyChangeEvent {
    private static final long serialVersionUID = 4444752056666264066L;
    private final Reason reason;
    private transient LinearTransform displayChange;
    private transient LinearTransform objectiveChange;
    private AffineTransform displayChange2D;
    private AffineTransform objectiveChange2D;
    private transient Exception error;

    public TransformChangeEvent(Canvas canvas, LinearTransform linearTransform, LinearTransform linearTransform2, Reason reason) {
        super(canvas, "objectiveToDisplay", linearTransform, linearTransform2);
        ArgumentChecks.ensureNonNull("reason", (Object)reason);
        this.reason = reason;
    }

    public TransformChangeEvent(Canvas canvas, LinearTransform linearTransform, LinearTransform linearTransform2, AffineTransform affineTransform, AffineTransform affineTransform2, Reason reason) {
        this(canvas, linearTransform, linearTransform2, reason);
        this.objectiveChange2D = affineTransform;
        this.displayChange2D = affineTransform2;
    }

    final boolean isSameSource(Canvas canvas) {
        return super.getSource() == canvas;
    }

    @Override
    public Canvas getSource() {
        return (Canvas)this.source;
    }

    public Reason getReason() {
        return this.reason;
    }

    @Override
    public LinearTransform getOldValue() {
        return (LinearTransform)super.getOldValue();
    }

    @Override
    public LinearTransform getNewValue() {
        LinearTransform linearTransform = (LinearTransform)super.getNewValue();
        if (linearTransform == null) {
            linearTransform = this.getSource().getObjectiveToDisplay();
        }
        return linearTransform;
    }

    public LinearTransform getObjectiveChange() {
        if (this.objectiveChange == null) {
            if (this.objectiveChange2D != null) {
                this.objectiveChange = AffineTransforms2D.toMathTransform(this.objectiveChange2D);
            } else {
                LinearTransform linearTransform;
                LinearTransform linearTransform2 = this.getOldValue();
                if (linearTransform2 != null && (linearTransform = this.getNewValue()) != null) {
                    try {
                        this.objectiveChange = (LinearTransform)MathTransforms.concatenate(linearTransform, linearTransform2.inverse());
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        this.canNotCompute("getObjectiveChange", (Exception)((Object)noninvertibleTransformException));
                    }
                }
            }
        }
        return this.objectiveChange;
    }

    public LinearTransform getDisplayChange() {
        if (this.displayChange == null) {
            if (this.displayChange2D != null) {
                this.displayChange = AffineTransforms2D.toMathTransform(this.displayChange2D);
            } else {
                LinearTransform linearTransform;
                LinearTransform linearTransform2 = this.getOldValue();
                if (linearTransform2 != null && (linearTransform = this.getNewValue()) != null) {
                    try {
                        this.displayChange = (LinearTransform)MathTransforms.concatenate(linearTransform2.inverse(), linearTransform);
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        this.canNotCompute("getDisplayChange", (Exception)((Object)noninvertibleTransformException));
                    }
                }
            }
        }
        return this.displayChange;
    }

    public Optional<AffineTransform> getObjectiveChange2D() {
        if (this.objectiveChange2D == null) {
            try {
                Object object = super.getOldValue();
                Object object2 = super.getNewValue();
                if (object instanceof AffineTransform && object2 instanceof AffineTransform) {
                    this.objectiveChange2D = ((AffineTransform)object).createInverse();
                    this.objectiveChange2D.concatenate((AffineTransform)object2);
                } else {
                    this.objectiveChange2D = AffineTransforms2D.castOrCopy(this.getObjectiveChange());
                }
            }
            catch (java.awt.geom.NoninvertibleTransformException | IllegalArgumentException exception) {
                this.canNotCompute("getObjectiveChange2D", exception);
            }
        }
        return Optional.ofNullable(this.objectiveChange2D);
    }

    public Optional<AffineTransform> getDisplayChange2D() {
        if (this.displayChange2D == null) {
            try {
                Object object = super.getOldValue();
                Object object2 = super.getNewValue();
                if (object instanceof AffineTransform && object2 instanceof AffineTransform) {
                    this.displayChange2D = ((AffineTransform)object).createInverse();
                    this.displayChange2D.preConcatenate((AffineTransform)object2);
                } else {
                    this.displayChange2D = AffineTransforms2D.castOrCopy(this.getDisplayChange());
                }
            }
            catch (java.awt.geom.NoninvertibleTransformException | IllegalArgumentException exception) {
                this.canNotCompute("getDisplayChange2D", exception);
            }
        }
        return Optional.ofNullable(this.displayChange2D);
    }

    private void canNotCompute(String string, Exception exception) {
        if (this.error == null) {
            this.error = exception;
            Logging.recoverableException(Logger.getLogger("org.apache.sis.portrayal"), TransformChangeEvent.class, string, exception);
        } else {
            this.error.addSuppressed(exception);
        }
    }

    public static enum Reason {
        GRID_GEOMETRY_CHANGE,
        CRS_CHANGE,
        ASSIGNMENT,
        OBJECTIVE_NAVIGATION,
        DISPLAY_NAVIGATION,
        INTERIM;


        final boolean isNavigation() {
            return this.ordinal() >= ASSIGNMENT.ordinal() && this.ordinal() < INTERIM.ordinal();
        }
    }
}

