/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.map.coverage;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Vector;

public final class RenderingWorkaround
implements RenderedImage {
    private final RenderedImage image;

    public static RenderedImage wrap(RenderedImage renderedImage) {
        if (renderedImage != null && !(renderedImage instanceof BufferedImage) && !(renderedImage instanceof RenderingWorkaround)) {
            return new RenderingWorkaround(renderedImage);
        }
        return renderedImage;
    }

    private RenderingWorkaround(RenderedImage renderedImage) {
        this.image = renderedImage;
    }

    @Override
    public Vector<RenderedImage> getSources() {
        return this.image.getSources();
    }

    @Override
    public Object getProperty(String string) {
        return this.image.getProperty(string);
    }

    @Override
    public String[] getPropertyNames() {
        return this.image.getPropertyNames();
    }

    @Override
    public ColorModel getColorModel() {
        return this.image.getColorModel();
    }

    @Override
    public SampleModel getSampleModel() {
        return this.image.getSampleModel();
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public int getMinX() {
        return this.image.getMinX();
    }

    @Override
    public int getMinY() {
        return this.image.getMinY();
    }

    @Override
    public int getNumXTiles() {
        return this.image.getNumXTiles();
    }

    @Override
    public int getNumYTiles() {
        return this.image.getNumYTiles();
    }

    @Override
    public int getMinTileX() {
        return this.image.getMinTileX();
    }

    @Override
    public int getMinTileY() {
        return this.image.getMinTileY();
    }

    @Override
    public int getTileWidth() {
        return this.image.getTileWidth();
    }

    @Override
    public int getTileHeight() {
        return this.image.getTileHeight();
    }

    @Override
    public int getTileGridXOffset() {
        return this.image.getTileGridXOffset();
    }

    @Override
    public int getTileGridYOffset() {
        return this.image.getTileGridYOffset();
    }

    @Override
    public Raster getTile(int n, int n2) {
        return RenderingWorkaround.wrap(this.image.getTile(n, n2));
    }

    @Override
    public Raster getData() {
        return RenderingWorkaround.wrap(this.image.getData());
    }

    @Override
    public Raster getData(Rectangle rectangle) {
        return RenderingWorkaround.wrap(this.image.getData(rectangle));
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        return this.image.copyData(writableRaster);
    }

    private static Raster wrap(Raster raster) {
        if (raster instanceof WritableRaster) {
            return raster;
        }
        return Raster.createWritableRaster(raster.getSampleModel(), raster.getDataBuffer(), new Point(raster.getMinX(), raster.getMinY()));
    }
}

