/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.map.coverage;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import javax.measure.Quantity;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.ImageRenderer;
import org.apache.sis.coverage.grid.PixelTranslation;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.Envelope2D;
import org.apache.sis.geometry.Shapes2D;
import org.apache.sis.image.ErrorHandler;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.internal.coverage.SampleDimensions;
import org.apache.sis.internal.coverage.j2d.ColorModelType;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.map.coverage.MultiResolutionCoverageLoader;
import org.apache.sis.internal.referencing.WraparoundApplicator;
import org.apache.sis.io.TableAppender;
import org.apache.sis.math.Statistics;
import org.apache.sis.measure.Quantities;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.portrayal.PlanarCanvas;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class RenderingData
implements Cloneable {
    private static final int BIDIMENSIONAL = 2;
    private static final boolean CREATE_INDEX_COLOR_MODEL = true;
    public MultiResolutionCoverageLoader coverageLoader;
    private int currentPyramidLevel;
    private GridExtent currentSlice;
    private int[] xyDimensions;
    private RenderedImage data;
    private GridGeometry dataGeometry;
    private List<SampleDimension> dataRanges;
    private CoordinateOperation changeOfCRS;
    private MathTransform cornerToObjective;
    private MathTransform objectiveToCenter;
    private AffineTransform displayToObjective;
    private Statistics[] statistics;
    public final ImageProcessor processor = new ImageProcessor();

    public RenderingData(ErrorHandler errorHandler) {
        this.processor.setErrorHandler(errorHandler);
        this.processor.setImageResizingPolicy(ImageProcessor.Resizing.EXPAND);
    }

    public final void clear() {
        this.clearCRS();
        this.coverageLoader = null;
        this.displayToObjective = null;
        this.statistics = null;
        this.data = null;
        this.dataRanges = null;
        this.dataGeometry = null;
        this.xyDimensions = null;
        this.currentSlice = null;
    }

    private void clearCRS() {
        this.changeOfCRS = null;
        this.cornerToObjective = null;
        this.objectiveToCenter = null;
    }

    public final boolean validateCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (this.changeOfCRS != null && !Utilities.equalsIgnoreMetadata(coordinateReferenceSystem, this.changeOfCRS.getTargetCRS())) {
            this.clearCRS();
            return false;
        }
        return true;
    }

    public final void setImageSpace(GridGeometry gridGeometry, List<SampleDimension> list, int[] nArray) {
        this.processor.setFillValues(SampleDimensions.backgrounds(list));
        this.dataRanges = list;
        this.dataGeometry = gridGeometry;
        this.xyDimensions = nArray;
        if (gridGeometry != null && !gridGeometry.isDefined(8) && gridGeometry.isDefined(4)) {
            CoordinateReferenceSystem coordinateReferenceSystem = null;
            if (gridGeometry.isDefined(1)) {
                coordinateReferenceSystem = gridGeometry.getCoordinateReferenceSystem();
            }
            GridExtent gridExtent = gridGeometry.getExtent();
            this.dataGeometry = new GridGeometry(gridExtent, PixelInCell.CELL_CENTER, (MathTransform)MathTransforms.identity(gridExtent.getDimension()), coordinateReferenceSystem);
        }
    }

    public final GridCoverage ensureCoverageLoaded(LinearTransform linearTransform, DirectPosition directPosition) throws TransformException, DataStoreException {
        MathTransform mathTransform = this.changeOfCRS != null ? this.changeOfCRS.getMathTransform() : null;
        MultiResolutionCoverageLoader multiResolutionCoverageLoader = this.coverageLoader;
        int n = multiResolutionCoverageLoader.findPyramidLevel(mathTransform, linearTransform, directPosition);
        if (this.data != null && n == this.currentPyramidLevel) {
            return null;
        }
        this.data = null;
        this.currentPyramidLevel = n;
        return multiResolutionCoverageLoader.getOrLoad(n);
    }

    public final boolean ensureImageLoaded(GridCoverage gridCoverage, GridExtent gridExtent, boolean bl) throws FactoryException, TransformException {
        ImageRenderer imageRenderer;
        int[] nArray;
        GridGeometry gridGeometry;
        if (!bl && this.data != null && Objects.equals(this.currentSlice, gridExtent)) {
            return false;
        }
        gridCoverage = gridCoverage.forConvertedValues(true);
        GridGeometry gridGeometry2 = this.dataGeometry;
        List list = gridCoverage.getSampleDimensions();
        RenderedImage renderedImage = gridCoverage.render(gridExtent);
        Object object = renderedImage.getProperty("org.apache.sis.GridGeometry");
        if (object instanceof GridGeometry) {
            gridGeometry = (GridGeometry)object;
            nArray = gridExtent == null ? ArraysExt.range(0, 2) : gridExtent.getSubspaceDimensions(2);
        } else {
            imageRenderer = new ImageRenderer(gridCoverage, gridExtent);
            gridGeometry = imageRenderer.getImageGeometry(2);
            nArray = imageRenderer.getXYDimensions();
        }
        this.setImageSpace(gridGeometry, list, nArray);
        this.currentSlice = gridExtent;
        this.data = renderedImage;
        if (gridGeometry2 != null && this.cornerToObjective != null && this.objectiveToCenter != null) {
            CoordinateReferenceSystem coordinateReferenceSystem;
            CoordinateReferenceSystem coordinateReferenceSystem2;
            imageRenderer = null;
            MathTransform mathTransform = null;
            if (gridGeometry2.isDefined(1) && gridGeometry.isDefined(1)) {
                coordinateReferenceSystem2 = gridGeometry2.getCoordinateReferenceSystem();
                coordinateReferenceSystem = this.dataGeometry.getCoordinateReferenceSystem();
                if (coordinateReferenceSystem != coordinateReferenceSystem2) {
                    GeographicBoundingBox geographicBoundingBox = Extents.union((GeographicBoundingBox)this.dataGeometry.getGeographicExtent().orElse(null), (GeographicBoundingBox)gridGeometry2.getGeographicExtent().orElse(null));
                    imageRenderer = CRS.findOperation(coordinateReferenceSystem2, coordinateReferenceSystem, geographicBoundingBox).getMathTransform();
                    mathTransform = imageRenderer.inverse();
                }
            }
            coordinateReferenceSystem2 = RenderingData.concatenate(PixelInCell.CELL_CORNER, this.dataGeometry, gridGeometry2, mathTransform);
            coordinateReferenceSystem = RenderingData.concatenate(PixelInCell.CELL_CENTER, gridGeometry2, this.dataGeometry, (MathTransform)imageRenderer);
            this.cornerToObjective = MathTransforms.concatenate((MathTransform)coordinateReferenceSystem2, this.cornerToObjective);
            this.objectiveToCenter = MathTransforms.concatenate(this.objectiveToCenter, (MathTransform)coordinateReferenceSystem);
        }
        return true;
    }

    private static MathTransform concatenate(PixelInCell pixelInCell, GridGeometry gridGeometry, GridGeometry gridGeometry2, MathTransform mathTransform) throws TransformException {
        MathTransform mathTransform2 = gridGeometry.getGridToCRS(pixelInCell);
        MathTransform mathTransform3 = gridGeometry2.getGridToCRS(pixelInCell).inverse();
        if (mathTransform != null) {
            return MathTransforms.concatenate(mathTransform2, mathTransform, mathTransform3);
        }
        return MathTransforms.concatenate(mathTransform2, mathTransform3);
    }

    public final RenderedImage getSourceImage() {
        return this.data;
    }

    private DirectPosition getSourceMedian() {
        if (this.dataGeometry.isDefined(2)) {
            return AbstractEnvelope.castOrCopy(this.dataGeometry.getEnvelope()).getMedian();
        }
        return null;
    }

    protected final Map<String, Object> statistics() throws DataStoreException {
        Object object;
        if (this.statistics == null) {
            int n;
            object = this.data;
            MultiResolutionCoverageLoader multiResolutionCoverageLoader = this.coverageLoader;
            if (multiResolutionCoverageLoader != null && (n = multiResolutionCoverageLoader.getLastLevel()) != this.currentPyramidLevel) {
                GridCoverage gridCoverage = multiResolutionCoverageLoader.getOrLoad(n).forConvertedValues(true);
                GridExtent gridExtent = this.currentSlice;
                if (gridExtent != null) {
                    if (gridExtent.getDimension() <= 2) {
                        gridExtent = null;
                    } else {
                        GridExtent gridExtent2 = gridCoverage.getGridGeometry().getExtent();
                        for (int n2 : this.xyDimensions) {
                            gridExtent = gridExtent.withRange(n2, gridExtent2.getLow(n2), gridExtent2.getHigh(n2));
                        }
                    }
                }
                object = gridCoverage.render(gridExtent);
            }
            this.statistics = this.processor.valueOfStatistics((RenderedImage)object, null, SampleDimensions.toSampleFilters((ImageProcessor)this.processor, this.dataRanges));
        }
        object = new HashMap(8);
        object.put("statistics", this.statistics);
        object.put("sampleDimensions", this.dataRanges);
        return object;
    }

    public final void setObjectiveCRS(CoordinateReferenceSystem coordinateReferenceSystem) throws TransformException {
        if (this.changeOfCRS == null && coordinateReferenceSystem != null && this.dataGeometry.isDefined(1)) {
            try {
                this.changeOfCRS = CRS.findOperation(this.dataGeometry.getCoordinateReferenceSystem(), coordinateReferenceSystem, this.dataGeometry.getGeographicExtent().orElse(null));
                double d = CRS.getLinearAccuracy(this.changeOfCRS);
                this.processor.setPositionalAccuracyHints(new Quantity[]{d > 0.0 ? Quantities.create(d, Units.METRE) : null});
            }
            catch (FactoryException factoryException) {
                RenderingData.recoverableException((Exception)((Object)factoryException));
            }
        }
    }

    public final RenderedImage resampleAndConvert(RenderedImage renderedImage, LinearTransform linearTransform, DirectPosition directPosition) throws TransformException {
        MathTransform mathTransform;
        Rectangle rectangle;
        MathTransform mathTransform2;
        MathTransform mathTransform3;
        LinearTransform linearTransform2;
        MathTransform mathTransform4 = null;
        if (this.cornerToObjective == null || this.objectiveToCenter == null) {
            this.cornerToObjective = this.dataGeometry.getGridToCRS(PixelInCell.CELL_CORNER);
            this.objectiveToCenter = this.dataGeometry.getGridToCRS(PixelInCell.CELL_CENTER).inverse();
            if (this.changeOfCRS != null) {
                linearTransform2 = this.getSourceMedian();
                mathTransform3 = this.changeOfCRS.getMathTransform();
                mathTransform2 = mathTransform3.inverse();
                rectangle = mathTransform2;
                try {
                    mathTransform3 = RenderingData.applyWraparound(mathTransform3, (DirectPosition)linearTransform2, directPosition, this.changeOfCRS.getTargetCRS());
                    mathTransform2 = RenderingData.applyWraparound(mathTransform2, directPosition, (DirectPosition)linearTransform2, this.changeOfCRS.getSourceCRS());
                }
                catch (TransformException transformException) {
                    RenderingData.recoverableException((Exception)((Object)transformException));
                }
                if (mathTransform2 != rectangle) {
                    mathTransform4 = MathTransforms.concatenate((MathTransform)rectangle, this.objectiveToCenter);
                }
                this.cornerToObjective = MathTransforms.concatenate(this.cornerToObjective, mathTransform3);
                this.objectiveToCenter = MathTransforms.concatenate(mathTransform2, this.objectiveToCenter);
            }
        }
        linearTransform2 = linearTransform.inverse();
        this.displayToObjective = AffineTransforms2D.castOrCopy(linearTransform2);
        mathTransform3 = MathTransforms.concatenate(this.cornerToObjective, linearTransform);
        mathTransform2 = MathTransforms.concatenate(linearTransform2, this.objectiveToCenter);
        rectangle = ImageUtilities.getBounds((RenderedImage)renderedImage);
        MathTransforms.getDomain(mathTransform3).ifPresent(envelope -> Shapes2D.intersect(rectangle, envelope, 0, 1));
        Shapes2D.transform(MathTransforms.bidimensional(mathTransform3), (Rectangle2D)rectangle, (Rectangle2D)rectangle);
        if (mathTransform4 != null && !RenderingData.isWraparoundNeeded(rectangle, mathTransform2, mathTransform = MathTransforms.concatenate(linearTransform2, mathTransform4))) {
            this.objectiveToCenter = mathTransform4;
            mathTransform2 = mathTransform;
        }
        mathTransform = ColorModelType.find((ColorModel)renderedImage.getColorModel());
        if (mathTransform.isSlow || mathTransform.useColorRamp && this.processor.getCategoryColors() != null) {
            return this.processor.visualize(renderedImage, rectangle, mathTransform2, this.dataRanges);
        }
        return this.processor.resample(renderedImage, rectangle, mathTransform2);
    }

    private static MathTransform applyWraparound(MathTransform mathTransform, DirectPosition directPosition, DirectPosition directPosition2, CoordinateReferenceSystem coordinateReferenceSystem) throws TransformException {
        if (directPosition2 == null) {
            return mathTransform;
        }
        if (directPosition != null && !mathTransform.isIdentity()) {
            directPosition = mathTransform.transform(directPosition, null);
        }
        return new WraparoundApplicator(directPosition, directPosition2, coordinateReferenceSystem.getCoordinateSystem()).forDomainOfUse(mathTransform);
    }

    private static boolean isWraparoundNeeded(Rectangle rectangle, MathTransform mathTransform, MathTransform mathTransform2) throws TransformException {
        double d;
        int n;
        int n2 = mathTransform2.getSourceDimensions();
        int n3 = mathTransform2.getTargetDimensions();
        double[] dArray = new double[n2 * 9];
        double[] dArray2 = new double[n3 * 9];
        for (n = 0; n < 9; ++n) {
            double d2;
            switch (n % 3) {
                case 0: {
                    d = rectangle.getMinX();
                    break;
                }
                case 1: {
                    d = rectangle.getMaxX();
                    break;
                }
                default: {
                    d = rectangle.getCenterX();
                }
            }
            switch (n / 3) {
                case 0: {
                    d2 = rectangle.getMinY();
                    break;
                }
                case 1: {
                    d2 = rectangle.getMaxY();
                    break;
                }
                default: {
                    d2 = rectangle.getCenterY();
                }
            }
            int n4 = n * n2;
            dArray[n4] = d;
            dArray[n4 + 1] = d2;
        }
        mathTransform2.transform(dArray, 0, dArray2, 0, 9);
        mathTransform.transform(dArray, 0, dArray, 0, 9);
        for (n = 0; n < dArray2.length; ++n) {
            d = dArray[n];
            if (Math.abs(dArray2[n] - d) < 1.0 || !Double.isFinite(d)) continue;
            return true;
        }
        return false;
    }

    public final RenderedImage prefetch(RenderedImage renderedImage, AffineTransform affineTransform, Envelope2D envelope2D) {
        Rectangle rectangle;
        try {
            rectangle = (Rectangle)AffineTransforms2D.transform(affineTransform.createInverse(), envelope2D, new Rectangle());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            RenderingData.recoverableException(noninvertibleTransformException);
            return renderedImage;
        }
        return this.processor.prefetch(renderedImage, rectangle);
    }

    public final AffineTransform getTransform(LinearTransform linearTransform) {
        if (this.displayToObjective == null) {
            return new AffineTransform();
        }
        AffineTransform affineTransform = AffineTransforms2D.castOrCopy(linearTransform);
        if (affineTransform == linearTransform) {
            affineTransform = new AffineTransform(affineTransform);
        }
        affineTransform.concatenate(this.displayToObjective);
        ImageUtilities.roundIfAlmostInteger((AffineTransform)affineTransform);
        return affineTransform;
    }

    public final float getDataPixelSize(DirectPosition directPosition) {
        if (this.objectiveToCenter != null) {
            try {
                Matrix matrix = this.objectiveToCenter.derivative(directPosition);
                double d = 0.0;
                int n = matrix.getNumRow();
                while (--n >= 0) {
                    int n2 = matrix.getNumCol();
                    while (--n2 >= 0) {
                        double d2 = matrix.getElement(n, n2);
                        d += d2 * d2;
                    }
                }
                float f = (float)(1.0 / Math.sqrt(d));
                if (f > 0.0f && f != Float.POSITIVE_INFINITY) {
                    return f;
                }
            }
            catch (TransformException transformException) {
                RenderingData.recoverableException((Exception)((Object)transformException));
            }
        }
        return 0.0f;
    }

    public final MathTransform getDataToObjective(PixelInCell pixelInCell) {
        return PixelTranslation.translate((MathTransform)this.cornerToObjective, (PixelInCell)PixelInCell.CELL_CORNER, (PixelInCell)pixelInCell);
    }

    public final Rectangle objectiveToData(Rectangle2D rectangle2D) throws TransformException {
        if (this.objectiveToCenter == null) {
            return null;
        }
        return (Rectangle)Shapes2D.transform(MathTransforms.bidimensional(this.objectiveToCenter), rectangle2D, (Rectangle2D)new Rectangle());
    }

    public final boolean hasChanged(RenderingData renderingData) {
        return renderingData.dataGeometry != this.dataGeometry || renderingData.objectiveToCenter != this.objectiveToCenter;
    }

    private static void recoverableException(Exception exception) {
        Logging.recoverableException(Logger.getLogger("org.apache.sis.portrayal"), PlanarCanvas.class, "render", exception);
    }

    public RenderingData clone() {
        try {
            return (RenderingData)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public String toString() {
        String string = System.lineSeparator();
        StringBuilder stringBuilder = new StringBuilder(6000);
        TableAppender tableAppender = new TableAppender(stringBuilder);
        tableAppender.setMultiLinesCells(true);
        try {
            tableAppender.nextLine('\u2550');
            tableAppender.append("Geometry of source coverage:").append(string).append(String.valueOf(this.dataGeometry)).appendHorizontalSeparator();
            tableAppender.append("Pixel corners to objective CRS:").append(string).append(String.valueOf(this.cornerToObjective)).appendHorizontalSeparator();
            tableAppender.append("Median in data CRS:").append(string).append(String.valueOf(this.getSourceMedian())).nextLine();
            tableAppender.nextLine('\u2550');
            tableAppender.flush();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return stringBuilder.toString();
    }
}

