/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.builder;

import java.text.NumberFormat;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import org.apache.sis.io.TableAppender;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

final class ProjectedTransformTry
implements Comparable<ProjectedTransformTry>,
Map.Entry<String, MathTransform> {
    private static final int BUFFER_CAPACITY = 512;
    private final String name;
    final MathTransform projection;
    private final int[] projToGrid;
    final boolean reverseAfterLinearization;
    float correlation;
    private TransformException error;

    ProjectedTransformTry(ProjectedTransformTry projectedTransformTry) {
        this.name = projectedTransformTry.name;
        this.projection = projectedTransformTry.projection;
        this.projToGrid = projectedTransformTry.projToGrid;
        this.reverseAfterLinearization = projectedTransformTry.reverseAfterLinearization;
    }

    ProjectedTransformTry(String string, MathTransform mathTransform, int[] nArray, int n, boolean bl) {
        ArgumentChecks.ensureNonNull("name", string);
        ArgumentChecks.ensureNonNull("projection", mathTransform);
        this.name = string;
        this.projection = mathTransform;
        this.projToGrid = nArray;
        this.reverseAfterLinearization = bl;
        int n2 = 0;
        int n3 = mathTransform.getSourceDimensions();
        if (n3 <= n && n3 == (n = nArray.length)) {
            n3 = mathTransform.getTargetDimensions();
            if (n3 == n) {
                return;
            }
            n2 = 1;
        }
        throw new MismatchedDimensionException(Errors.format((short)190, string, n2, n, n3));
    }

    @Override
    public String getKey() {
        return this.name;
    }

    @Override
    public MathTransform getValue() {
        LinearTransform linearTransform = MathTransforms.linear(Matrices.createDimensionSelect(this.projToGrid.length, this.projToGrid));
        return MathTransforms.concatenate(linearTransform, this.projection);
    }

    @Override
    public MathTransform setValue(MathTransform mathTransform) {
        throw new UnsupportedOperationException();
    }

    final double[][] transform(double[][] dArray, int n, Queue<double[]> queue) {
        int n2;
        int n3 = this.projToGrid.length;
        double[][] dArrayArray = new double[n3][];
        for (n2 = 0; n2 < n3; ++n2) {
            dArrayArray[n2] = queue.poll();
            if (dArrayArray[n2] != null) continue;
            dArrayArray[n2] = new double[n];
        }
        try {
            if (n3 == 1) {
                this.projection.transform(dArray[this.projToGrid[0]], 0, dArrayArray[0], 0, n);
            } else {
                n2 = Math.min(n, 512);
                double[] dArray2 = new double[n2 * n3];
                int n4 = 0;
                while (n4 < n) {
                    int n5;
                    double[] dArray3;
                    int n6;
                    int n7 = n4;
                    int n8 = Math.min(n7 + n2, n);
                    for (n6 = 0; n6 < n3; ++n6) {
                        dArray3 = dArray[this.projToGrid[n6]];
                        n4 = n7;
                        n5 = n6;
                        do {
                            dArray2[n5] = dArray3[n4];
                            n5 += n3;
                        } while (++n4 < n8);
                    }
                    this.projection.transform(dArray2, 0, dArray2, 0, n8 - n7);
                    for (n6 = 0; n6 < n3; ++n6) {
                        dArray3 = dArrayArray[n6];
                        n4 = n7;
                        n5 = n6;
                        do {
                            if (!Double.isFinite(dArray3[n4] = dArray2[n5])) {
                                ProjectedTransformTry.recycle(dArrayArray, queue);
                                return null;
                            }
                            n5 += n3;
                        } while (++n4 < n8);
                    }
                }
            }
        }
        catch (TransformException transformException) {
            this.error = transformException;
            ProjectedTransformTry.recycle(dArrayArray, queue);
            return null;
        }
        return dArrayArray;
    }

    static void recycle(double[][] dArray, Queue<double[]> queue) {
        if (dArray != null) {
            Collections.addAll(queue, dArray);
        }
    }

    private boolean useSameDimensions() {
        return ArraysExt.isRange(0, this.projToGrid);
    }

    final double[][] replaceTransformed(double[][] dArray, double[][] dArray2) {
        if (dArray2.length == dArray.length && this.useSameDimensions()) {
            return dArray2;
        }
        dArray = (double[][])dArray.clone();
        for (int i = 0; i < this.projToGrid.length; ++i) {
            dArray[this.projToGrid[i]] = dArray2[i];
        }
        return dArray;
    }

    final double[] replaceTransformed(double[] dArray, double[] dArray2) {
        if (dArray2.length == dArray.length && this.useSameDimensions()) {
            return dArray2;
        }
        dArray = (double[])dArray.clone();
        for (int i = 0; i < this.projToGrid.length; ++i) {
            dArray[this.projToGrid[i]] = dArray2[i];
        }
        return dArray;
    }

    final MatrixSIS replaceTransformed(MatrixSIS matrixSIS, MatrixSIS matrixSIS2) {
        assert (matrixSIS2.getNumCol() == matrixSIS.getNumCol());
        if (matrixSIS2.getNumRow() == matrixSIS.getNumRow() && this.useSameDimensions()) {
            return matrixSIS2;
        }
        matrixSIS = matrixSIS.clone();
        for (int i = 0; i < this.projToGrid.length; ++i) {
            int n = this.projToGrid[i];
            int n2 = matrixSIS.getNumCol();
            while (--n2 >= 0) {
                matrixSIS.setNumber(n, n2, matrixSIS2.getNumber(i, n2));
            }
        }
        return matrixSIS;
    }

    static TransformException getError(List<ProjectedTransformTry> list) {
        TransformException transformException = null;
        for (ProjectedTransformTry projectedTransformTry : list) {
            TransformException transformException2 = projectedTransformTry.error;
            if (transformException2 == null) continue;
            if (transformException == null) {
                transformException = transformException2;
                continue;
            }
            transformException.addSuppressed((Throwable)transformException2);
        }
        return transformException;
    }

    @Override
    public int compareTo(ProjectedTransformTry projectedTransformTry) {
        return Float.compare(-this.correlation, -projectedTransformTry.correlation);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)object;
            return this.name.equals(entry.getKey()) && this.projection.equals(entry.getValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() ^ this.projection.hashCode();
    }

    final NumberFormat summarize(TableAppender tableAppender, NumberFormat numberFormat, Locale locale) {
        tableAppender.append(this.name).nextColumn();
        String string = "";
        if (this.error != null) {
            string = Exceptions.getLocalizedMessage(this.error, locale);
            if (string == null) {
                string = ((Object)((Object)this.error)).getClass().getSimpleName();
            }
        } else if (this.correlation > 0.0f) {
            if (numberFormat == null) {
                numberFormat = locale != null ? NumberFormat.getInstance(locale) : NumberFormat.getInstance();
                numberFormat.setMinimumFractionDigits(6);
                numberFormat.setMaximumFractionDigits(6);
            }
            string = numberFormat.format(this.correlation);
        }
        tableAppender.append(string).nextLine();
        return numberFormat;
    }

    public String toString() {
        TableAppender tableAppender = new TableAppender("  ");
        this.summarize(tableAppender, null, null);
        return tableAppender.toString();
    }
}

