/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Logger;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.measure.ElevationAngle;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.AxisFilter;
import org.apache.sis.referencing.cs.AxisName;
import org.apache.sis.referencing.cs.Codes;
import org.apache.sis.referencing.cs.DefaultCompoundCS;
import org.apache.sis.referencing.cs.DirectionAlongMeridian;
import org.apache.sis.referencing.cs.Normalizer;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Static;
import org.apache.sis.util.logging.Logging;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.operation.Matrix;

public final class CoordinateSystems
extends Static {
    private CoordinateSystems() {
    }

    public static boolean isGeodetic(CoordinateSystem coordinateSystem) {
        return coordinateSystem instanceof EllipsoidalCS || coordinateSystem instanceof CartesianCS || coordinateSystem instanceof SphericalCS;
    }

    public static AxisDirection parseAxisDirection(String string) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("name", string);
        string = CharSequences.trimWhitespaces(string);
        AxisDirection axisDirection = AxisDirections.valueOf(string);
        if (axisDirection != null) {
            return axisDirection;
        }
        DirectionAlongMeridian directionAlongMeridian = DirectionAlongMeridian.parse(string);
        if (directionAlongMeridian != null) {
            axisDirection = directionAlongMeridian.getDirection();
            assert (axisDirection == AxisDirections.valueOf(directionAlongMeridian.toString()));
            return axisDirection;
        }
        throw new IllegalArgumentException(Resources.format((short)67, string));
    }

    public static AxisDirection directionAlongMeridian(AxisDirection axisDirection, double d) {
        return new DirectionAlongMeridian(axisDirection, d).getDirection();
    }

    public static boolean isAlongMeridian(AxisDirection axisDirection) {
        return AxisDirections.isUserDefined(axisDirection) && DirectionAlongMeridian.matches(axisDirection.name());
    }

    public static org.apache.sis.measure.Angle angle(AxisDirection axisDirection, AxisDirection axisDirection2) {
        DirectionAlongMeridian directionAlongMeridian;
        ArgumentChecks.ensureNonNull("source", axisDirection);
        ArgumentChecks.ensureNonNull("target", axisDirection2);
        int n = AxisDirections.angleForCompass(axisDirection, axisDirection2);
        if (n != Integer.MIN_VALUE) {
            return new org.apache.sis.measure.Angle((double)n * 22.5);
        }
        n = AxisDirections.angleForGeocentric(axisDirection, axisDirection2);
        if (n != Integer.MIN_VALUE) {
            return new org.apache.sis.measure.Angle(n * 90);
        }
        n = AxisDirections.angleForVehicle(axisDirection, axisDirection2);
        if (n != Integer.MIN_VALUE) {
            return new org.apache.sis.measure.Angle(n * 90);
        }
        n = AxisDirections.angleForDisplay(axisDirection, axisDirection2);
        if (n != Integer.MIN_VALUE) {
            return new org.apache.sis.measure.Angle(n * 90);
        }
        DirectionAlongMeridian directionAlongMeridian2 = AxisDirections.isUserDefined(axisDirection) ? DirectionAlongMeridian.parse(axisDirection) : null;
        DirectionAlongMeridian directionAlongMeridian3 = directionAlongMeridian = AxisDirections.isUserDefined(axisDirection2) ? DirectionAlongMeridian.parse(axisDirection2) : null;
        if (directionAlongMeridian2 != null && directionAlongMeridian != null) {
            return new org.apache.sis.measure.Angle(directionAlongMeridian2.angle(directionAlongMeridian));
        }
        boolean bl = AxisDirections.isVertical(axisDirection);
        boolean bl2 = AxisDirections.isVertical(axisDirection2);
        if (bl2) {
            if (bl) {
                return new org.apache.sis.measure.Angle(axisDirection.equals((Object)axisDirection2) ? 0.0 : (axisDirection2.equals((Object)AxisDirection.UP) ? 180.0 : -180.0));
            }
            if (AxisDirections.isCompass(axisDirection) || directionAlongMeridian2 != null) {
                return axisDirection2.equals((Object)AxisDirection.UP) ? ElevationAngle.ZENITH : ElevationAngle.NADIR;
            }
        } else if (bl && (AxisDirections.isCompass(axisDirection2) || directionAlongMeridian != null)) {
            return axisDirection.equals((Object)AxisDirection.UP) ? ElevationAngle.NADIR : ElevationAngle.ZENITH;
        }
        return null;
    }

    private static void components(CoordinateSystem coordinateSystem, List<CoordinateSystem> list) {
        if (coordinateSystem instanceof DefaultCompoundCS) {
            for (CoordinateSystem coordinateSystem2 : ((DefaultCompoundCS)coordinateSystem).getComponents()) {
                CoordinateSystems.components(coordinateSystem2, list);
            }
        } else {
            list.add(coordinateSystem);
        }
    }

    static boolean hasAllTargetTypes(CoordinateSystem coordinateSystem, CoordinateSystem coordinateSystem2) {
        ArrayList<CoordinateSystem> arrayList = new ArrayList<CoordinateSystem>(coordinateSystem.getDimension());
        ArrayList<CoordinateSystem> arrayList2 = new ArrayList<CoordinateSystem>(coordinateSystem2.getDimension());
        CoordinateSystems.components(coordinateSystem, arrayList);
        CoordinateSystems.components(coordinateSystem2, arrayList2);
        block0: for (CoordinateSystem coordinateSystem3 : arrayList2) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!Classes.implementSameInterfaces(((CoordinateSystem)arrayList.get(i)).getClass(), coordinateSystem3.getClass(), CoordinateSystem.class)) continue;
                arrayList.remove(i);
                continue block0;
            }
            return false;
        }
        return true;
    }

    public static Matrix swapAndScaleAxes(CoordinateSystem coordinateSystem, CoordinateSystem coordinateSystem2) throws IllegalArgumentException, IncommensurableException {
        ArgumentChecks.ensureNonNull("sourceCS", coordinateSystem);
        ArgumentChecks.ensureNonNull("targetCS", coordinateSystem2);
        if (!Classes.implementSameInterfaces(coordinateSystem.getClass(), coordinateSystem2.getClass(), CoordinateSystem.class) && !CoordinateSystems.hasAllTargetTypes(coordinateSystem, coordinateSystem2)) {
            throw new IllegalArgumentException(Resources.format((short)27));
        }
        Object[] objectArray = CoordinateSystems.getAxisDirections(coordinateSystem);
        Object[] objectArray2 = CoordinateSystems.getAxisDirections(coordinateSystem2);
        MatrixSIS matrixSIS = Matrices.createTransform((AxisDirection[])objectArray, (AxisDirection[])objectArray2);
        assert (Arrays.equals(objectArray, objectArray2) == matrixSIS.isIdentity()) : matrixSIS;
        int n = matrixSIS.getNumCol() - 1;
        int n2 = matrixSIS.getNumRow() - 1;
        for (int i = 0; i < n2; ++i) {
            Unit unit = coordinateSystem2.getAxis(i).getUnit();
            for (int j = 0; j < n; ++j) {
                Unit unit2;
                if (matrixSIS.getElement(i, j) == 0.0 || Objects.equals(unit2 = coordinateSystem.getAxis(j).getUnit(), unit)) continue;
                Number number = 1;
                Number number2 = 0;
                Number[] numberArray = Units.coefficients(unit2.getConverterToAny(unit));
                switch (numberArray != null ? numberArray.length : -1) {
                    case 2: {
                        number = numberArray[1];
                    }
                    case 1: {
                        number2 = numberArray[0];
                    }
                    case 0: {
                        break;
                    }
                    default: {
                        throw new IncommensurableException(Resources.format((short)54, unit2, unit));
                    }
                }
                DoubleDouble doubleDouble = DoubleDouble.castOrCopy(matrixSIS.getNumber(i, j));
                DoubleDouble doubleDouble2 = new DoubleDouble(doubleDouble);
                doubleDouble2.multiplyGuessError(number);
                matrixSIS.setNumber(i, j, doubleDouble2);
                doubleDouble2.setFrom(doubleDouble);
                doubleDouble2.multiplyGuessError(number2);
                doubleDouble2.addGuessError(matrixSIS.getNumber(i, n));
                matrixSIS.setNumber(i, n, doubleDouble2);
            }
        }
        return matrixSIS;
    }

    public static CoordinateSystem replaceAxes(CoordinateSystem coordinateSystem, AxisFilter axisFilter) {
        ArgumentChecks.ensureNonNull("filter", axisFilter);
        if (coordinateSystem != null) {
            AbstractCS abstractCS;
            if (axisFilter instanceof AxesConvention) {
                if (coordinateSystem instanceof AbstractCS) {
                    return ((AbstractCS)coordinateSystem).forConvention((AxesConvention)axisFilter);
                }
                abstractCS = Normalizer.forConvention(coordinateSystem, (AxesConvention)axisFilter);
            } else {
                abstractCS = Normalizer.normalize(coordinateSystem, axisFilter, false);
            }
            if (abstractCS != null) {
                return abstractCS;
            }
        }
        return coordinateSystem;
    }

    public static CoordinateSystem replaceLinearUnit(CoordinateSystem coordinateSystem, final Unit<Length> unit) {
        ArgumentChecks.ensureNonNull("newUnit", unit);
        return CoordinateSystems.replaceAxes(coordinateSystem, new AxisFilter(){

            @Override
            public Unit<?> getUnitReplacement(CoordinateSystemAxis coordinateSystemAxis, Unit<?> unit2) {
                return Units.isLinear(unit2) ? unit : unit2;
            }
        });
    }

    public static CoordinateSystem replaceAngularUnit(CoordinateSystem coordinateSystem, final Unit<Angle> unit) {
        ArgumentChecks.ensureNonNull("newUnit", unit);
        return CoordinateSystems.replaceAxes(coordinateSystem, new AxisFilter(){

            @Override
            public Unit<?> getUnitReplacement(CoordinateSystemAxis coordinateSystemAxis, Unit<?> unit2) {
                return Units.isAngular(unit2) ? unit : unit2;
            }
        });
    }

    public static AxisDirection[] getAxisDirections(CoordinateSystem coordinateSystem) {
        ArgumentChecks.ensureNonNull("cs", coordinateSystem);
        AxisDirection[] axisDirectionArray = new AxisDirection[coordinateSystem.getDimension()];
        for (int i = 0; i < axisDirectionArray.length; ++i) {
            CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(i);
            ArgumentChecks.ensureNonNullElement("cs", i, coordinateSystem);
            axisDirectionArray[i] = coordinateSystemAxis.getDirection();
            ArgumentChecks.ensureNonNullElement("cs[#].direction", i, axisDirectionArray[i]);
        }
        return axisDirectionArray;
    }

    public static String getShortName(CoordinateSystemAxis coordinateSystemAxis, Locale locale) {
        ArgumentChecks.ensureNonNull("axis", coordinateSystemAxis);
        return AxisName.find(coordinateSystemAxis, locale);
    }

    public static Integer getEpsgCode(Class<? extends CoordinateSystem> clazz, CoordinateSystemAxis ... coordinateSystemAxisArray) {
        ArgumentChecks.ensureNonNull("type", clazz);
        ArgumentChecks.ensureNonNull("axes", coordinateSystemAxisArray);
        block1 : switch (coordinateSystemAxisArray.length) {
            case 3: {
                if (!Units.METRE.equals((Object)coordinateSystemAxisArray[2].getUnit())) break;
            }
            case 2: {
                boolean bl;
                Unit unit = coordinateSystemAxisArray[0].getUnit();
                if (unit == null || !unit.equals((Object)coordinateSystemAxisArray[1].getUnit()) || (!(bl = Units.isAngular(unit)) || !clazz.isAssignableFrom(EllipsoidalCS.class)) && (!Units.isLinear(unit) || !clazz.isAssignableFrom(CartesianCS.class))) break;
                AxisDirection[] axisDirectionArray = new AxisDirection[coordinateSystemAxisArray.length];
                for (int i = 0; i < axisDirectionArray.length; ++i) {
                    CoordinateSystemAxis coordinateSystemAxis = coordinateSystemAxisArray[i];
                    ArgumentChecks.ensureNonNullElement("axes", i, coordinateSystemAxis);
                    axisDirectionArray[i] = coordinateSystemAxis.getDirection();
                    if (!bl || !RangeMeaning.WRAPAROUND.equals((Object)coordinateSystemAxis.getRangeMeaning())) continue;
                    try {
                        UnitConverter unitConverter = unit.getConverterToAny(Units.DEGREE);
                        double d = unitConverter.convert(coordinateSystemAxis.getMinimumValue());
                        double d2 = unitConverter.convert(coordinateSystemAxis.getMaximumValue());
                        if (d > Double.NEGATIVE_INFINITY && Math.abs(d - -180.0) > 8.999280057595393E-8) break block1;
                        if (!(d2 < Double.POSITIVE_INFINITY) || !(Math.abs(d2 - 180.0) > 8.999280057595393E-8)) continue;
                    }
                    catch (IncommensurableException incommensurableException) {
                        Logging.unexpectedException(Logger.getLogger("org.apache.sis.referencing"), CoordinateSystems.class, "getEpsgCode", incommensurableException);
                    }
                    break block1;
                }
                return CoordinateSystems.getEpsgCode(unit, axisDirectionArray);
            }
        }
        return null;
    }

    public static Integer getEpsgCode(Unit<?> unit, AxisDirection ... axisDirectionArray) {
        ArgumentChecks.ensureNonNull("unit", unit);
        ArgumentChecks.ensureNonNull("directions", axisDirectionArray);
        short s = Codes.lookup(unit, axisDirectionArray);
        return s != 0 ? Integer.valueOf(s) : null;
    }
}

