/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.util.logging.Logger;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.AbstractDerivedCRS;
import org.apache.sis.referencing.crs.DefaultProjectedCRS;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.util.logging.Logging;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Conversion;

final class ExplicitParameters
extends FormattableObject {
    private final Conversion conversion;
    private final Ellipsoid ellipsoid;
    private final String keyword;

    ExplicitParameters(AbstractDerivedCRS<?> abstractDerivedCRS, String string) {
        this.conversion = abstractDerivedCRS.getConversionFromBase();
        Datum datum = abstractDerivedCRS.getDatum();
        this.ellipsoid = datum instanceof GeodeticDatum ? ((GeodeticDatum)datum).getEllipsoid() : null;
        this.keyword = string;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        WKTUtilities.appendName((IdentifiedObject)this.conversion, formatter, null);
        formatter.newLine();
        this.append(formatter);
        return this.keyword;
    }

    void append(Formatter formatter) {
        formatter.append(DefaultOperationMethod.castOrCopy(this.conversion.getMethod()));
        formatter.newLine();
        for (GeneralParameterValue generalParameterValue : this.conversion.getParameterValues().values()) {
            block6: {
                String string;
                block7: {
                    GeneralParameterDescriptor generalParameterDescriptor = generalParameterValue.getDescriptor();
                    if (this.ellipsoid == null) break block6;
                    string = "semi_major";
                    if (IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)generalParameterDescriptor, "semi_major")) break block7;
                    string = "semi_minor";
                    if (!IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)generalParameterDescriptor, "semi_minor")) break block6;
                }
                if (generalParameterValue instanceof ParameterValue) {
                    double d;
                    double d2;
                    try {
                        d2 = ((ParameterValue)generalParameterValue).doubleValue(this.ellipsoid.getAxisUnit());
                    }
                    catch (IllegalStateException illegalStateException) {
                        Logging.recoverableException(Logger.getLogger("org.apache.sis.io.wkt"), DefaultProjectedCRS.class, "formatTo", illegalStateException);
                        continue;
                    }
                    if (Double.isNaN(d2)) continue;
                    double d3 = d = string == "semi_minor" ? this.ellipsoid.getSemiMinorAxis() : this.ellipsoid.getSemiMajorAxis();
                    if (d2 == d) continue;
                }
            }
            WKTUtilities.append(generalParameterValue, formatter);
        }
    }
}

