/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.internal.referencing.provider.GeodeticOperation;
import org.apache.sis.internal.referencing.provider.GeographicToGeocentric;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.FactoryException;

public final class GeocentricToGeographic
extends GeodeticOperation {
    private static final long serialVersionUID = 8459294628751497567L;
    public static final String NAME = "Geocentric_To_Ellipsoid";
    public static final ParameterDescriptorGroup PARAMETERS = ((ParameterBuilder)GeocentricToGeographic.builder().addName(Citations.OGC, "Geocentric_To_Ellipsoid")).createGroupForMapProjection(GeographicToGeocentric.DIMENSION);

    public GeocentricToGeographic() {
        this(3, new GeocentricToGeographic[4]);
        this.redimensioned[2] = new GeocentricToGeographic(2, this.redimensioned);
        this.redimensioned[3] = this;
    }

    private GeocentricToGeographic(int n, GeodeticOperation[] geodeticOperationArray) {
        super(Conversion.class, PARAMETERS, CartesianCS.class, 3, false, EllipsoidalCS.class, n, true, geodeticOperationArray);
    }

    @Override
    public AbstractProvider inverse() {
        return null;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory mathTransformFactory, ParameterValueGroup parameterValueGroup) throws FactoryException {
        MathTransform mathTransform = GeographicToGeocentric.create(mathTransformFactory, Parameters.castOrWrap(parameterValueGroup));
        try {
            mathTransform = mathTransform.inverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new FactoryException((Throwable)noninvertibleTransformException);
        }
        return mathTransform;
    }
}

