/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.GenericName;

@XmlTransient
public abstract class AbstractProvider
extends DefaultOperationMethod
implements MathTransformProvider {
    private static final long serialVersionUID = 1165868434518724597L;
    private final Class<? extends SingleOperation> operationType;
    public final Class<? extends CoordinateSystem> sourceCSType;
    public final Class<? extends CoordinateSystem> targetCSType;
    public final boolean sourceOnEllipsoid;
    public final boolean targetOnEllipsoid;

    protected AbstractProvider(Map<String, ?> map, int n, int n2, ParameterDescriptorGroup parameterDescriptorGroup) {
        super(map, n, n2, parameterDescriptorGroup);
        this.operationType = SingleOperation.class;
        this.sourceCSType = CoordinateSystem.class;
        this.targetCSType = CoordinateSystem.class;
        this.sourceOnEllipsoid = false;
        this.targetOnEllipsoid = false;
    }

    AbstractProvider(Class<? extends SingleOperation> clazz, ParameterDescriptorGroup parameterDescriptorGroup, Class<? extends CoordinateSystem> clazz2, int n, boolean bl, Class<? extends CoordinateSystem> clazz3, int n2, boolean bl2) {
        super(AbstractProvider.toMap((IdentifiedObject)parameterDescriptorGroup), n, n2, parameterDescriptorGroup);
        this.operationType = clazz;
        this.sourceCSType = clazz2;
        this.targetCSType = clazz3;
        this.sourceOnEllipsoid = bl;
        this.targetOnEllipsoid = bl2;
    }

    private static Map<String, Object> toMap(IdentifiedObject identifiedObject) {
        Collection collection;
        ArgumentChecks.ensureNonNull("parameters", identifiedObject);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("name", identifiedObject.getName());
        Set set = identifiedObject.getIdentifiers();
        int n = set.size();
        if (n != 0) {
            hashMap.put("identifiers", set.toArray(new ReferenceIdentifier[n]));
        }
        if ((n = (collection = identifiedObject.getAlias()).size()) != 0) {
            hashMap.put("alias", collection.toArray(new GenericName[n]));
        }
        return hashMap;
    }

    static ParameterBuilder builder() {
        return ((ParameterBuilder)new ParameterBuilder().setCodeSpace(Citations.EPSG, "EPSG")).setRequired(true);
    }

    static ParameterBuilder addNameAndLegacy(ParameterBuilder parameterBuilder, String string, String string2) {
        return (ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addName(string)).setDeprecated(true)).setRemarks((CharSequence)Vocabulary.formatInternational((short)190, (Object)string))).addName(string2)).setDeprecated(false)).setRemarks(null);
    }

    static ParameterBuilder addIdentifierAndLegacy(ParameterBuilder parameterBuilder, String string, String string2) {
        return (ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier(string)).setDeprecated(true)).setRemarks((CharSequence)Vocabulary.formatInternational((short)190, (Object)string))).addIdentifier(string2)).setDeprecated(false)).setRemarks(null);
    }

    static ParameterDescriptor<Double> createZeroConstant(ParameterBuilder parameterBuilder) {
        Double d = 0.0;
        return parameterBuilder.createBounded(MeasurementRange.create(-0.0, true, d, true, Units.DEGREE), d);
    }

    static ParameterDescriptor<Double> createMandatoryLatitude(ParameterBuilder parameterBuilder) {
        return parameterBuilder.createBounded(-90.0, 90.0, Double.NaN, Units.DEGREE);
    }

    static ParameterDescriptor<Double> createLatitude(ParameterBuilder parameterBuilder, boolean bl) {
        return parameterBuilder.createBounded(MeasurementRange.create(-90.0, bl, 90.0, bl, Units.DEGREE), 0.0);
    }

    static ParameterDescriptor<Double> createLongitude(ParameterBuilder parameterBuilder) {
        return parameterBuilder.createBounded(-180.0, 180.0, 0.0, Units.DEGREE);
    }

    static ParameterDescriptor<Double> createScale(ParameterBuilder parameterBuilder) {
        return parameterBuilder.createStrictlyPositive(1.0, Units.UNITY);
    }

    static ParameterDescriptor<Double> createShift(ParameterBuilder parameterBuilder) {
        return parameterBuilder.create(0.0, Units.METRE);
    }

    public String resolveAmbiguity(DefaultMathTransformFactory.Context context) {
        return null;
    }

    @Override
    public final Class<? extends SingleOperation> getOperationType() {
        return this.operationType;
    }

    public AbstractProvider inverse() {
        return null;
    }

    static void recoverableException(Class<? extends AbstractProvider> clazz, Exception exception) {
        Logging.recoverableException(Logger.getLogger("org.apache.sis.referencing.operation"), clazz, "createMathTransform", exception);
    }
}

