/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.j2d;

import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.operation.Matrix;

final class AffineMatrix
implements ExtendedPrecisionMatrix,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1605578645060388327L;
    private static final int SIZE = 3;
    private static final int LENGTH = 9;
    private static final int LENGTH_STORED = 6;
    private static final int LENGTH_EXTENDED = 18;
    private final AffineTransform transform;
    private final double[] errors;

    AffineMatrix(AffineTransform affineTransform) {
        this.transform = affineTransform;
        this.errors = null;
    }

    AffineMatrix(AffineTransform affineTransform, double[] dArray) {
        this.transform = affineTransform;
        if (dArray.length == 18) {
            this.errors = Arrays.copyOfRange(dArray, 9, 15);
        } else {
            assert (dArray.length == 9);
            this.errors = null;
        }
    }

    public int getNumRow() {
        return 3;
    }

    public int getNumCol() {
        return 3;
    }

    public boolean isIdentity() {
        return this.transform.isIdentity();
    }

    @Override
    public double[] getExtendedElements() {
        double[] dArray = new double[this.errors != null ? 18 : 9];
        if (this.errors != null) {
            System.arraycopy(this.errors, 0, dArray, 9, 6);
        }
        dArray[0] = this.transform.getScaleX();
        dArray[1] = this.transform.getShearX();
        dArray[2] = this.transform.getTranslateX();
        dArray[3] = this.transform.getShearY();
        dArray[4] = this.transform.getScaleY();
        dArray[5] = this.transform.getTranslateY();
        dArray[8] = 1.0;
        return dArray;
    }

    public final double getElement(int n, int n2) {
        ArgumentChecks.ensureBetween("row", 0, 3, n);
        ArgumentChecks.ensureBetween("column", 0, 3, n2);
        switch (n * 3 + n2) {
            case 0: {
                return this.transform.getScaleX();
            }
            case 1: {
                return this.transform.getShearX();
            }
            case 2: {
                return this.transform.getTranslateX();
            }
            case 3: {
                return this.transform.getShearY();
            }
            case 4: {
                return this.transform.getScaleY();
            }
            case 5: {
                return this.transform.getTranslateY();
            }
            case 6: 
            case 7: {
                return 0.0;
            }
            case 8: {
                return 1.0;
            }
        }
        throw new AssertionError();
    }

    public final void setElement(int n, int n2, double d) {
        throw new UnsupportedOperationException(Resources.format((short)68));
    }

    public final Matrix clone() {
        return Matrices.copy(this);
    }

    public boolean equals(Object object) {
        if (object instanceof AffineMatrix) {
            AffineMatrix affineMatrix = (AffineMatrix)object;
            return this.transform.equals(affineMatrix.transform) && Arrays.equals(this.errors, affineMatrix.errors);
        }
        return false;
    }

    public int hashCode() {
        return this.transform.hashCode() * 31 + Arrays.hashCode(this.errors) ^ 0x5DC705E7;
    }

    public String toString() {
        return Matrices.toString(this);
    }
}

