/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.awt.geom.Point2D;
import java.util.Objects;
import org.apache.sis.geometry.AbstractDirectPosition;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DirectPosition2D
extends Point2D.Double
implements DirectPosition,
Cloneable {
    private static final long serialVersionUID = 6063110617109934018L;
    private CoordinateReferenceSystem crs;

    public DirectPosition2D() {
    }

    public DirectPosition2D(CoordinateReferenceSystem coordinateReferenceSystem) {
        ArgumentChecks.ensureDimensionMatches("crs", 2, coordinateReferenceSystem);
        this.crs = coordinateReferenceSystem;
    }

    public DirectPosition2D(Point2D point2D) {
        super(point2D.getX(), point2D.getY());
    }

    public DirectPosition2D(double d, double d2) {
        super(d, d2);
    }

    public DirectPosition2D(CoordinateReferenceSystem coordinateReferenceSystem, double d, double d2) {
        super(d, d2);
        this.crs = coordinateReferenceSystem;
        ArgumentChecks.ensureDimensionMatches("crs", 2, coordinateReferenceSystem);
    }

    public DirectPosition2D(DirectPosition directPosition) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull("position", directPosition);
        ArgumentChecks.ensureDimensionMatches("position", 2, directPosition);
        this.x = directPosition.getOrdinate(0);
        this.y = directPosition.getOrdinate(1);
        this.crs = directPosition.getCoordinateReferenceSystem();
    }

    public DirectPosition2D(CharSequence charSequence) throws IllegalArgumentException {
        double[] dArray = AbstractDirectPosition.parse(charSequence);
        if (dArray == null) {
            throw new IllegalArgumentException(Errors.format((short)154, "POINT", charSequence));
        }
        ArgumentChecks.ensureDimensionMatches("wkt", 2, dArray);
        this.x = dArray[0];
        this.y = dArray[1];
    }

    public final DirectPosition getDirectPosition() {
        return this;
    }

    public final int getDimension() {
        return 2;
    }

    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) {
        ArgumentChecks.ensureDimensionMatches("crs", 2, coordinateReferenceSystem);
        this.crs = coordinateReferenceSystem;
    }

    public final double[] getCoordinate() {
        return new double[]{this.x, this.y};
    }

    public final double getOrdinate(int n) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IndexOutOfBoundsException(Errors.format((short)71, n));
    }

    public void setOrdinate(int n, double d) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                this.x = d;
                break;
            }
            case 1: {
                this.y = d;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Errors.format((short)71, n));
            }
        }
    }

    @Override
    public void setLocation(Point2D point2D) {
        CoordinateReferenceSystem coordinateReferenceSystem;
        super.setLocation(point2D);
        if (point2D instanceof DirectPosition && (coordinateReferenceSystem = ((DirectPosition)point2D).getCoordinateReferenceSystem()) != null) {
            this.setCoordinateReferenceSystem(coordinateReferenceSystem);
        }
    }

    @Override
    public String toString() {
        return AbstractDirectPosition.toString(this, ArraysExt.isSinglePrecision(this.x, this.y));
    }

    @Override
    public int hashCode() {
        int n = 31 + Double.hashCode(this.x);
        n = n * 31 + Double.hashCode(this.y);
        return n + Objects.hashCode(this.crs);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof DirectPosition) {
            DirectPosition directPosition = (DirectPosition)object;
            if (directPosition.getDimension() == 2 && Double.doubleToLongBits(directPosition.getOrdinate(0)) == Double.doubleToLongBits(this.x) && Double.doubleToLongBits(directPosition.getOrdinate(1)) == Double.doubleToLongBits(this.y) && Objects.equals(directPosition.getCoordinateReferenceSystem(), this.crs)) {
                assert (this.hashCode() == directPosition.hashCode()) : this;
                return true;
            }
            return false;
        }
        return super.equals(object);
    }

    @Override
    public DirectPosition2D clone() {
        return (DirectPosition2D)super.clone();
    }
}

