/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.maintenance;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.internal.metadata.legacy.LegacyPropertyAdapter;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.DefaultCitationDate;
import org.apache.sis.metadata.iso.maintenance.DefaultScope;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.maintenance.MaintenanceFrequency;
import org.opengis.metadata.maintenance.MaintenanceInformation;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.maintenance.ScopeDescription;
import org.opengis.metadata.quality.Scope;
import org.opengis.temporal.PeriodDuration;
import org.opengis.util.InternationalString;

@XmlType(name="MD_MaintenanceInformation_Type", propOrder={"maintenanceAndUpdateFrequency", "maintenanceDate", "dateOfNextUpdate", "userDefinedMaintenanceFrequency", "maintenanceScope", "updateScopes", "updateScopeDescriptions", "maintenanceNotes", "contacts"})
@XmlRootElement(name="MD_MaintenanceInformation")
public class DefaultMaintenanceInformation
extends ISOMetadata
implements MaintenanceInformation {
    private static final long serialVersionUID = -8736825706141936429L;
    private static final DateType NEXT_UPDATE = DateType.valueOf((String)"NEXT_UPDATE");
    private MaintenanceFrequency maintenanceAndUpdateFrequency;
    private Collection<CitationDate> maintenanceDates;
    private PeriodDuration userDefinedMaintenanceFrequency;
    private Collection<Scope> maintenanceScopes;
    private Collection<InternationalString> maintenanceNotes;
    private Collection<ResponsibleParty> contacts;

    public DefaultMaintenanceInformation() {
    }

    public DefaultMaintenanceInformation(MaintenanceFrequency maintenanceFrequency) {
        this.maintenanceAndUpdateFrequency = maintenanceFrequency;
    }

    public DefaultMaintenanceInformation(MaintenanceInformation maintenanceInformation) {
        super(maintenanceInformation);
        if (maintenanceInformation != null) {
            this.maintenanceAndUpdateFrequency = maintenanceInformation.getMaintenanceAndUpdateFrequency();
            this.userDefinedMaintenanceFrequency = maintenanceInformation.getUserDefinedMaintenanceFrequency();
            this.maintenanceNotes = this.copyCollection(maintenanceInformation.getMaintenanceNotes(), InternationalString.class);
            if (maintenanceInformation instanceof DefaultMaintenanceInformation) {
                DefaultMaintenanceInformation defaultMaintenanceInformation = (DefaultMaintenanceInformation)maintenanceInformation;
                this.maintenanceDates = this.copyCollection(defaultMaintenanceInformation.getMaintenanceDates(), CitationDate.class);
                this.maintenanceScopes = this.copyCollection(defaultMaintenanceInformation.getMaintenanceScopes(), Scope.class);
                this.contacts = this.copyCollection(defaultMaintenanceInformation.getContacts(), ResponsibleParty.class);
            } else {
                this.setDateOfNextUpdate(maintenanceInformation.getDateOfNextUpdate());
                this.setUpdateScopes(maintenanceInformation.getUpdateScopes());
                this.setUpdateScopeDescriptions(maintenanceInformation.getUpdateScopeDescriptions());
            }
        }
    }

    public static DefaultMaintenanceInformation castOrCopy(MaintenanceInformation maintenanceInformation) {
        if (maintenanceInformation == null || maintenanceInformation instanceof DefaultMaintenanceInformation) {
            return (DefaultMaintenanceInformation)maintenanceInformation;
        }
        return new DefaultMaintenanceInformation(maintenanceInformation);
    }

    @XmlElement(name="maintenanceAndUpdateFrequency")
    public MaintenanceFrequency getMaintenanceAndUpdateFrequency() {
        return this.maintenanceAndUpdateFrequency;
    }

    public void setMaintenanceAndUpdateFrequency(MaintenanceFrequency maintenanceFrequency) {
        this.checkWritePermission(this.maintenanceAndUpdateFrequency);
        this.maintenanceAndUpdateFrequency = maintenanceFrequency;
    }

    @UML(identifier="maintenanceDate", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<CitationDate> getMaintenanceDates() {
        this.maintenanceDates = this.nonNullCollection(this.maintenanceDates, CitationDate.class);
        return this.maintenanceDates;
    }

    public void setMaintenanceDates(Collection<? extends CitationDate> collection) {
        this.maintenanceDates = this.writeCollection(collection, this.maintenanceDates, CitationDate.class);
    }

    @Deprecated
    @Dependencies(value={"getMaintenanceDates"})
    @XmlElement(name="dateOfNextUpdate", namespace="http://www.isotc211.org/2005/gmd")
    public Date getDateOfNextUpdate() {
        Collection<CitationDate> collection;
        if (FilterByVersion.LEGACY_METADATA.accept() && (collection = this.getMaintenanceDates()) != null) {
            for (CitationDate citationDate : collection) {
                if (!NEXT_UPDATE.equals((Object)citationDate.getDateType())) continue;
                return citationDate.getDate();
            }
        }
        return null;
    }

    @Deprecated
    public void setDateOfNextUpdate(Date date) {
        Object object;
        this.checkWritePermission(ImplementationHelper.valueIfDefined(this.maintenanceDates));
        Collection<CitationDate> collection = this.maintenanceDates;
        if (collection != null) {
            object = collection.iterator();
            while (object.hasNext()) {
                CitationDate citationDate = object.next();
                if (!NEXT_UPDATE.equals((Object)citationDate.getDateType())) continue;
                if (date == null) {
                    object.remove();
                    return;
                }
                if (!(citationDate instanceof DefaultCitationDate)) continue;
                ((DefaultCitationDate)citationDate).setDate(date);
                return;
            }
        }
        if (date != null) {
            object = new DefaultCitationDate(date, NEXT_UPDATE);
            if (collection != null) {
                collection.add((CitationDate)object);
            } else {
                collection = Collections.singleton(object);
            }
            this.setMaintenanceDates(collection);
        }
    }

    @XmlElement(name="userDefinedMaintenanceFrequency")
    public PeriodDuration getUserDefinedMaintenanceFrequency() {
        return this.userDefinedMaintenanceFrequency;
    }

    public void setUserDefinedMaintenanceFrequency(PeriodDuration periodDuration) {
        this.checkWritePermission(this.userDefinedMaintenanceFrequency);
        this.userDefinedMaintenanceFrequency = periodDuration;
    }

    @UML(identifier="maintenanceScope", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Scope> getMaintenanceScopes() {
        this.maintenanceScopes = this.nonNullCollection(this.maintenanceScopes, Scope.class);
        return this.maintenanceScopes;
    }

    public void setMaintenanceScopes(Collection<? extends Scope> collection) {
        this.maintenanceScopes = this.writeCollection(collection, this.maintenanceScopes, Scope.class);
    }

    @Deprecated
    @Dependencies(value={"getMaintenanceScopes"})
    @XmlElement(name="updateScope", namespace="http://www.isotc211.org/2005/gmd")
    public final Collection<ScopeCode> getUpdateScopes() {
        if (!FilterByVersion.LEGACY_METADATA.accept()) {
            return null;
        }
        return new LegacyPropertyAdapter<ScopeCode, Scope>(this.getMaintenanceScopes()){

            @Override
            protected Scope wrap(ScopeCode scopeCode) {
                return new DefaultScope(scopeCode);
            }

            @Override
            protected ScopeCode unwrap(Scope scope) {
                return scope.getLevel();
            }

            @Override
            protected boolean update(Scope scope, ScopeCode scopeCode) {
                if (scope instanceof DefaultScope) {
                    ((DefaultScope)scope).setLevel(scopeCode);
                    return true;
                }
                return false;
            }
        }.validOrNull();
    }

    @Deprecated
    public void setUpdateScopes(Collection<? extends ScopeCode> collection) {
        this.checkWritePermission(ImplementationHelper.valueIfDefined(this.maintenanceScopes));
        ((LegacyPropertyAdapter)this.getUpdateScopes()).setValues(collection);
    }

    @Deprecated
    @Dependencies(value={"getMaintenanceScopes"})
    @XmlElement(name="updateScopeDescription", namespace="http://www.isotc211.org/2005/gmd")
    public final Collection<ScopeDescription> getUpdateScopeDescriptions() {
        if (!FilterByVersion.LEGACY_METADATA.accept()) {
            return null;
        }
        return new LegacyPropertyAdapter<ScopeDescription, Scope>(this.getMaintenanceScopes()){

            @Override
            protected Scope wrap(ScopeDescription scopeDescription) {
                DefaultScope defaultScope = new DefaultScope();
                defaultScope.setLevelDescription(CollectionsExt.singletonOrEmpty(scopeDescription));
                return defaultScope;
            }

            @Override
            protected ScopeDescription unwrap(Scope scope) {
                return 2.getSingleton(scope.getLevelDescription(), ScopeDescription.class, this, DefaultMaintenanceInformation.class, "getUpdateScopeDescriptions");
            }

            @Override
            protected boolean update(Scope scope, ScopeDescription scopeDescription) {
                if (scope instanceof DefaultScope) {
                    ((DefaultScope)scope).setLevelDescription(CollectionsExt.singletonOrEmpty(scopeDescription));
                    return true;
                }
                return false;
            }
        }.validOrNull();
    }

    @Deprecated
    public void setUpdateScopeDescriptions(Collection<? extends ScopeDescription> collection) {
        this.checkWritePermission(ImplementationHelper.valueIfDefined(this.maintenanceScopes));
        ((LegacyPropertyAdapter)this.getUpdateScopeDescriptions()).setValues(collection);
    }

    @XmlElement(name="maintenanceNote")
    public Collection<InternationalString> getMaintenanceNotes() {
        this.maintenanceNotes = this.nonNullCollection(this.maintenanceNotes, InternationalString.class);
        return this.maintenanceNotes;
    }

    public void setMaintenanceNotes(Collection<? extends InternationalString> collection) {
        this.maintenanceNotes = this.writeCollection(collection, this.maintenanceNotes, InternationalString.class);
    }

    @XmlElement(name="contact")
    public Collection<ResponsibleParty> getContacts() {
        this.contacts = this.nonNullCollection(this.contacts, ResponsibleParty.class);
        return this.contacts;
    }

    public void setContacts(Collection<? extends ResponsibleParty> collection) {
        this.contacts = this.writeCollection(collection, this.contacts, ResponsibleParty.class);
    }

    @XmlElement(name="maintenanceDate")
    private Collection<CitationDate> getMaintenanceDate() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getMaintenanceDates() : null;
    }

    @XmlElement(name="maintenanceScope")
    private Collection<Scope> getMaintenanceScope() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getMaintenanceScopes() : null;
    }
}

