/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.extent;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.SpatialTemporalExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.referencing.operation.TransformException;

@XmlType(name="EX_SpatialTemporalExtent_Type")
@XmlRootElement(name="EX_SpatialTemporalExtent")
public class DefaultSpatialTemporalExtent
extends DefaultTemporalExtent
implements SpatialTemporalExtent {
    private static final long serialVersionUID = -2461142677245013474L;
    private Collection<GeographicExtent> spatialExtent;
    private VerticalExtent verticalExtent;

    public DefaultSpatialTemporalExtent() {
    }

    public DefaultSpatialTemporalExtent(GeographicExtent geographicExtent, VerticalExtent verticalExtent, TemporalExtent temporalExtent) {
        super(temporalExtent);
        this.verticalExtent = verticalExtent;
        this.spatialExtent = this.singleton(geographicExtent, GeographicExtent.class);
    }

    public DefaultSpatialTemporalExtent(SpatialTemporalExtent spatialTemporalExtent) {
        super((TemporalExtent)spatialTemporalExtent);
        if (spatialTemporalExtent != null) {
            this.spatialExtent = this.copyCollection(spatialTemporalExtent.getSpatialExtent(), GeographicExtent.class);
            if (spatialTemporalExtent instanceof DefaultSpatialTemporalExtent) {
                this.verticalExtent = ((DefaultSpatialTemporalExtent)spatialTemporalExtent).getVerticalExtent();
            }
        }
    }

    public static DefaultSpatialTemporalExtent castOrCopy(SpatialTemporalExtent spatialTemporalExtent) {
        if (spatialTemporalExtent == null || spatialTemporalExtent instanceof DefaultSpatialTemporalExtent) {
            return (DefaultSpatialTemporalExtent)spatialTemporalExtent;
        }
        return new DefaultSpatialTemporalExtent(spatialTemporalExtent);
    }

    @XmlElement(name="spatialExtent", required=true)
    public Collection<GeographicExtent> getSpatialExtent() {
        this.spatialExtent = this.nonNullCollection(this.spatialExtent, GeographicExtent.class);
        return this.spatialExtent;
    }

    public void setSpatialExtent(Collection<? extends GeographicExtent> collection) {
        this.spatialExtent = this.writeCollection(collection, this.spatialExtent, GeographicExtent.class);
    }

    @XmlElement(name="verticalExtent")
    @UML(identifier="verticalExtent", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public VerticalExtent getVerticalExtent() {
        return this.verticalExtent;
    }

    public void setVerticalExtent(VerticalExtent verticalExtent) {
        this.checkWritePermission(this.verticalExtent);
        this.verticalExtent = verticalExtent;
    }

    @Override
    public void setBounds(Envelope envelope) throws TransformException {
        this.checkWritePermission(ImplementationHelper.valueIfDefined(this.spatialExtent));
        ReferencingServices.getInstance().setBounds(envelope, this);
    }
}

