/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.distribution;

import java.util.Currency;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.gco.GO_Record;
import org.apache.sis.internal.jaxb.gco.GO_RecordType;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.distribution.StandardOrderProcess;
import org.opengis.util.InternationalString;
import org.opengis.util.Record;
import org.opengis.util.RecordType;

@XmlType(name="MD_StandardOrderProcess_Type", propOrder={"fees", "plannedAvailableDateTime", "orderingInstructions", "turnaround", "orderOptionsType", "orderOptions"})
@XmlRootElement(name="MD_StandardOrderProcess")
public class DefaultStandardOrderProcess
extends ISOMetadata
implements StandardOrderProcess {
    private static final long serialVersionUID = 1948951192071039775L;
    private InternationalString fees;
    private Currency currency;
    private long plannedAvailableDateTime = Long.MIN_VALUE;
    private InternationalString orderingInstructions;
    private InternationalString turnaround;
    private RecordType orderOptionsType;
    private Record orderOptions;

    public DefaultStandardOrderProcess() {
    }

    public DefaultStandardOrderProcess(StandardOrderProcess standardOrderProcess) {
        super(standardOrderProcess);
        if (standardOrderProcess != null) {
            this.fees = standardOrderProcess.getFees();
            this.plannedAvailableDateTime = ImplementationHelper.toMilliseconds(standardOrderProcess.getPlannedAvailableDateTime());
            this.orderingInstructions = standardOrderProcess.getOrderingInstructions();
            this.turnaround = standardOrderProcess.getTurnaround();
            if (standardOrderProcess instanceof DefaultStandardOrderProcess) {
                this.orderOptionsType = ((DefaultStandardOrderProcess)standardOrderProcess).getOrderOptionsType();
                this.orderOptions = ((DefaultStandardOrderProcess)standardOrderProcess).getOrderOptions();
            }
        }
    }

    public static DefaultStandardOrderProcess castOrCopy(StandardOrderProcess standardOrderProcess) {
        if (standardOrderProcess == null || standardOrderProcess instanceof DefaultStandardOrderProcess) {
            return (DefaultStandardOrderProcess)standardOrderProcess;
        }
        return new DefaultStandardOrderProcess(standardOrderProcess);
    }

    @XmlElement(name="fees")
    public InternationalString getFees() {
        return this.fees;
    }

    public void setFees(InternationalString internationalString) {
        this.checkWritePermission(this.fees);
        this.fees = internationalString;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.checkWritePermission(this.currency);
        this.currency = currency;
    }

    @XmlElement(name="plannedAvailableDateTime")
    public Date getPlannedAvailableDateTime() {
        return ImplementationHelper.toDate(this.plannedAvailableDateTime);
    }

    public void setPlannedAvailableDateTime(Date date) {
        this.checkWritePermission(this.plannedAvailableDateTime);
        this.plannedAvailableDateTime = ImplementationHelper.toMilliseconds(date);
    }

    @XmlElement(name="orderingInstructions")
    public InternationalString getOrderingInstructions() {
        return this.orderingInstructions;
    }

    public void setOrderingInstructions(InternationalString internationalString) {
        this.checkWritePermission(this.orderingInstructions);
        this.orderingInstructions = internationalString;
    }

    @XmlElement(name="turnaround")
    public InternationalString getTurnaround() {
        return this.turnaround;
    }

    public void setTurnaround(InternationalString internationalString) {
        this.checkWritePermission(this.turnaround);
        this.turnaround = internationalString;
    }

    @XmlElement(name="orderOptionsType")
    @XmlJavaTypeAdapter(value=GO_RecordType.Since2014.class)
    @UML(identifier="orderOptionsType", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public RecordType getOrderOptionsType() {
        return this.orderOptionsType;
    }

    public RecordType getOrderOptionType() {
        return this.getOrderOptionsType();
    }

    public void setOrderOptionsType(RecordType recordType) {
        this.checkWritePermission(this.orderOptionsType);
        this.orderOptionsType = recordType;
    }

    @Deprecated
    public void setOrderOptionType(RecordType recordType) {
        this.setOrderOptionsType(recordType);
    }

    @XmlElement(name="orderOptions")
    @XmlJavaTypeAdapter(value=GO_Record.Since2014.class)
    @UML(identifier="orderOptions", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Record getOrderOptions() {
        return this.orderOptions;
    }

    public void setOrderOptions(Record record) {
        this.checkWritePermission(this.orderOptions);
        this.orderOptions = record;
    }
}

