/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.gmi.MI_ImageDescription;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.content.DefaultCoverageDescription;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.content.CoverageDescription;
import org.opengis.metadata.content.ImageDescription;
import org.opengis.metadata.content.ImagingCondition;

@XmlType(name="MD_ImageDescription_Type", propOrder={"illuminationElevationAngle", "illuminationAzimuthAngle", "imagingCondition", "imageQualityCode", "cloudCoverPercentage", "processingLevel", "compressionGenerationQuantity", "triangulationIndicator", "radiometricCalibrationDataAvailable", "cameraCalibrationInformationAvailable", "filmDistortionInformationAvailable", "lensDistortionInformationAvailable"})
@XmlRootElement(name="MD_ImageDescription")
@XmlSeeAlso(value={MI_ImageDescription.class})
public class DefaultImageDescription
extends DefaultCoverageDescription
implements ImageDescription {
    private static final long serialVersionUID = -239683653229623567L;
    private Double illuminationElevationAngle;
    private Double illuminationAzimuthAngle;
    private ImagingCondition imagingCondition;
    private Identifier imageQualityCode;
    private Double cloudCoverPercentage;
    private Integer compressionGenerationQuantity;
    private Boolean triangulationIndicator;
    private Boolean radiometricCalibrationDataAvailable;
    private Boolean cameraCalibrationInformationAvailable;
    private Boolean filmDistortionInformationAvailable;
    private Boolean lensDistortionInformationAvailable;

    public DefaultImageDescription() {
    }

    public DefaultImageDescription(ImageDescription imageDescription) {
        super((CoverageDescription)imageDescription);
        if (imageDescription != null) {
            this.illuminationElevationAngle = imageDescription.getIlluminationElevationAngle();
            this.illuminationAzimuthAngle = imageDescription.getIlluminationAzimuthAngle();
            this.imagingCondition = imageDescription.getImagingCondition();
            this.imageQualityCode = imageDescription.getImageQualityCode();
            this.cloudCoverPercentage = imageDescription.getCloudCoverPercentage();
            this.compressionGenerationQuantity = imageDescription.getCompressionGenerationQuantity();
            this.triangulationIndicator = imageDescription.getTriangulationIndicator();
            this.radiometricCalibrationDataAvailable = imageDescription.isRadiometricCalibrationDataAvailable();
            this.cameraCalibrationInformationAvailable = imageDescription.isCameraCalibrationInformationAvailable();
            this.filmDistortionInformationAvailable = imageDescription.isFilmDistortionInformationAvailable();
            this.lensDistortionInformationAvailable = imageDescription.isLensDistortionInformationAvailable();
        }
    }

    public static DefaultImageDescription castOrCopy(ImageDescription imageDescription) {
        if (imageDescription == null || imageDescription instanceof DefaultImageDescription) {
            return (DefaultImageDescription)imageDescription;
        }
        return new DefaultImageDescription(imageDescription);
    }

    @ValueRange(minimum=-90.0, maximum=90.0)
    @XmlElement(name="illuminationElevationAngle")
    public Double getIlluminationElevationAngle() {
        return this.illuminationElevationAngle;
    }

    public void setIlluminationElevationAngle(Double d) {
        this.checkWritePermission(this.illuminationElevationAngle);
        if (ImplementationHelper.ensureInRange(DefaultImageDescription.class, "illuminationElevationAngle", -90, 90, d)) {
            this.illuminationElevationAngle = d;
        }
    }

    @ValueRange(minimum=0.0, maximum=360.0)
    @XmlElement(name="illuminationAzimuthAngle")
    public Double getIlluminationAzimuthAngle() {
        return this.illuminationAzimuthAngle;
    }

    public void setIlluminationAzimuthAngle(Double d) {
        this.checkWritePermission(this.illuminationAzimuthAngle);
        if (ImplementationHelper.ensureInRange(DefaultImageDescription.class, "illuminationAzimuthAngle", 0, 360, d)) {
            this.illuminationAzimuthAngle = d;
        }
    }

    @XmlElement(name="imagingCondition")
    public ImagingCondition getImagingCondition() {
        return this.imagingCondition;
    }

    public void setImagingCondition(ImagingCondition imagingCondition) {
        this.checkWritePermission(this.imagingCondition);
        this.imagingCondition = imagingCondition;
    }

    @XmlElement(name="imageQualityCode")
    public Identifier getImageQualityCode() {
        return this.imageQualityCode;
    }

    public void setImageQualityCode(Identifier identifier) {
        this.checkWritePermission(this.imageQualityCode);
        this.imageQualityCode = identifier;
    }

    @ValueRange(minimum=0.0, maximum=100.0)
    @XmlElement(name="cloudCoverPercentage")
    public Double getCloudCoverPercentage() {
        return this.cloudCoverPercentage;
    }

    public void setCloudCoverPercentage(Double d) {
        this.checkWritePermission(this.cloudCoverPercentage);
        if (ImplementationHelper.ensureInRange(DefaultImageDescription.class, "cloudCoverPercentage", 0, 100, d)) {
            this.cloudCoverPercentage = d;
        }
    }

    @ValueRange(minimum=0.0)
    @XmlElement(name="compressionGenerationQuantity")
    public Integer getCompressionGenerationQuantity() {
        return this.compressionGenerationQuantity;
    }

    public void setCompressionGenerationQuantity(Integer n) {
        this.checkWritePermission(this.compressionGenerationQuantity);
        if (ImplementationHelper.ensurePositive(DefaultImageDescription.class, "compressionGenerationQuantity", false, n)) {
            this.compressionGenerationQuantity = n;
        }
    }

    @XmlElement(name="triangulationIndicator")
    public Boolean getTriangulationIndicator() {
        return this.triangulationIndicator;
    }

    public void setTriangulationIndicator(Boolean bl) {
        this.checkWritePermission(this.triangulationIndicator);
        this.triangulationIndicator = bl;
    }

    @XmlElement(name="radiometricCalibrationDataAvailability")
    public Boolean isRadiometricCalibrationDataAvailable() {
        return this.radiometricCalibrationDataAvailable;
    }

    public void setRadiometricCalibrationDataAvailable(Boolean bl) {
        this.checkWritePermission(this.radiometricCalibrationDataAvailable);
        this.radiometricCalibrationDataAvailable = bl;
    }

    @XmlElement(name="cameraCalibrationInformationAvailability")
    public Boolean isCameraCalibrationInformationAvailable() {
        return this.cameraCalibrationInformationAvailable;
    }

    public void setCameraCalibrationInformationAvailable(Boolean bl) {
        this.checkWritePermission(this.cameraCalibrationInformationAvailable);
        this.cameraCalibrationInformationAvailable = bl;
    }

    @XmlElement(name="filmDistortionInformationAvailability")
    public Boolean isFilmDistortionInformationAvailable() {
        return this.filmDistortionInformationAvailable;
    }

    public void setFilmDistortionInformationAvailable(Boolean bl) {
        this.checkWritePermission(this.filmDistortionInformationAvailable);
        this.filmDistortionInformationAvailable = bl;
    }

    @XmlElement(name="lensDistortionInformationAvailability")
    public Boolean isLensDistortionInformationAvailable() {
        return this.lensDistortionInformationAvailable;
    }

    public void setLensDistortionInformationAvailable(Boolean bl) {
        this.checkWritePermission(this.lensDistortionInformationAvailable);
        this.lensDistortionInformationAvailable = bl;
    }

    @XmlElement(name="processingLevelCode", namespace="http://www.isotc211.org/2005/gmd")
    private Identifier getProcessingLevel() {
        return FilterByVersion.LEGACY_METADATA.accept() ? this.getProcessingLevelCode() : null;
    }

    private void setProcessingLevel(Identifier identifier) {
        this.setProcessingLevelCode(identifier);
    }
}

