/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.acquisition;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.acquisition.EnvironmentalRecord;
import org.opengis.util.InternationalString;

@XmlType(name="MI_EnvironmentalRecord_Type", propOrder={"averageAirTemperature", "maxRelativeHumidity", "maxAltitude", "meteorologicalConditions"})
@XmlRootElement(name="MI_EnvironmentalRecord")
public class DefaultEnvironmentalRecord
extends ISOMetadata
implements EnvironmentalRecord {
    private static final long serialVersionUID = 3634348015931833471L;
    private Double averageAirTemperature;
    private Double maxRelativeHumidity;
    private Double maxAltitude;
    private InternationalString meteorologicalConditions;

    public DefaultEnvironmentalRecord() {
    }

    public DefaultEnvironmentalRecord(EnvironmentalRecord environmentalRecord) {
        super(environmentalRecord);
        if (environmentalRecord != null) {
            this.averageAirTemperature = environmentalRecord.getAverageAirTemperature();
            this.maxRelativeHumidity = environmentalRecord.getMaxRelativeHumidity();
            this.maxAltitude = environmentalRecord.getMaxAltitude();
            this.meteorologicalConditions = environmentalRecord.getMeteorologicalConditions();
        }
    }

    public static DefaultEnvironmentalRecord castOrCopy(EnvironmentalRecord environmentalRecord) {
        if (environmentalRecord == null || environmentalRecord instanceof DefaultEnvironmentalRecord) {
            return (DefaultEnvironmentalRecord)environmentalRecord;
        }
        return new DefaultEnvironmentalRecord(environmentalRecord);
    }

    @XmlElement(name="averageAirTemperature", required=true)
    public Double getAverageAirTemperature() {
        return this.averageAirTemperature;
    }

    public void setAverageAirTemperature(Double d) {
        this.checkWritePermission(this.averageAirTemperature);
        this.averageAirTemperature = d;
    }

    @ValueRange(minimum=0.0, maximum=100.0)
    @XmlElement(name="maxRelativeHumidity", required=true)
    public Double getMaxRelativeHumidity() {
        return this.maxRelativeHumidity;
    }

    public void setMaxRelativeHumidity(Double d) {
        this.checkWritePermission(this.maxRelativeHumidity);
        if (ImplementationHelper.ensureInRange(DefaultEnvironmentalRecord.class, "maxRelativeHumidity", 0, 100, d)) {
            this.maxRelativeHumidity = d;
        }
    }

    @XmlElement(name="maxAltitude", required=true)
    public Double getMaxAltitude() {
        return this.maxAltitude;
    }

    public void setMaxAltitude(Double d) {
        this.checkWritePermission(this.maxAltitude);
        this.maxAltitude = d;
    }

    @XmlElement(name="meterologicalConditions", required=true)
    public InternationalString getMeteorologicalConditions() {
        return this.meteorologicalConditions;
    }

    public void setMeteorologicalConditions(InternationalString internationalString) {
        this.checkWritePermission(this.meteorologicalConditions);
        this.meteorologicalConditions = internationalString;
    }
}

